package org.esupportail.portal.channels.CIntranet.actions.intranet;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CIntranet.beans.Document;
import org.esupportail.portal.channels.CIntranet.beans.DocumentFile;
import org.esupportail.portal.channels.CIntranet.beans.DocumentLink;
import org.esupportail.portal.channels.CIntranet.data.DataControler;
import org.esupportail.portal.channels.CIntranet.data.DataException;
import org.esupportail.portal.channels.CIntranet.security.Security;
import org.esupportail.portal.channels.CIntranet.storage.IStorageControler;
import org.esupportail.portal.channels.CIntranet.storage.StorageException;
import org.esupportail.portal.channels.CIntranet.storage.StorageFactory;
import org.esupportail.portal.channels.CIntranet.utils.Date;
import org.esupportail.portal.channels.CIntranet.utils.Notifier;
import org.esupportail.portal.channels.CIntranet.utils.SizeLimitException;
import org.esupportail.portal.channels.CIntranet.utils.UploadWorker;
import org.esupportail.portal.utils.channels.Action;
import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.channels.MainChannel;
import org.esupportail.portal.utils.channels.plugins.Message;
import org.esupportail.portal.utils.channels.plugins.MessageBean;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.PortalException;

/**
 * ModifyDocument<br>
 * <br>
 * Cette classe prend en charge la modification d'un document<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version $Revision: 1.1.2.7 $
 * 
 */
public class ModifyDocument extends AbstractAction {

    protected static Log log = LogFactory.getLog(ModifyDocument.class);
    
    private Document doc = null;
    private DocumentFile docfile = null;
    private DocumentLink doclink = null;
    
    /**
     * Constructeur
     * @param mainChannel La channel principale
     */
    public ModifyDocument(MainChannel mainChannel) {
        super(mainChannel);
    }

    /**
     * Indique le niveau requis pour raliser cette action
     * Implements AbstractAction.getLevel() method
     * @return level Le niveau requis pour accder  cette action
     */
    public int getLevel() {
        return Security.AUT_MOD;
    }
    
    /**
     * Etape 2/4 du cycle de vie de la SubChannel
     * Affiche le formulaire de modification de document
     * Override SubChannel.init() method
     * @param rd Les runtimeData
     * @return Boolean TRUE si tout se passe bien, FALSE sinon
     * @throws PortalException
     * @throws FrameWorkException
     */
    public Boolean init(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
        super.init(rd);
        if(super.initialize(rd).equals(Boolean.FALSE)) {
            return Boolean.FALSE;
        }
        if(log.isDebugEnabled()) {
            log.debug("ModifyDocument::init()");
        }
        String id = getRuntimeData().getParameter("id");
        if(id == null || id.equals("")) {
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean("Erreur d'acc\u00E8s \u00E0 la page"), "intranet");
            return Boolean.FALSE;
        }
        DataControler data = new DataControler();
        try {
            doc = data.getDocument(intranet.getId(), id);
        }
        catch(DataException e) {
            log.error("ModifyDocument::init() : DataException:\n" + e);
            Hashtable parameters = new Hashtable();
            parameters.put("folder", folderid);
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean(e.getMessage()), "viewfolder", parameters);
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }
    
    /**
     * Etape 3/4 du cycle de vie de la SubChannel
     * Affiche le formulaire de modification de document
     * Override SubChannel.setXML() method
     * @return Boolean TRUE si tout se passe bien, FALSE sinon
     * @throws FrameWorkException
     */
    public Boolean setXML() throws FrameWorkException {
        if(log.isDebugEnabled()) {
            log.debug("NewDocument::setXML()");
        }
        setXML(doc.toXMLString());
        getXSLParameter().put("folder", folderid);
        return Boolean.TRUE;
    }
    
    /**
     * Etape 4/4 du cycle de vie de la SubChannel
     * Choix de la feuille de style fichier/lien
     * Override SubChannel.setOutput() method
     * @throws FrameWorkException
     */
    public void setOutput() throws FrameWorkException {
        if(log.isDebugEnabled()) {
            log.debug("NewDocument::setOutput()");
        }
        Action current = mainChannel.getCurrentAction();
		setSSL(current.getSslFile());
		if(doc instanceof DocumentFile) {
		    setXSL("file");
		}
		else {
		    setXSL("link");
		}
    }
    
    /**
     * Etape 2/4 du cycle de vie de la SubChannel
     * Traite la modification du fichier (infos)
     * Override SubChannel.init() method
     * @param rd Les runtimeData
     * @return Boolean TRUE si tout se passe bien, FALSE sinon
     * @throws PortalException
     * @throws FrameWorkException
     */
    public Boolean fileinit(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
        super.init(rd);
        if(super.initialize(rd).equals(Boolean.FALSE)) {
            return Boolean.FALSE;
        }
        if(log.isDebugEnabled()) {
            log.debug("ModifyDocument::fileinit()");
        }
        String description = getRuntimeData().getParameter("description");
        if(description == null || !(doc instanceof DocumentFile)) {
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean("Erreur d'acc\u00E8s \u00E0 la page"), "intranet");
            return Boolean.FALSE;
        }
        if(description.equals("")) {
            Hashtable parameters = new Hashtable();
            parameters.put("folder", folderid);
            parameters.put("id", doc.getId());
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean("Le libell\u00E9 est obligatoire"), "moddocument", parameters);
            return Boolean.FALSE;
        }
        docfile = (DocumentFile)doc;
        if(description.equals(docfile.getDescription())) {
            getRuntimeData().setParameter("folder", folderid);
            getMainChannel().redirect(getRuntimeData(), "viewfolder");
            return Boolean.FALSE;
        }
        docfile.setDescription(description);
        docfile.setFile(docfile.getName() + docfile.getExtension());
        docfile.setAuthor(userid);
        docfile.setDate(Date.getCurrentDate());
        DataControler data = new DataControler();
        IStorageControler store = StorageFactory.make(intranet.getRessource());
        try {
            Document olddoc = data.getDocument(intranet.getId(), doc.getId());
            if(level < Security.AUT_FULL) {
                data.updateDocument(docfile, true);
                store.saveDocument(intranet.getId(), docfile, store.loadDocument(intranet.getId(), olddoc));
            }
            else {
                data.updateDocument(docfile, false);
            }
            data.commit();
            data.close();
            
            if(doc.isValid()) {
		    	Notifier.sendNotification(doc, Notifier.FILE_MODIFIED);
		    }
        }
        catch(DataException e) {
            log.error("ModifyDocument::linkinit() : DataException:\n" + e);
            Hashtable parameters = new Hashtable();
            parameters.put("folder", folderid);
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean(e.getMessage()), "viewfolder", parameters);
            return Boolean.FALSE;
        }
        catch(StorageException e) {
            log.error("ModifyDocument::linkinit() : StorageException:\n" + e);
            data.rollback();
            data.close();
            Hashtable parameters = new Hashtable();
            parameters.put("folder", folderid);
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean(e.getMessage()), "viewfolder", parameters);
            return Boolean.FALSE;
        }
        
        getRuntimeData().setParameter("folder", folderid);
        getMainChannel().redirect(getRuntimeData(), "viewfolder");
        return Boolean.FALSE;
    }
    
    /**
     * Etape 2/4 du cycle de vie de la SubChannel
     * Traite la modification du fichier (contenu)
     * Override SubChannel.init() method
     * @param rd Les runtimeData
     * @return Boolean TRUE si tout se passe bien, FALSE sinon
     * @throws PortalException
     * @throws FrameWorkException
     */
    public Boolean contentinit(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
        super.init(rd);
        if(super.initialize(rd).equals(Boolean.FALSE)) {
            return Boolean.FALSE;
        }
        if(log.isDebugEnabled()) {
            log.debug("ModifyDocument::contentinit()");
        }
        if(!(doc instanceof DocumentFile)) {
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean("Erreur d'acc\u00E8s \u00E0 la page"), "intranet");
            return Boolean.FALSE;
        }
        docfile = (DocumentFile)doc;
        UploadWorker worker = new UploadWorker(getRuntimeData());
		try {
			worker.parseFile("file");
		}
		catch(SizeLimitException e) {
			Hashtable parameters = new Hashtable();
			parameters.put("folder", folderid);
			parameters.put("id", doc.getId());
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean("Le fichier joint est trop gros"), "moddocument", parameters);
			return Boolean.FALSE;
		}
		catch(FileNotFoundException e) {
			Hashtable parameters = new Hashtable();
			parameters.put("folder", folderid);
			parameters.put("id", doc.getId());
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean("Aucun fichier attach\u00E9"), "moddocument", parameters);
			return Boolean.FALSE;
		}
		InputStream filestream = null;
		try {
			filestream = worker.getInputStream();
		}
		catch(IOException e) {
			log.error("ModifyDocument::contentinit() : IOException :\n" + e);
			Hashtable parameters = new Hashtable();
			parameters.put("folder", folderid);
			parameters.put("id", doc.getId());
            Message.message(mainChannel, runtimeData, new MessageBean("Impossible de r\u00E9cup\u00E9rer le fichier joint"), "viewfolder", parameters);
			return Boolean.FALSE;
		}
		docfile.setFile(worker.getName());
		docfile.setExtension(docfile.getFile().substring(docfile.getFile().lastIndexOf(".")));
		docfile.setName(docfile.getFile().substring(0, docfile.getFile().lastIndexOf(".")));
		docfile.setAuthor(userid);
		docfile.setDate(Date.getCurrentDate());
		DataControler data = new DataControler();
        IStorageControler store = StorageFactory.make(intranet.getRessource());
        try {
            if(level < Security.AUT_FULL) {
                data.updateDocument(docfile, true);
                store.saveDocument(intranet.getId(), docfile, filestream);
            }
            else {
                data.updateDocument(doc, false);
                store.destroyDocument(intranet.getId(), docfile);
                store.saveDocument(intranet.getId(), docfile, filestream);
            }
            data.commit();
            data.close();
            
            if(doc.isValid()) {
		    	Notifier.sendNotification(doc, Notifier.FILE_MODIFIED);
		    }
        }
        catch(DataException e) {
            log.error("ModifyDocument::contentinit() : DataException:\n" + e);
            Hashtable parameters = new Hashtable();
            parameters.put("folder", folderid);
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean(e.getMessage()), "viewfolder", parameters);
            return Boolean.FALSE;
        }
        catch(StorageException e) {
            log.error("ModifyDocument::contentinit() : StorageException:\n" + e);
            data.rollback();
            data.close();
            Hashtable parameters = new Hashtable();
            parameters.put("folder", folderid);
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean(e.getMessage()), "viewfolder", parameters);
            return Boolean.FALSE;
        }
        
        getRuntimeData().setParameter("folder", folderid);
        getMainChannel().redirect(getRuntimeData(), "viewfolder");
        return Boolean.FALSE;
    }
    
    /**
     * Etape 2/4 du cycle de vie de la SubChannel
     * Traite la modification du lien
     * Override SubChannel.init() method
     * @param rd Les runtimeData
     * @return Boolean TRUE si tout se passe bien, FALSE sinon
     * @throws PortalException
     * @throws FrameWorkException
     */
    public Boolean linkinit(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
        super.init(rd);
        if(super.initialize(rd).equals(Boolean.FALSE)) {
            return Boolean.FALSE;
        }
        if(log.isDebugEnabled()) {
            log.debug("ModifyDocument::linkinit()");
        }
        String description = getRuntimeData().getParameter("description");
        String link = getRuntimeData().getParameter("link");
        if(description == null || link == null || !(doc instanceof DocumentLink)) {
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean("Erreur d'acc\u00E8s \u00E0 la page"), "intranet");
            return Boolean.FALSE;
        }
        if(description.equals("") || link.equals("")) {
            Hashtable parameters = new Hashtable();
            parameters.put("folder", folderid);
            parameters.put("id", doc.getId());
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean("Les champs 'description' et 'lien' sont obligatoires"), "moddocument", parameters);
            return Boolean.FALSE;
        }
        if(!link.matches("^http[s]{0,1}://.*$")) {
            Hashtable parameters = new Hashtable();
            parameters.put("folder", folderid);
            parameters.put("id", doc.getId());
            Message.message(mainChannel, runtimeData, new MessageBean("Mauvaise adresse, une adresse valide est du type http(s)://www.exemple.com"), "moddocument", parameters);
			return Boolean.FALSE;
        }
        doclink = (DocumentLink)doc;
        if(description.equals(doclink.getDescription()) && link.equals(doclink.getUrl())) {
            getRuntimeData().setParameter("folder", folderid);
            getMainChannel().redirect(getRuntimeData(), "viewfolder");
            return Boolean.FALSE;
        }
        doclink.setDescription(description);
        doclink.setUrl(link);
        DataControler data = new DataControler();
        try {
            if(level < Security.AUT_FULL) {
                data.updateDocument(doclink, true);
            }
            else {
                data.updateDocument(doclink, false);
            }
            data.commit();
            data.close();
            
            if(doc.isValid()) {
		    	Notifier.sendNotification(doc, Notifier.LINK_MODIFIED);
		    }
        }
        catch(DataException e) {
            log.error("ModifyDocument::linkinit() : DataException:\n" + e);
            Hashtable parameters = new Hashtable();
            parameters.put("folder", folderid);
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean(e.getMessage()), "viewfolder", parameters);
            return Boolean.FALSE;
        }
        
        getRuntimeData().setParameter("folder", folderid);
        getMainChannel().redirect(getRuntimeData(), "viewfolder");
        return Boolean.FALSE;
    }

    /**
     * Etape 2/4 du cycle de vie de la SubChannel
     * Traite la modification de la date de premption
     * Override SubChannel.init() method
     * @param rd Les runtimeData
     * @return Boolean TRUE si tout se passe bien, FALSE sinon
     * @throws PortalException
     * @throws FrameWorkException
     */
    public Boolean dateinit(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
        super.init(rd);
        if(super.initialize(rd).equals(Boolean.FALSE)) {
            return Boolean.FALSE;
        }
        if(log.isDebugEnabled()) {
            log.debug("ModifyDocument::dateinit()");
        }
        String date = getRuntimeData().getParameter("date");
         if(date == null) {
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean("Erreur d'acc\u00E8s \u00E0 la page"), "intranet");
            return Boolean.FALSE;
        }
        if(date.equals("")) {
            date = "99999999";
        }
        else {
            if(!date.matches("[0-9]{2}/[0-9]{2}/[0-9]{4}")) {
                Hashtable parameters = new Hashtable();
                parameters.put("folder", folderid);
                parameters.put("id", doc.getId());
                Message.message(getMainChannel(), getRuntimeData(), new MessageBean("Mauvais format de date"), "moddocument", parameters);
                return Boolean.FALSE;
            }
            date = date.substring(6) + date.substring(3, 5) + date.substring(0, 2);
            if(date.compareTo(Date.getCurrentDate()) < 0) {
                Hashtable parameters = new Hashtable();
                parameters.put("folder", folderid);
                parameters.put("id", doc.getId());
                Message.message(getMainChannel(), getRuntimeData(), new MessageBean("La date est d\u00E9j\u00E0 d\u00E9pass\u00E9e"), "moddocument", parameters);
                return Boolean.FALSE;
            }
        }
        doc.setValidityDate(date);
        DataControler data = new DataControler();
        try {
            data.updateDocument(doc, false);
            data.commit();
            data.close();
        }
        catch(DataException e) {
            log.error("ModifyDocument::dateinit() : DataException:\n" + e);
            Hashtable parameters = new Hashtable();
            parameters.put("folder", folderid);
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean(e.getMessage()), "viewfolder", parameters);
            return Boolean.FALSE;
        }
        getRuntimeData().setParameter("folder", folderid);
        getMainChannel().redirect(getRuntimeData(), "viewfolder");
        return Boolean.FALSE;
    }

}
