package org.esupportail.portal.channels.CIntranet.actions.intranet;

import java.util.Hashtable;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CIntranet.data.DataControler;
import org.esupportail.portal.channels.CIntranet.data.DataException;
import org.esupportail.portal.channels.CIntranet.security.Security;
import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.channels.MainChannel;
import org.esupportail.portal.utils.channels.plugins.Message;
import org.esupportail.portal.utils.channels.plugins.MessageBean;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.PortalException;

/**
 * OrderDocument<br>
 * <br>
 * Cette classe prend en charge la modification d'ordre des documents<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version $Revision: 1.1.2.3 $
 * 
 */
public class OrderDocument extends AbstractAction {

    protected static Log log = LogFactory.getLog(OrderDocument.class);
    
    /**
     * Constructeur
     * @param mainChannel La channel principale
     */
    public OrderDocument(MainChannel mainChannel) {
        super(mainChannel);
    }
    
    /**
     * Indique le niveau requis pour raliser cette action
     * Implements AbstractAction.getLevel() method
     * @return level Le niveau requis pour accder  cette action
     */
    public int getLevel() {
        return Security.ED_VAL;
    }
    
    /**
     * Etape 2/4 du cycle de vie de la SubChannel
     * Modifie l'ordre d'un document
     * Override SubChannel.init() method
     * @param rd Les runtimeData
     * @return Boolean TRUE si tout se passe bien, FALSE sinon
     * @throws PortalException
     * @throws FrameWorkException
     */
    public Boolean init(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
        super.init(rd);
        if(super.initialize(rd).equals(Boolean.FALSE)) {
            return Boolean.FALSE;
        }
        if(log.isDebugEnabled()) {
            log.debug("OrderDocument::init()");
        }
		String id = runtimeData.getParameter("id");
		String rank = runtimeData.getParameter("rank");
		String direction = runtimeData.getParameter("dir");
		if(id == null || rank == null || direction == null) {
			log.error("OrderDocument::init() : Erreur d'acc\u00E8s \u00E0 la page");
			Message.message(getMainChannel(), getRuntimeData(), new MessageBean("Erreur d'acc\u00E8s \u00E0 la page"), "intranet");		
			return Boolean.FALSE;
		}
		int order = Integer.parseInt(rank);
        DataControler data = new DataControler();
        try {
			if(direction.equals("up")) {
			    data.swapDocuments(folderid, id, order, order - 1);
			}
			else {
			    data.swapDocuments(folderid, id, order, order + 1);
			}
		}
        catch(DataException e) {
            log.error("OrderDocument::init() : DataException :\n" + e);
            Hashtable parameters = new Hashtable();
            parameters.put("folder", folderid);
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean(e.getMessage()), "intranet", parameters);
            return Boolean.FALSE;
        }
        getRuntimeData().setParameter("folder", folderid);
        getMainChannel().redirect(getRuntimeData(), "viewfolder");
        return Boolean.TRUE;
    }
}
