package org.esupportail.portal.channels.CIntranet.beans;

import org.esupportail.portal.channels.CIntranet.utils.Date;
import org.jasig.portal.utils.XMLEscaper;

/**
 * Folder<br>
 * <br>
 * Classe dfinissant le comportement d'un dossier<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version $Revision: 1.1.2.4 $
 * 
 */
public class Folder implements Comparable, XMLSerializable {

    private String id = "";
    private String intranet = "";
    private String name = "";
    private int order = 0;
    private String parentid = "";
    private String date = "";
    private boolean notification = false;
    private String mail = null;
    
    /**
     * Constructeur
     */
    public Folder() {
    }
    
    /**
     * Retourne l'identifiant
     * @return id L'identifiant
     */
    public String getId() {
        return id;
    }
    
    /**
     * Positionne l'identifiant
     * @param id L'identifiant
     */
    public void setId(String id) {
        this.id = id;
    }
    
    /**
     * Retourne l'intranet
     * @return intranet L'intranet
     */
    public String getIntranet() {
        return intranet;
    }
    
    /**
     * Positionne l'intranet
     * @param intranet L'intranet
     */
    public void setIntranet(String intranet) {
        this.intranet = intranet;
    }
    
    /**
     * Retourne le nom
     * @return name Le nom
     */
    public String getName() {
        return name;
    }
    
    /**
     * Positionne le nom
     * @param name Le nom
     */
    public void setName(String name) {
        this.name = name;
    }
    
    /**
     * Retourne l'ordre
     * @return order L'ordre
     */
    public int getOrder() {
        return order;
    }
    
    /**
     * Positionne l'ordre 
     * @param order L'ordre
     */
    public void setOrder(int order) {
        this.order = order;
    }
    /**
     * Retourne le parent
     * @return parentid Le parent
     */
    public String getParentid() {
        return parentid;
    }
    
    /**
     * Positionne le parent
     * @param parentid Le parent
     */
    public void setParentid(String parentid) {
        this.parentid = parentid;
    }
    
    /**
     * Retourne la date
     * @return date La date
     */
    public String getDate() {
        return date;
    }
    
    /**
     * Positionne la date
     * @param date La date
     */
    public void setDate(String date) {
        this.date = date;
    }
    
    /**
     * Retoure la notification
     * @return notification La notification
     */
    public boolean isNotifiable() {
    	return notification;
    }
    
    /**
     * Positionne la notification
     * @param notification La notification
     */
    public void setNotifiable(boolean notification) {
    	this.notification = notification;
    }
    
    /**
     * Retourne le mail  notifier
     * @return mail Le mail
     */
    public String getMail() {
    	return mail;
    }
    
    /**
     * Positionne le mail  notifier
     * @param mail Le mail
     */
    public void setMail(String mail) {
    	this.mail = mail;
    }
    
    /**
     * Compare deux dossiers suivant leur nom
     * Implements Comparable interface
     * @param o Objet  comparer
     */
    public int compareTo(Object o) {
        if(!(o instanceof Folder)) {
            throw new ClassCastException("Cannot compare objects from different classes");
        }
        Folder fol = (Folder)o;
        return getOrder() - fol.getOrder();
    }

    /**
     * La reprsentation XML de cet objet
     * Implements XMLSerializable interface
     * @return Le flux XML
     */
    public String toXMLString() {
        StringBuffer xml = new StringBuffer();
        xml.append("<folder id=\"");
        xml.append(getId());
        xml.append("\" intranet=\"");
        xml.append(getIntranet());
        xml.append("\" name=\"");
        xml.append(XMLEscaper.escape(getName()));
        xml.append("\" order=\"");
        xml.append(getOrder());
        xml.append("\" parent=\"");
        xml.append(getParentid());
        xml.append("\" date=\"");
        xml.append(getDate());
        xml.append("\" datetext=\"");
        xml.append(XMLEscaper.escape(Date.formatDate(getDate())));
        xml.append("\" notification=\"");
        xml.append(isNotifiable());
        xml.append("\" mail=\"");
        xml.append(getMail());
        xml.append("\" />\n");
        return xml.toString();
    }

}
