package org.esupportail.portal.channels.CIntranet.actions.intranet;

import java.util.Hashtable;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CIntranet.beans.Folder;
import org.esupportail.portal.channels.CIntranet.data.DataControler;
import org.esupportail.portal.channels.CIntranet.data.DataException;
import org.esupportail.portal.channels.CIntranet.security.Security;
import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.channels.MainChannel;
import org.esupportail.portal.utils.channels.plugins.Message;
import org.esupportail.portal.utils.channels.plugins.MessageBean;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.PortalException;

/**
 * UpdateFolder<br>
 * <br>
 * Cette classe traite la modification d'un dossier<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version $Revision: 1.1.2.2 $
 * 
 */
public class UpdateFolder extends AbstractAction {

    protected static Log log = LogFactory.getLog(UpdateFolder.class);
    
    private Folder folder = null;
    
    /**
     * Constructeur
     * @param mainChannel La channel principale
     */
    public UpdateFolder(MainChannel mainChannel) {
        super(mainChannel);
    }

    /**
     * Indique le niveau requis pour raliser cette action
     * Implements AbstractAction.getLevel() method
     * @return level Le niveau requis pour accder  cette action
     */
    public int getLevel() {
        return Security.AUT_MOD;
    }
    
    /**
     * Etape 2/4 du cycle de vie de la SubChannel
     * Affiche le formulaire de modification de dossier
     * Override SubChannel.init() method
     * @param rd Les runtimeData
     * @return Boolean TRUE si tout se passe bien, FALSE sinon
     * @throws PortalException
     * @throws FrameWorkException
     */
    public Boolean init(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
        super.init(rd);
        if(super.initialize(rd).equals(Boolean.FALSE)) {
            return Boolean.FALSE;
        }
        if(log.isDebugEnabled()) {
            log.debug("UpdateFolder::init()");
        }
        String id = getRuntimeData().getParameter("id");
        if(id == null || id.equals("")) {
            Hashtable parameters = new Hashtable();
            parameters.put("folder", folderid);
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean("Erreur d'acc\u00E8s \u00E0 la page"), "viewfolder", parameters);
            return Boolean.FALSE;
        }
        DataControler data = new DataControler();
        try {
            folder = data.getFolder(id);
        }
        catch(DataException e) {
            log.error("UpdateFolder::init() : DataException :\n" + e);
            Hashtable parameters = new Hashtable();
            parameters.put("folder", folderid);
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean(e.getMessage()), "viewfolder", parameters);
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }
    
    /**
     * Etape 3/4 du cycle de vie de la SubChannel
     * Affiche le formulaire de modification de dossier
     * Override SubChannel.setXML() method
     * @return Boolean TRUE si tout se passe bien, FALSE sinon
     * @throws FrameWorkException
     */
    public Boolean setXML() throws FrameWorkException {
        if(log.isDebugEnabled()) {
            log.debug("UpdateFolder::setXML()");
        }
        setXML(folder.toXMLString());
        getXSLParameter().put("folder", folderid);
        return Boolean.TRUE;
    }
    
    /**
     * Etape 2/4 du cycle de vie de la SubChannel
     * Traite la mise  jour d'un dossier
     * Override SubChannel.init() method
     * @param rd Les runtimeData
     * @return Boolean TRUE si tout se passe bien, FALSE sinon
     * @throws PortalException
     * @throws FrameWorkException
     */
    public Boolean updateinit(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
        super.init(rd);
        if(super.initialize(rd).equals(Boolean.FALSE)) {
            return Boolean.FALSE;
        }
        if(log.isDebugEnabled()) {
            log.debug("UpdateFolder::updateinit()");
        }
        String name = getRuntimeData().getParameter("name");
        String mail = getRuntimeData().getParameter("mail");
        if(name == null || mail == null) {
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean("Erreur d'acc\u00E8s \u00E0 la page"), "intranet");
            return Boolean.FALSE;
        }
        if(name.equals("")) {
            Hashtable parameters = new Hashtable();
            parameters.put("folder", folderid);
            parameters.put("id", folder.getId());
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean("Le nom du dossier est obligatoire"), "modfolder", parameters);
            return Boolean.FALSE;
        }
        if(!folder.getName().equals(name) || !folder.getMail().equals(mail)) {
            folder.setName(name);
            if(mail.equals("")) {
            	folder.setNotifiable(false);
            	folder.setMail("");
            }
            else {
            	if(!mail.matches("^.*@.*\\..*$")) {
            		Hashtable parameters = new Hashtable();
                    parameters.put("folder", folderid);
                    parameters.put("id", folder.getId());
                    Message.message(getMainChannel(), getRuntimeData(), new MessageBean("Adresse de courrier invalide : " + mail), "modfolder", parameters);
                    return Boolean.FALSE;
            	}
            	folder.setNotifiable(true);
            	folder.setMail(mail);
            }
            DataControler data = new DataControler();
            try {
                data.updateFolder(folder);
            }
            catch(DataException e) {
                log.error("UpdateFolder::updateinit() : DataException :\n" + e);
                Hashtable parameters = new Hashtable();
                parameters.put("folder", folderid);
                Message.message(getMainChannel(), getRuntimeData(), new MessageBean(e.getMessage()), "viewfolder", parameters);
                return Boolean.FALSE;
            }
        }
        getRuntimeData().setParameter("folder", folderid);
        getMainChannel().redirect(getRuntimeData(), "viewfolder");
        return Boolean.FALSE;
    }
}
