package org.esupportail.portal.channels.CIntranet.actions.intranet;

import java.util.Hashtable;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CIntranet.beans.Document;
import org.esupportail.portal.channels.CIntranet.beans.DocumentFile;
import org.esupportail.portal.channels.CIntranet.data.DataControler;
import org.esupportail.portal.channels.CIntranet.data.DataException;
import org.esupportail.portal.channels.CIntranet.security.Security;
import org.esupportail.portal.channels.CIntranet.storage.IStorageControler;
import org.esupportail.portal.channels.CIntranet.storage.StorageException;
import org.esupportail.portal.channels.CIntranet.storage.StorageFactory;
import org.esupportail.portal.channels.CIntranet.utils.Notifier;
import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.channels.MainChannel;
import org.esupportail.portal.utils.channels.plugins.Message;
import org.esupportail.portal.utils.channels.plugins.MessageBean;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.PortalException;

/**
 * ValidDocument<br>
 * <br>
 * Cette classe prend en charge la validation d'un document<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version $Revision: 1.1.2.2 $
 * 
 */
public class ValidDocument extends AbstractAction {

    protected static Log log = LogFactory.getLog(ValidDocument.class);
    
    /**
    * Constructeur
    * @param mainChannel La channel principale
    */
    public ValidDocument(MainChannel mainChannel) {
        super(mainChannel);
    }

    /**
     * Indique le niveau requis pour raliser cette action
     * Implements AbstractAction.getLevel() method
     * @return level Le niveau requis pour accder  cette action
     */
    public int getLevel() {
        return Security.ED_VAL;
    }
    
    /**
     * Etape 2/4 du cycle de vie de la SubChannel
     * Valide les changements d'un document
     * Override SubChannel.init() method
     * @param rd Les runtimeData
     * @return Boolean TRUE si tout se passe bien, FALSE sinon
     * @throws PortalException
     * @throws FrameWorkException
     */
    public Boolean valid(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
        super.init(rd);
        if(super.initialize(rd).equals(Boolean.FALSE)) {
            return Boolean.FALSE;
        }
        if(log.isDebugEnabled()) {
            log.debug("ValidDocument::valid()");
        }
        String id = getRuntimeData().getParameter("id");
        if(id == null || id.equals("")) {
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean("Erreur d'acc\u00E8s \u00E0 la page"), "intranet");
            return Boolean.FALSE;
        }
        Document doc = null;
        DataControler data = new DataControler();
        IStorageControler store = StorageFactory.make(intranet.getRessource());
        try {
            doc = data.getDocument(intranet.getId(), id);
            data.validDocument(doc, true);
            if(doc instanceof DocumentFile) {
                if(doc.isPendingDeletion() || doc.isPendingModification()) {
                    store.destroyDocument(intranet.getId(), doc);
                }
            }
            data.commit();
            data.close();
            
            if(!doc.isPendingDeletion()) {
            	if(doc.isPendingModification()) {
            		if(doc instanceof DocumentFile) {
            			Notifier.sendNotification(doc, Notifier.FILE_MODIFIED);
            		}
            		else {
            			Notifier.sendNotification(doc, Notifier.LINK_MODIFIED);
            		}
            	}
            	else {
            		if(doc instanceof DocumentFile) {
            			Notifier.sendNotification(doc, Notifier.FILE_NEW);
            		}
            		else {
            			Notifier.sendNotification(doc, Notifier.LINK_NEW);
            		}
            	}
            }
        }
        catch(DataException e) {
            log.error("ValidDocument::valid() : DataException :\n" + e);
            Hashtable parameters = new Hashtable();
            parameters.put("folder", folderid);
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean(e.getMessage()), "viewfolder", parameters);
            return Boolean.FALSE;
        }
        catch(StorageException e) {
            log.error("ValidDocument::valid() : StorageException :\n" + e);
            data.rollback();
            data.close();
            Hashtable parameters = new Hashtable();
            parameters.put("folder", folderid);
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean(e.getMessage()), "viewfolder", parameters);
            return Boolean.FALSE;
        }
        
        getRuntimeData().setParameter("folder", folderid);
        getMainChannel().redirect(getRuntimeData(), "viewfolder");
        return Boolean.FALSE;
    }
    
    /**
     * Etape 2/4 du cycle de vie de la SubChannel
     * Annule les changements d'un document
     * Override SubChannel.init() method
     * @param rd Les runtimeData
     * @return Boolean TRUE si tout se passe bien, FALSE sinon
     * @throws PortalException
     * @throws FrameWorkException
     */
    public Boolean dismiss(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
        super.init(rd);
        if(super.initialize(rd).equals(Boolean.FALSE)) {
            return Boolean.FALSE;
        }
        if(log.isDebugEnabled()) {
            log.debug("ValidDocument::dismiss()");
        }
        String id = getRuntimeData().getParameter("id");
        if(id == null || id.equals("")) {
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean("Erreur d'acc\u00E8s \u00E0 la page"), "intranet");
            return Boolean.FALSE;
        }
        Document doc = null;
        DataControler data = new DataControler();
        IStorageControler store = StorageFactory.make(intranet.getRessource());
        try {
            doc = data.getDocument(intranet.getId(), id);
            Document docmod = null;
            if(doc instanceof DocumentFile && doc.isPendingModification()) {
                docmod = data.getLinkedDocument(intranet.getId(), id);
            }
            data.validDocument(doc, false);
            if(doc instanceof DocumentFile) {
                if(doc.isPendingModification()) {
                    store.destroyDocument(intranet.getId(), docmod);
                }
                else {
                    if(!doc.isValid()) {
                        store.destroyDocument(intranet.getId(), doc);
                    }
                }
            }
            data.commit();
            data.close();
        }
        catch(DataException e) {
            log.error("ValidDocument::dismiss() : DataException :\n" + e);
            Hashtable parameters = new Hashtable();
            parameters.put("folder", folderid);
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean(e.getMessage()), "viewfolder", parameters);
            return Boolean.FALSE;
        }
        catch(StorageException e) {
            log.error("ValidDocument::dismiss() : StorageException :\n" + e);
            data.rollback();
            data.close();
            Hashtable parameters = new Hashtable();
            parameters.put("folder", folderid);
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean(e.getMessage()), "viewfolder", parameters);
            return Boolean.FALSE;
        }
        getRuntimeData().setParameter("folder", folderid);
        getMainChannel().redirect(getRuntimeData(), "viewfolder");
        return Boolean.FALSE;
    }
}
