package org.esupportail.portal.channels.CIntranet.actions.intranet;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CIntranet.beans.Document;
import org.esupportail.portal.channels.CIntranet.beans.DocumentAuthorComparator;
import org.esupportail.portal.channels.CIntranet.beans.DocumentDateComparator;
import org.esupportail.portal.channels.CIntranet.beans.DocumentOrderComparator;
import org.esupportail.portal.channels.CIntranet.beans.Folder;
import org.esupportail.portal.channels.CIntranet.beans.XMLSerializable;
import org.esupportail.portal.channels.CIntranet.data.DataControler;
import org.esupportail.portal.channels.CIntranet.data.DataException;
import org.esupportail.portal.channels.CIntranet.filters.Filter;
import org.esupportail.portal.channels.CIntranet.security.Security;
import org.esupportail.portal.utils.Users;
import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.channels.MainChannel;
import org.esupportail.portal.utils.channels.plugins.Message;
import org.esupportail.portal.utils.channels.plugins.MessageBean;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.PortalException;

/**
 * ViewFolder<br>
 * <br>
 * Cette classe affiche le contenu d'un dossier<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version $Revision: 1.1.2.5 $
 * 
 */
public class ViewFolder extends AbstractAction {

    protected static Log log = LogFactory.getLog(ViewFolder.class);
    
    private static final int USER_VIEW = 1;
    
    private Folder folder = null;
    private List folders = null;
    private List path = null;
    private List documents = null;
    private String order = "order";
    private int mode = USER_VIEW;
    private boolean reverse = false;
    
    /**
     * Constructeur
     * @param mainChannel La channel principale
     */
    public ViewFolder(MainChannel mainChannel) {
        super(mainChannel);
    }

    /**
     * Indique le niveau requis pour raliser cette action
     * Implements AbstractAction.getLevel() method
     * @return level Le niveau requis pour accder  cette action
     */
    public int getLevel() {
        return Security.NONE;
    }
    
    /**
     * Etape 2/4 du cycle de vie de la SubChannel
     * Affiche le contenu d'un rpertoire
     * Override SubChannel.init() method
     * @param rd Les runtimeData
     * @return Boolean TRUE si tout se passe bien, FALSE sinon
     * @throws PortalException
     * @throws FrameWorkException
     */
    public Boolean init(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
        super.init(rd);
        if(super.initialize(rd).equals(Boolean.FALSE)) {
            return Boolean.FALSE;
        }
        if(log.isDebugEnabled()) {
            log.debug("ViewFolder::init()");
        }
        if(getRuntimeData().getParameter("mode") != null) {
            mode = USER_VIEW - mode;
        }
        DataControler data = new DataControler();
        try {
            folder = data.getFolder(folderid);
            path = data.getFolderPath(folderid);
            folders = data.getFolders(folderid);
            documents = data.getDocuments(intranet.getId(), folderid);
        }
        catch(DataException e) {
            log.error("ViewFolder::init() : DataException :\n" + e);
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean(e.getMessage()), "intranet");
            return Boolean.FALSE;
        }
        if(mode == USER_VIEW) {
            Filter.documentFilter(documents, userid, Security.NONE);
        }
        else {
            Filter.documentFilter(documents, userid, level);
        }
        for(Iterator i = documents.iterator();i.hasNext();) {
            Document tmp = (Document)i.next();
            tmp.setAuthor(Users.getUserDisplayName(tmp.getAuthor()));
        }
        Collections.sort(folders);
        orderinit(getRuntimeData());
        return Boolean.TRUE;
    }
    
    /**
     * Etape 3/4 du cycle de vie de la SubChannel
     * Affiche la liste des intranets accessibles
     * Override SubChannel.setXML() method
     * @return Boolean TRUE si tout se passe bien, FALSE sinon
     * @throws FrameWorkException
     */
    public Boolean setXML() throws FrameWorkException {
        if(log.isDebugEnabled()) {
            log.debug("ViewFolder::setXML()");
        }
        StringBuffer xml = new StringBuffer();
        xml.append(folder.toXMLString());
        xml.append("<path>\n");
        for(Iterator i = path.iterator();i.hasNext();) {
            XMLSerializable tmp = (XMLSerializable)i.next();
            xml.append(tmp.toXMLString());
        }
        xml.append("</path>\n");
        xml.append("<folders>\n");
        for(Iterator i = folders.iterator();i.hasNext();) {
            XMLSerializable tmp = (XMLSerializable)i.next();
            xml.append(tmp.toXMLString());
        }
        xml.append("</folders>\n");
        xml.append("<documents>\n");
        for(Iterator i = documents.iterator();i.hasNext();) {
           	XMLSerializable tmp = (XMLSerializable)i.next();
           	xml.append(tmp.toXMLString());
        }
        xml.append("</documents>\n");
        if(log.isDebugEnabled()) {
            log.debug("ViewFolder::setXML()\n" + xml.toString());
        }
        setXML(xml.toString());
        return Boolean.TRUE;
    }
    
    /**
     * Etape 4/4 du cyle de vie de la SubChannel
     * Positionne le titre SSL  utiliser
     * Override SubChannel.setOutput() method
     */
    public void setOutput() throws FrameWorkException {
        super.setOutput();
        if(mode == USER_VIEW) {
        	setXSL("none");
        }
        else {
        	switch(level) {
        		case Security.ED_FULL:
        		case Security.ED_VAL: {
        			if(order.equals("order")) {
        				setXSL("ed_val_order");
        			}
        			else {
        				setXSL("ed_val_normal");
        			}
        			break;
        		}
        		
        		case Security.AUT_FULL:
        		case Security.AUT_MOD: {
        			setXSL("aut_mod");
        			break;
        		}
        		
        		case Security.AUT_NEW: {
        			setXSL("aut_new");
        			break;
        		}
        		
        		case Security.NONE:
        		default: {
        			setXSL("none");
        		}
        	}
        }
        getXSLParameter().put("level", new Integer(level).toString());
        getXSLParameter().put("mode", new Integer(mode));
        addDownloadXslParameter();
    }
    
    /**
     * Etape 2/4 du cycle de vie de la SubChannel
     * Change de mthode de tri pour le documents
     * Override SubChannel.init() method
     * @param rd Les runtimeData
     * @return Boolean TRUE si tout se passe bien, FALSE sinon
     * @throws PortalException
     * @throws FrameWorkException
     */
    public Boolean orderinit(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
        super.init(rd);
        if(log.isDebugEnabled()) {
            log.debug("ViewFolder::orderinit()");
        }
        String order = getRuntimeData().getParameter("order");
        if(order != null) {
            if(order.equals(this.order) && !order.equals("order")) {
                reverse = !reverse;
            }
            else {
                reverse = false;
            }
        }
        else {
            order = this.order;
        }
        this.order = order;
        if(order.equals("order")) {
            Collections.sort(documents, new DocumentOrderComparator());
        }
        if(order.equals("author")) {
            Collections.sort(documents, new DocumentAuthorComparator());
        }
        if(order.equals("description")) {
            Collections.sort(documents);
        }
        if(order.equals("date")) {
            Collections.sort(documents, new DocumentDateComparator());
        }
        if(reverse) {
            Collections.reverse(documents);
        }
        return Boolean.TRUE;
    }
}