package org.esupportail.portal.channels.CIntranet.data;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CIntranet.beans.User;
import org.esupportail.portal.utils.database.Query;

/**
 * AdminAccess<br>
 * <br>
 * Ralise les oprations relatives aux administrateurs dans la base de donnes<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version $Revision: 1.1.2.1 $
 * 
 */
public class AdminAccess {
    
    protected static Log log = LogFactory.getLog(AdminAccess.class);
    
    /**
     * Retourne la liste des administrateurs
     * @param query La connexion  utiliser
     * @return admins La liste
     * @throws DataException
     */
    public static List getAdmins(Query query) throws DataException {
        if(log.isDebugEnabled()) {
            log.debug("AdminAccess::getAdmins()");
        }
        List admins = new ArrayList();
        String sql = "SELECT * FROM INT_ADMIN";
        try {
            query.setSql(sql);
            query.select();
            ResultSet rs = query.getRs();
            while(rs.next()) {
                User tmp = new User();
                tmp.setId(rs.getString("ID_ENT"));
                admins.add(tmp);
            }
        }
        catch(SQLException e) {
            log.error("AdminAccess::getAdmins() : " + e);
			log.error("AdminAccess::getAdmins() : SQL : " + sql);
			throw new DataException("Erreur lors de la lecture des administrateurs");
        }
        return admins;
    }
    
    /**
     * Ajoute un administrateur
     * @param query La connexion  utiliser
     * @param id L'identifiant de l'utilisateur
     * @throws DataException
     */
    public static void addAdmin(Query query, String id) throws DataException {
        if(log.isDebugEnabled()) {
            log.debug("AdminAccess::addAdmin()");
        }
        String sql = "INSERT INTO INT_ADMIN(ID_ENT) VALUES('" + id + "')";
        try {
            query.setSql(sql);
            query.insert();
        }
        catch(SQLException e) {
            log.error("AdminAccess::addAdmin() : " + e);
			log.error("AdminAccess::addAdmin() : SQL : " + sql);
			throw new DataException("Erreur lors de l'ajout de l'administrateur");
        }
    }
    
    /**
     * Supprime un administrateur
     * @param query La connexion  utiliser
     * @param id L'identifiant de l'utilisateur
     * @throws DataException
     */
    public static void removeAdmin(Query query, String id) throws DataException {
        if(log.isDebugEnabled()) {
            log.debug("AdminAccess::removeAdmin()");
        }
        String sql = "DELETE FROM INT_ADMIN WHERE ID_ENT = '" + id + "'";
        try {
            query.setSql(sql);
            query.delete();
        }
        catch(SQLException e) {
            log.error("AdminAccess::removeAdmin() : " + e);
			log.error("AdminAccess::removeAdmin() : SQL : " + sql);
			throw new DataException("Erreur lors de la suppression de l'administrateur");
        }
    }
}
