package org.esupportail.portal.channels.CIntranet.data;

import java.util.LinkedList;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CIntranet.beans.Folder;
import org.esupportail.portal.channels.CIntranet.config.Config;
import org.esupportail.portal.utils.database.Query;

/**
 * NotificationControler<br>
 * <br>
 * Classe permettant d'accder  la base de donnes via un CRON pour les notifications<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version $Revision: 1.1.2.2 $
 * 
 */
public class NotificationControler {
    
    protected static Log log = LogFactory.getLog(NotificationControler.class);
    private Query query = null;
    
    /**
     * Ouvre une connexion
     */
    private void open() {
        if(log.isDebugEnabled()) {
            log.debug("NotificationControler::start()");
        }
        query = Config.getInstance().getConnexion("cron");
    }
    
    /**
     * Ferme la connexion courante
     */
    public void close() {
        if(log.isDebugEnabled()) {
            log.debug("NotificationControler::stop()");
        }
        query.close();
        query = null;
    }
    
    /**
     * Vrifie que toutes les connexions ont t fermes
     * Override Object.finalize() method
     */
    protected void finalize() throws Throwable {
        super.finalize();
        if(query != null) {
            log.error("NotificationControler::finalize() : Des connexions n'ont pas \u00E9t\u00E9 ferm\u00E9es");
        }
        query.close();
    }
    
    /**
     * Rcupre tous les intranets
     * @return intranets La liste des intranets
     * @throws DataException
     */
    public List getIntranets() throws DataException {
        if(log.isDebugEnabled()) {
            log.debug("NotificationControler::getIntranets()");
        }
        
        List intranets = null;
        open();
        try {
            intranets = IntranetAccess.getIntranets(query);
        }
        finally {
            close();
        }
        return intranets;
    }
    
    /**
     * Retourne la liste des documents en attente de validation
     * @param intranet L'identifiant de l'intranet
     * @return docs La liste des documents
     * @throws DataException
     */
    public List getInvalidDocuments(String intranet) throws DataException {
        if(log.isDebugEnabled()) {
            log.debug("SearchControler::getInvalidDocuments()");
        }
        List docs = null;
        open();
        try {
            docs = SearchAccess.getInvalidDocuments(query, intranet); 
        }
        finally {
            close();
        }
        return docs;
    }
    
    /**
     * Retourne la liste des droits d'un dossier
     * @param id L'identifiant du dossier
     * @return grants La liste des droits
     * @throws DataException
     */
    public List getGrants(String id) throws DataException {
        if(log.isDebugEnabled()) {
            log.debug("SearchControler::getGrants()");
        }
        List grants = null;
        open();
        try {
            grants = GrantAccess.getGrants(query, id);
        }
        finally {
            close();
        }
        return grants;
    }
    
    /**
     * Retourne la liste des dossiers jusqu' la racine (chemin)
     * @param id L'identifiant du dossier  partir duquel on construit le chemin
     * @return path La liste chane indiquant le chemin jusqu' la racine
     * @throws DataException
     */
    public List getFolderPath(String id) throws DataException {
        if(log.isDebugEnabled()) {
            log.debug("SearchControler::getFolders()");
        }
        LinkedList path = new LinkedList();
        open();
        try {
            do {
                Folder tmp = FolderAccess.getFolder(query, id);
                path.addFirst(tmp);
                id = tmp.getParentid();
            }
            while(!id.equals("0"));
        }
        finally {
            close();
        }
        return path;
    }

}