package org.esupportail.portal.channels.CIntranet.data;

import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CIntranet.config.Config;
import org.esupportail.portal.utils.database.Query;

/**
 * SearchControler<br>
 * <br>
 * Classe permettant d'encapsulers les accs  la base de donnes dans des transactions<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version $Revision: 1.1.2.5 $
 * 
 */
public class SearchControler {
    
    protected static Log log = LogFactory.getLog(SearchControler.class);
    private Query query = null;
    
    /**
     * Ouvre une connexion
     */
    private void open() {
        if(log.isDebugEnabled()) {
            log.debug("DataControler::start()");
        }
        query = Config.getInstance().getConnexionDefault();
    }
    
    /**
     * Ferme la connexion courante
     */
    public void close() {
        if(log.isDebugEnabled()) {
            log.debug("DataControler::stop()");
        }
        query.close();
        query = null;
    }
    
    /**
     * Commit la transaction
     */
    public void commit() {
        if(log.isDebugEnabled()) {
            log.debug("DataControler::commit()");
        }
        query.commit();
    }
    
    /**
     * Rollback la transaction
     */
    public void rollback() {
        if(log.isDebugEnabled()) {
            log.debug("DataControler::rollback()");
        }
        query.rollback();
    }
    
    /**
     * Vrifie que toutes les connexions ont t fermes
     * Override Object.finalize() method
     */
    protected void finalize() throws Throwable {
        super.finalize();
        if(query != null) {
            log.error("DataControler::finalize() : Des connexions n'ont pas \u00E9t\u00E9 ferm\u00E9es");
        }
        query.close();
    }
    
    /**
     * Retourne la liste des documents en attente de validation
     * @param intranet L'identifiant de l'intranet
     * @return docs La liste des documents
     * @throws DataException
     */
    public List getInvalidDocuments(String intranet) throws DataException {
        if(log.isDebugEnabled()) {
            log.debug("SearchControler::getInvalidDocuments()");
        }
        List docs = null;
        open();
        try {
            docs = SearchAccess.getInvalidDocuments(query, intranet); 
        }
        finally {
            close();
        }
        return docs;
    }
    
    /**
     * Retourne la liste des documents en attente de validation
     * @param intranet L'identifiant de l'intranet
     * @return docs La liste des documents
     * @throws DataException
     */
    public List getPerimedDocuments(String intranet) throws DataException {
        if(log.isDebugEnabled()) {
            log.debug("SearchControler::getPerimedDocuments()");
        }
        List docs = null;
        open();
        try {
            docs = SearchAccess.getPerimedDocuments(query, intranet); 
        }
        finally {
            close();
        }
        return docs;
    }
    
    /**
     * Retourne les n derniers documents d'un intranet
     * @param intranet L'identifiant de l'intranet
     * @param count Le nombre de documents  retourner
     * @return docs La liste des documents
     * @throws DataException
     */
    public List getLastDocuments(String intranet, int count) throws DataException {
        if(log.isDebugEnabled()) {
            log.debug("SearchControler::getLastDocuments()");
        }
        List docs = null;
        open();
        try {
            docs = SearchAccess.getLastDocuments(query, intranet, count); 
        }
        finally {
            close();
        }
        return docs;
    }

    /**
     * Retourne les documents correspondants aux critres de recherche
     * @param intranet L'identifiant de l'intranet
     * @param type Le type de document (F, L ou %)
     * @param description Le template de description (%template% ou %)
     * @return docs La liste des documents
     * @throws DataException
     */
    public List getCustomDocuments(String intranet, String type, String description) throws DataException {
        if(log.isDebugEnabled()) {
            log.debug("SearchControler::getCustomDocuments()");
        }
        List docs = null;
        open();
        try {
            docs = SearchAccess.getCustomDocuments(query, intranet, type, description); 
        }
        finally {
            close();
        }
        return docs;
    }
}