package org.esupportail.portal.channels.CIntranet.data;

import java.util.Iterator;
import java.util.List;

import org.esupportail.portal.channels.CIntranet.beans.Folder;
import org.esupportail.portal.channels.CIntranet.beans.Intranet;


/**
 * Update<br>
 * <br>
 * Cette classe prend en charge la mise  jour de la base de donnes<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version $Revision: 1.1.2.1 $
 * 
 */
public class Update {
    
    /**
     * Constructeur
     */
    public Update() {
    }
    
    /**
     * Dmarre l'opration de mise  jour
     */
    private void start() {
        UpdateControler update = new UpdateControler();
        List intranets = null;
        System.out.println("Updating INT_INTRANET table :");
        try {
            intranets = update.getIntranets();
        }
        catch(DataException e) {
            System.out.println("*** ERROR : aucune mise \u00E0 jour effectu\u00E9 ***");
            System.exit(1);
        }
        int count = 0;
        for(Iterator i = intranets.iterator();i.hasNext();) {
            Intranet tmp = (Intranet)i.next();
            tmp.setOrder(count++);
            try {
                update.updateIntranet(tmp);
                System.out.println("*** OK    : \"" + tmp.getName() + "\" ORDRE => " + (count-1) + " ***");
            }
            catch(DataException e) {
                System.out.println("*** ERROR : une erreur a eu lieu, une restauration de la base est n\u00E9cessaire ***");
                System.exit(1);
            }
        }
        
        System.out.println("Updating INT_FOLDER table :");
        
        for(Iterator i = intranets.iterator();i.hasNext();) {
            Intranet tmp = (Intranet)i.next();
            System.out.println("Processing intranet \"" + tmp.getName() + "\" ...\n");
            List folders = null;
            try {
                folders = update.getAllFolders(tmp.getId());
            }
            catch(DataException e) {
                System.out.println("*** ERROR : une erreur a eu lieu, une restauration de la base est n\u00E9cessaire ***");
                System.exit(1);
            }
            for(Iterator j = folders.iterator();j.hasNext();) {
                Folder tmpfol = (Folder)j.next();
                System.out.println("Processing folder \"" + tmpfol.getName() + "\" children ...");
                List children = null;
                try {
                    children = update.getFolders(tmpfol.getId());
                }
                catch(DataException e) {
                    System.out.println("*** ERROR : une erreur a eu lieu, une restauration de la base est n\u00E9cessaire ***");
                    System.exit(1);
                }
                if(children.isEmpty()) {
                    System.out.println("*** OK    : \"" + tmpfol.getName() + "\" AUCUN SOUS-DOSSIER ***");
                }
                else {
                    count = 0;
                    for(Iterator k = children.iterator();k.hasNext();) {
                        Folder tmpchild = (Folder)k.next();
                        tmpchild.setOrder(count++);
                        try {
                            update.updateFolder(tmpchild);
                            System.out.println("*** OK    : \"" + tmpchild.getName() + "\" ORDRE => " + (count-1) + " ***");
                        }
                        catch(DataException e) {
                            System.out.println("*** ERROR : une erreur a eu lieu, une restauration de la base est n\u00E9cessaire ***");
                            System.exit(1);
                        }
                    }
                }                
            }
        }
        System.out.println("Finished updating");
    }

    /**
     * Point d'entre de la mise  jour
     * @param args La liste des arguments
     */
    public static void main(String[] args) {
        new Update().start();
    }
}
