package org.esupportail.portal.channels.CIntranet.data;

import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CIntranet.beans.Folder;
import org.esupportail.portal.channels.CIntranet.beans.Intranet;
import org.esupportail.portal.channels.CIntranet.config.Config;
import org.esupportail.portal.utils.database.Query;

/**
 * UpdateControler<br>
 * <br>
 * Classe permettant d'accder  la base de donnes via un CRON pour les notifications<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version $Revision: 1.1.2.1 $
 * 
 */
public class UpdateControler {
    
    protected static Log log = LogFactory.getLog(UpdateControler.class);
    private Query query = null;
    
    /**
     * Ouvre une connexion
     */
    private void open() {
        if(log.isDebugEnabled()) {
            log.debug("UpdateControler::start()");
        }
        query = Config.getInstance().getConnexionDefault();
    }
    
    /**
     * Ferme la connexion courante
     */
    public void close() {
        if(log.isDebugEnabled()) {
            log.debug("UpdateControler::stop()");
        }
        query.close();
        query = null;
    }
    
    /**
     * Vrifie que toutes les connexions ont t fermes
     * Override Object.finalize() method
     */
    protected void finalize() throws Throwable {
        super.finalize();
        if(query != null) {
            log.error("UpdateControler::finalize() : Des connexions n'ont pas \u00E9t\u00E9 ferm\u00E9es");
        }
        query.close();
    }
    
    /**
     * Rcupre tous les intranets
     * @return intranets La liste des intranets
     * @throws DataException
     */
    public List getIntranets() throws DataException {
        if(log.isDebugEnabled()) {
            log.debug("UpdateControler::getIntranets()");
        }
        
        List intranets = null;
        open();
        try {
            intranets = IntranetAccess.getIntranets(query);
        }
        finally {
            close();
        }
        return intranets;
    }
    
    /**
     * Met  jour un intranet
     * @param intranet L'intranet  mettre  jour
     * @throws DataException
     */
    public void updateIntranet(Intranet intranet) throws DataException {
        if(log.isDebugEnabled()) {
            log.debug("UpdateControler::getIntranets()");
        }
        open();
        try {
            IntranetAccess.updateIntranet(query, intranet);
        }
        finally {
            close();
        }
    }
    
    /**
     * Retourne la liste de tous les dossiers d'un intranet
     * @param id L'identifiant de l'intranet
     * @return folders La liste des dossiers
     * @throws DataException
     */
    public List getAllFolders(String id) throws DataException {
        if(log.isDebugEnabled()) {
            log.debug("UpdateControler::getAllFolders()");
        }
        List res = null;
        open();
        try {
            res = FolderAccess.getAllFolders(query, id);
        }
        finally {
            close();
        }
        return res;
    }
    
    /**
	 * Retourne la liste de tous les sous-dossiers d'un dossier
	 * @param id L'identifiant du dossier
	 * @return folders La liste des sous-dossiers
	 * @throws DataException
	 */
    public List getFolders(String id) throws DataException {
        if(log.isDebugEnabled()) {
            log.debug("UpdateControler::getFolderChildren()");
        }
        List res = null;
        open();
        try {
            res = FolderAccess.getFolders(query, id);
        }
        finally {
            close();
        }
        return res;
    }
    
    /**
     * Modifie un dossier existant
     * @param folder Le dossier  modifier
     * @throws DataException
     */
    public void updateFolder(Folder folder) throws DataException {
        if(log.isDebugEnabled()) {
            log.debug("UpdateControler::getFolderChildren()");
        }
        open();
        try {
            FolderAccess.updateFolder(query, folder);
        }
        finally {
            close();
        }
    }
}