<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<xsl:output method="html" indent="no" />

<xsl:param name="baseActionURL" />
<xsl:param name="prefForm" />
<xsl:param name="mediaPath" />

<xsl:template match="xml">

<script language="javascript" src="{$mediaPath}functions.js" >
</script>

<table border="0" width="100%" cellspacing="0" cellpadding="5">
	<tr>
		<td class="uportal-channel-table-header" nowrap="true">Gestion des administrateurs</td>
		<td>
			<a href="{$baseActionURL}?action=admin">
				<img  src="{$mediaPath}26x26ab/back.gif" alt="Retour" title="Retour" border="0" />
			</a>
		</td>
		<td width="100%">&#160;</td>
	</tr>
</table>
<hr/>
<br/>

<xsl:apply-templates select="admins" />

</xsl:template>

<xsl:template match="admins">

<form method="post" action="{$baseActionURL}">
<input type="hidden" name="action" value="addadmin" />
<table border="0" width="100%" cellpadding="1" cellspacing="0">
	<tr>
		<td class="uportal-label" nowrap="true">Login : </td>
		<td><input class="uportal-input-text" type="text" name="id" /></td>
		<td><input class="uportal-button" type="submit" value="Ajouter" name="butadd" /></td>
		<td width="100%">&#160;</td>
	</tr>
</table>
</form>
<br/>
<table border="0" width="100%" cellpadding="1" cellspacing="0">
	<tr class="uportal-background-med">
		<td class="uportal-channel-table-header" nowrap="true">Login</td>
		<td width="5%">&#160;</td>
		<td class="uportal-channel-table-header" nowrap="true">Nom</td>
		<td width="5%">&#160;</td>
		<td class="uportal-channel-table-header" nowrap="true">Supprimer</td>
		<td width="100%">&#160;</td>
	</tr>
	<xsl:apply-templates select="user" />
</table>

</xsl:template>

<xsl:template match="user">
	<tr onmouseover="setPointer(this, 'over', 'uportal-background-med', 'BODY');" onmouseout="setPointer(this, 'out', 'uportal-background-med', 'BODY');">
		<td class="uportal-label" nowrap="true"><xsl:value-of select="./@id" /></td>
		<td width="5%">&#160;</td>
		<td class="uportal-text-small" nowrap="true"><xsl:value-of select="./@name" /></td>
		<td width="5%">&#160;</td>
		<td align="center" valign="absmiddle">
			<a href="{$baseActionURL}?action=deladmin&amp;id={./@id}">
				<img  src="{$mediaPath}20x20sb/del.gif" alt="Supprimer" title="Supprimer" border="0" />
			</a>
		</td>
		<td width="100%">&#160;</td>
	</tr>
</xsl:template>

</xsl:stylesheet>