<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<xsl:output method="html" indent="no" />

<!-- Affichage chemin -->
<xsl:template match="path">
	
	<td class="uportal-text" nowrap="true">
		<xsl:apply-templates select="folder" />
	</td>
	
</xsl:template>

<xsl:template match="folder">
	<a href="{$baseActionURL}?action=viewfolder&amp;folder={./@id}"><xsl:value-of select="./@name" /></a>&#160;&#62;&#160;
</xsl:template>

<!-- Affichage documents -->
<xsl:template name="document.state">
	<td class="uportal-text">
		<xsl:choose>
			<xsl:when test="./@modified='true'">Modifi</xsl:when>
			<xsl:when test="./@deleted='true'">Supprim</xsl:when>
			<xsl:when test="./@valid='false'">Nouveau</xsl:when>
			<xsl:otherwise>Valide</xsl:otherwise>
		</xsl:choose>
	</td>
</xsl:template>

<xsl:template name="document.icon">
	<xsl:choose>
		<xsl:when test="./@type='file'">
			<xsl:call-template name="document.icon.file" />
		</xsl:when>
		<xsl:otherwise>
			<td valign="absmiddle">
				<a href="{./@url}" target="_blank">
					<img src="{$mediaPath}dochtm.gif" border="0" alt="Ouvrir" title="Ouvrir" />
				</a>
			</td>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template name="document.icon.file">
	<td align="absmiddle">
		<a href="{$baseDownloadURL}?action=download&amp;folder={./@folder}&amp;id={./@id}">
			<xsl:choose>
				<xsl:when test="./@extension='.doc'">
					<img src="{$mediaPath}docdoc.gif" border="0" alt="Tlcharger" title="Tlcharger" />		
				</xsl:when>
				<xsl:when test="./@extension='.gz'">
					<img src="{$mediaPath}doczip.gif" border="0" alt="Tlcharger" title="Tlcharger" />		
				</xsl:when>
				<xsl:when test="./@extension='.htm'">
					<img src="{$mediaPath}dochtm.gif" border="0" alt="Tlcharger" title="Tlcharger" />		
				</xsl:when>
				<xsl:when test="./@extension='.html'">
					<img src="{$mediaPath}dochtm.gif" border="0" alt="Tlcharger" title="Tlcharger" />		
				</xsl:when>
				<xsl:when test="./@extension='.pdf'">
					<img src="{$mediaPath}docpdf.gif" border="0" alt="Tlcharger" title="Tlcharger" />		
				</xsl:when>
				<xsl:when test="./@extension='.ppt'">
					<img src="{$mediaPath}docppt.gif" border="0" alt="Tlcharger" title="Tlcharger" />		
				</xsl:when>
				<xsl:when test="./@extension='.rar'">
					<img src="{$mediaPath}doczip.gif" border="0" alt="Tlcharger" title="Tlcharger" />		
				</xsl:when>
				<xsl:when test="./@extension='.tar'">
					<img src="{$mediaPath}doczip.gif" border="0" alt="Tlcharger" title="Tlcharger" />		
				</xsl:when>
				<xsl:when test="./@extension='.xls'">
					<img src="{$mediaPath}docxls.gif" border="0" alt="Tlcharger" title="Tlcharger" />		
				</xsl:when>
				<xsl:when test="./@extension='.zip'">
					<img src="{$mediaPath}doczip.gif" border="0" alt="Tlcharger" title="Tlcharger" />		
				</xsl:when>
				<xsl:otherwise>
					<img src="{$mediaPath}docstd.gif" border="0" alt="Tlcharger" title="Tlcharger" />		
				</xsl:otherwise>
			</xsl:choose>
		</a>
	</td>
</xsl:template>

<xsl:template name="document.name">
	<td class="uportal-text" nowrap="true">
		<xsl:choose>
			<xsl:when test="./@type='file'">
				<a href="{$baseDownloadURL}?action=download&amp;folder={./@folder}&amp;id={./@id}">
					<xsl:value-of select="./@description" />
				</a> 
			</xsl:when>
			<xsl:otherwise>
				<a href="{./@url}" target="_blank">
					<xsl:value-of select="./@description" />
				</a> 
			</xsl:otherwise>
		</xsl:choose>
	</td>
</xsl:template>

</xsl:stylesheet>