package org.esupportail.portal.channels.CIntranet.actions.admin;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CIntranet.beans.Intranet;
import org.esupportail.portal.channels.CIntranet.data.DataControler;
import org.esupportail.portal.channels.CIntranet.data.DataException;
import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.channels.MainChannel;
import org.esupportail.portal.utils.channels.plugins.Message;
import org.esupportail.portal.utils.channels.plugins.MessageBean;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.PortalException;

/**
 * ModifyIntranet<br>
 * <br>
 * Cette classe gre la modification d'un intranet<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version $Revision: 1.1.2.1 $
 * 
 */

public class ModifyIntranet extends AbstractAction {

	protected static Log log = LogFactory.getLog(ModifyIntranet.class);
	
	private Intranet intranet = null;
	
	/**
     * Constructeur
     * @param mainChannel La channel principale
     */
	public ModifyIntranet(MainChannel mainChannel) {
		super(mainChannel);
	}

	/**
     * Etape 2/4 du cycle de vie de la SubChannel
     * Affiche le formulaire de modification d'intranet
     * Override SubChannel.init() method
     * @param rd Les runtimeData
     * @return Boolean TRUE si tout se passe bien, FALSE sinon
     * @throws PortalException
     * @throws FrameWorkException
     */
    public Boolean init(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
        super.init(rd);
        if(super.initialize(rd).equals(Boolean.FALSE)) {
            return Boolean.FALSE;
        }
        if(log.isDebugEnabled()) {
            log.debug("ModifyIntranet::init()");
        }
        
        String id = getRuntimeData().getParameter("id");
        if(id == null || id.equals("")) {
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean("Erreur d'acc\u00E8s \u00E0 la page"), "admin");
            return Boolean.FALSE;
        }
        DataControler data = new DataControler();
        try {
            intranet = data.getIntranet(id);
        }
        catch(DataException e) {
            log.error("ModifyIntranet::init() : DataException :\n" + e);
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean(e.getMessage()), "admin");
            return Boolean.FALSE;
        }
        
        return Boolean.TRUE;
    }
    
    /**
     * Etape 3/4 du cycle de vie de la SubChannel
     * Affiche le formulaire de modification d'intranet
     * Override SubChannel.setXML() method
     * @return Boolean TRUE si tout se passe bien, FALSE sinon
     * @throws FrameWorkException
     */
    public Boolean setXML() throws FrameWorkException {
        if(log.isDebugEnabled()) {
            log.debug("ModifyIntranet::setXML()");
        }
        StringBuffer xml = new StringBuffer();
        xml.append(intranet.toXMLString());
        if(log.isDebugEnabled()) {
            log.debug("ModifyIntranet::setXML()\n" + xml.toString());
        }
        setXML(xml.toString());
        return Boolean.TRUE;
    }
    
    /**
     * Etape 2/4 du cycle de vie de la SubChannel
     * Traite la modification d'intranet
     * Override SubChannel.init() method
     * @param rd Les runtimeData
     * @return Boolean TRUE si tout se passe bien, FALSE sinon
     * @throws PortalException
     * @throws FrameWorkException
     */
    public Boolean modinit(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
        super.init(rd);
        if(super.initialize(rd).equals(Boolean.FALSE)) {
            return Boolean.FALSE;
        }
        if(log.isDebugEnabled()) {
            log.debug("ModifyIntranet::modinit()");
        }
        
        String name = getRuntimeData().getParameter("nom");
        String comment = getRuntimeData().getParameter("comment");
        
        if(name == null || comment == null) {
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean("Erreur d'acc\u00E8s \u00E0 la page"), "admin");
            return Boolean.FALSE;
        }
        
        if(name.equals("")) {
        	Message.message(getMainChannel(), getRuntimeData(), new MessageBean("Le champs 'nom' est obligatoire"), "modintranet");
            return Boolean.FALSE;
        }
                
        if(name.equals(intranet.getName()) && comment.equals(intranet.getComment())) {
        	getMainChannel().redirect(runtimeData, "admin");
        	return Boolean.FALSE;
        }
        
        intranet.setName(name);
        intranet.setComment(comment);
        
        DataControler data = new DataControler();
        try {
            data.updateIntranet(intranet);
        }
        catch(DataException e) {
            log.error("ModifyIntranet::modinit() : DataException :\n" + e);
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean(e.getMessage()), "admin");
            return Boolean.FALSE;
        }
        
        getMainChannel().redirect(runtimeData, "admin");
        return Boolean.FALSE;
    }
}
