package org.esupportail.portal.channels.CIntranet.actions.intranet;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CIntranet.beans.DocumentFile;
import org.esupportail.portal.channels.CIntranet.beans.DocumentLink;
import org.esupportail.portal.channels.CIntranet.data.DataControler;
import org.esupportail.portal.channels.CIntranet.data.DataException;
import org.esupportail.portal.channels.CIntranet.security.Security;
import org.esupportail.portal.channels.CIntranet.storage.IStorageControler;
import org.esupportail.portal.channels.CIntranet.storage.StorageException;
import org.esupportail.portal.channels.CIntranet.storage.StorageFactory;
import org.esupportail.portal.channels.CIntranet.utils.Date;
import org.esupportail.portal.channels.CIntranet.utils.Notifier;
import org.esupportail.portal.channels.CIntranet.utils.SizeLimitException;
import org.esupportail.portal.channels.CIntranet.utils.UploadWorker;
import org.esupportail.portal.utils.channels.Action;
import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.channels.MainChannel;
import org.esupportail.portal.utils.channels.plugins.Message;
import org.esupportail.portal.utils.channels.plugins.MessageBean;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.PortalException;

/**
 * NewDocument<br>
 * <br>
 * Cette classe prend en charge la cration d'un nouveau document<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version $Revision: 1.1.2.6 $
 * 
 */
public class NewDocument extends AbstractAction {

    protected static Log log = LogFactory.getLog(NewDocument.class);
    
    /**
     * Constructeur
     * @param mainChannel La channel principale
     */
    public NewDocument(MainChannel mainChannel) {
        super(mainChannel);
    }

    /**
     * Indique le niveau requis pour raliser cette action
     * Implements AbstractAction.getLevel() method
     * @return level Le niveau requis pour accder  cette action
     */
    public int getLevel() {
        return Security.AUT_NEW;
    }
    
    /**
     * Etape 2/4 du cycle de vie de la SubChannel
     * Affiche le formulaire de choix du type de document
     * Override SubChannel.init() method
     * @param rd Les runtimeData
     * @return Boolean TRUE si tout se passe bien, FALSE sinon
     * @throws PortalException
     * @throws FrameWorkException
     */
    public Boolean init(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
        super.init(rd);
        if(super.initialize(rd).equals(Boolean.FALSE)) {
            return Boolean.FALSE;
        }
        if(log.isDebugEnabled()) {
            log.debug("NewDocument::init()");
        }
        return Boolean.TRUE;
    }
    
    /**
     * Etape 3/4 du cycle de vie de la SubChannel
     * Affiche le formulaire de choix du type de document
     * Override SubChannel.setXML() method
     * @return Boolean TRUE si tout se passe bien, FALSE sinon
     * @throws FrameWorkException
     */
    public Boolean setXML() throws FrameWorkException {
        if(log.isDebugEnabled()) {
            log.debug("NewDocument::setXML()");
        }
        setXML("");
        getXSLParameter().put("folder", folderid);
        return Boolean.TRUE;
    }
    
    /**
     * Etape 2/4 du cycle de vie de la SubChannel
     * Affiche le formulaire de cration de fichier/lien
     * Override SubChannel.init() method
     * @param rd Les runtimeData
     * @return Boolean TRUE si tout se passe bien, FALSE sinon
     * @throws PortalException
     * @throws FrameWorkException
     */
    public Boolean newinit(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
        super.init(rd);
        if(super.initialize(rd).equals(Boolean.FALSE)) {
            return Boolean.FALSE;
        }
        if(log.isDebugEnabled()) {
            log.debug("NewDocument::newinit()");
        }
        return Boolean.TRUE;
    }
    
    /**
     * Etape 3/4 du cycle de vie de la SubChannel
     * Affiche le formulaire de cration de fichier/lien
     * Override SubChannel.setXML() method
     * @return Boolean TRUE si tout se passe bien, FALSE sinon
     * @throws FrameWorkException
     */
    public Boolean newxml() throws FrameWorkException {
        if(log.isDebugEnabled()) {
            log.debug("NewDocument::newxml()");
        }
        setXML("");
        getXSLParameter().put("folder", folderid);
        return Boolean.TRUE;
    }
    
    /**
     * Etape 4/4 du cycle de vie de la SubChannel
     * Choix de la feuille de style fichier/lien
     * Override SubChannel.setOutput() method
     * @throws FrameWorkException
     */
    public void newoutput() throws FrameWorkException {
        if(log.isDebugEnabled()) {
            log.debug("NewDocument::newoutput()");
        }
        Action current = mainChannel.getCurrentAction();
		setSSL(current.getSslFile());
		if(getMainChannel().getCurrentAction().getName().equals("newfile")) {
		    setXSL("file");
		}
		else {
		    setXSL("link");
		}
    }
    
    /**
     * Etape 2/4 du cycle de vie de la SubChannel
     * Traite la cration d'un fichier
     * Override SubChannel.init() method
     * @param rd Les runtimeData
     * @return Boolean TRUE si tout se passe bien, FALSE sinon
     * @throws PortalException
     * @throws FrameWorkException
     */
    public Boolean fileinit(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
        super.init(rd);
        if(super.initialize(rd).equals(Boolean.FALSE)) {
            return Boolean.FALSE;
        }
        if(log.isDebugEnabled()) {
            log.debug("NewDocument::fileinit()");
        }
        String description = getRuntimeData().getParameter("description");
        String date = getRuntimeData().getParameter("date");
        if(description == null || date == null) {
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean("Erreur d'acc\u00E8s \u00E0 la page"), "intranet");
            return Boolean.FALSE;
        }
        if(description.equals("")) {
            Hashtable parameters = new Hashtable();
            parameters.put("folder", folderid);
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean("Le libell\u00E9 est obligatoire"), "newfile", parameters);
            return Boolean.FALSE;
        }
        if(date.equals("")) {
            date = "99999999";
        }
        else {
            if(!date.matches("[0-9]{2}/[0-9]{2}/[0-9]{4}")) {
                Hashtable parameters = new Hashtable();
                parameters.put("folder", folderid);
                Message.message(getMainChannel(), getRuntimeData(), new MessageBean("Mauvais format de date"), "newfile", parameters);
                return Boolean.FALSE;
            }
            date = date.substring(6) + date.substring(3, 5) + date.substring(0, 2);
            if(date.compareTo(Date.getCurrentDate()) < 0) {
                Hashtable parameters = new Hashtable();
                parameters.put("folder", folderid);
                Message.message(getMainChannel(), getRuntimeData(), new MessageBean("La date est d\u00E9j\u00E0 d\u00E9pass\u00E9e"), "newfile", parameters);
                return Boolean.FALSE;
            }
        }
        UploadWorker worker = new UploadWorker(runtimeData);
		try {
			worker.parseFile("file");
		}
		catch(SizeLimitException e) {
			Hashtable parameters = new Hashtable();
			parameters.put("folder", folderid);
            Message.message(mainChannel, runtimeData, new MessageBean("Le fichier joint est trop gros"), "newfile", parameters);
			return Boolean.FALSE;
		}
		catch(FileNotFoundException e) {
			Hashtable parameters = new Hashtable();
			parameters.put("folder", folderid);
            Message.message(mainChannel, runtimeData, new MessageBean("Aucun fichier attach\u00E9"), "newfile", parameters);
			return Boolean.FALSE;
		}
		DocumentFile doc = new DocumentFile();
		doc.setIntranet(intranet.getId());
		doc.setAuthor(userid);
		doc.setDate(Date.getCurrentDate());
		doc.setDescription(description);
		doc.setFile(worker.getName());
		doc.setExtension(doc.getFile().substring(doc.getFile().lastIndexOf(".")));
		doc.setName(doc.getFile().substring(0, doc.getFile().lastIndexOf(".")));
		doc.setFolderid(folderid);
		doc.setPendingDeletion(false);
		doc.setPendingModification(false);
		doc.setValidityDate(date);
		doc.setOrder(0);
		doc.setVisible(true);
		if(level < Security.AUT_FULL) {
		    doc.setValid(false);
		}
		else {
		    doc.setValid(true);
		}
		if(doc.getExtension() == null || doc.getExtension().equals(".")) {
			log.error("NewDocument::fileinit() : Type de fichier non valide");
			Hashtable parameters = new Hashtable();
			parameters.put("folder", folderid);
			Message.message(mainChannel, runtimeData, new MessageBean("Type de fichier non valide"), "newfile", parameters);		
			return Boolean.FALSE;
		}
		InputStream filestream = null;
		try {
			filestream = worker.getInputStream();
		}
		catch(IOException e) {
			log.error("NewDocument::fileinit() : IOException :\n" + e);
			Hashtable parameters = new Hashtable();
			parameters.put("folder", folderid);
			Message.message(mainChannel, runtimeData, new MessageBean("Impossible de r\u00E9cup\u00E9rer le fichier joint"), "viewfolder", parameters);
			return Boolean.FALSE;
		}
		DataControler data = new DataControler();
		try {
		    if(!data.mimeExist(doc.getExtension())) {
		        Hashtable parameters = new Hashtable();
		        parameters.put("folder", folderid);
				Message.message(mainChannel, runtimeData, new MessageBean("Ce type de fichier (" + doc.getExtension() + ") n'est pas valide"), "newfile", parameters);
				return Boolean.FALSE;
		    }
		}
		catch(DataException e) {
		    log.error("NewDocument::fileinit() : DataException :\n" + e);
            Hashtable parameters = new Hashtable();
            parameters.put("folder", folderid);
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean(e.getMessage()), "viewfolder", parameters);
            return Boolean.FALSE;
		}
		IStorageControler store = StorageFactory.make(intranet.getRessource());
		try {
		    data.createDocument(doc);
		    store.saveDocument(intranet.getId(), doc, filestream);
		    data.commit();
		    data.close();
		    
		    if(doc.isValid()) {
		    	Notifier.sendNotification(doc, Notifier.FILE_NEW);
		    }
		}
		catch(DataException e) {
		    log.error("NewDocument::fileinit() : DataException :\n" + e);
            Hashtable parameters = new Hashtable();
            parameters.put("folder", folderid);
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean(e.getMessage()), "viewfolder", parameters);
            return Boolean.FALSE;
		}
		catch(StorageException e) {
		    log.error("NewDocument::fileinit() : StorageException :\n" + e);
			data.rollback();
			data.close();
			Hashtable parameters = new Hashtable();
			parameters.put("folder", folderid);
			Message.message(mainChannel, runtimeData, new MessageBean(e.getMessage()), "viewfolder", parameters);
			return Boolean.FALSE;
		}
		
		runtimeData.setParameter("folder", folderid);
		mainChannel.redirect(runtimeData, "viewfolder");
		return Boolean.FALSE;
    }
    
    /**
     * Etape 2/4 du cycle de vie de la SubChannel
     * Traite la cration d'un lien
     * Override SubChannel.init() method
     * @param rd Les runtimeData
     * @return Boolean TRUE si tout se passe bien, FALSE sinon
     * @throws PortalException
     * @throws FrameWorkException
     */
    public Boolean linkinit(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
        super.init(rd);
        if(super.initialize(rd).equals(Boolean.FALSE)) {
            return Boolean.FALSE;
        }
        if(log.isDebugEnabled()) {
            log.debug("NewDocument::linkinit()");
        }
        String description = getRuntimeData().getParameter("description");
        String link = getRuntimeData().getParameter("link");
        String date = getRuntimeData().getParameter("date");
        if(description == null || link == null || date == null) {
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean("Erreur d'acc\u00E8s \u00E0 la page"), "intranet");
            return Boolean.FALSE;
        }
        if(description.equals("") || link.equals("")) {
            Hashtable parameters = new Hashtable();
            parameters.put("folder", folderid);
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean("Les champs 'description' et 'lien' sont obligatoires"), "newlink", parameters);
            return Boolean.FALSE;
        }
        if(!link.matches("^http[s]{0,1}://.*$")) {
            Hashtable parameters = new Hashtable();
            parameters.put("folder", folderid);
            Message.message(mainChannel, runtimeData, new MessageBean("Mauvaise adresse, une adresse valide est du type http(s)://www.exemple.com"), "newlink", parameters);
			return Boolean.FALSE;
        }
        if(date.equals("")) {
            date = "99999999";
        }
        else {
            if(!date.matches("[0-9]{2}/[0-9]{2}/[0-9]{4}")) {
                Hashtable parameters = new Hashtable();
                parameters.put("folder", folderid);
                Message.message(getMainChannel(), getRuntimeData(), new MessageBean("Mauvais format de date"), "newlink", parameters);
                return Boolean.FALSE;
            }
            date = date.substring(6) + date.substring(3, 5) + date.substring(0, 2);
            if(date.compareTo(Date.getCurrentDate()) < 0) {
                Hashtable parameters = new Hashtable();
                parameters.put("folder", folderid);
                Message.message(getMainChannel(), getRuntimeData(), new MessageBean("La date est d\u00E9j\u00E0 d\u00E9pass\u00E9e"), "newlink", parameters);
                return Boolean.FALSE;
            }
        }
        DocumentLink doc = new DocumentLink();
		doc.setIntranet(intranet.getId());
        doc.setAuthor(userid);
		doc.setDate(Date.getCurrentDate());
		doc.setDescription(description);
		doc.setFolderid(folderid);
		doc.setName("");
		doc.setPendingDeletion(false);
		doc.setPendingModification(false);
		doc.setUrl(link);
		doc.setValidityDate(date);
		doc.setOrder(0);
		doc.setVisible(true);
		if(level < Security.AUT_FULL) {
		    doc.setValid(false);
		}
		else {
		    doc.setValid(true);
		}
		DataControler data = new DataControler();
		try {
		    data.createDocument(doc);
		    data.commit();
		    data.close();
		    
		    if(doc.isValid()) {
		    	Notifier.sendNotification(doc, Notifier.LINK_NEW);
		    }
		}
		catch(DataException e) {
		    log.error("NewDocument::linkinit() : DataException :\n" + e);
            Hashtable parameters = new Hashtable();
            parameters.put("folder", folderid);
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean(e.getMessage()), "viewfolder", parameters);
            return Boolean.FALSE;
		}
		
		runtimeData.setParameter("folder", folderid);
		mainChannel.redirect(runtimeData, "viewfolder");
		return Boolean.FALSE;
    }
}
