package org.esupportail.portal.channels.CIntranet.actions.intranet;

import java.util.Hashtable;
import java.util.Vector;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CIntranet.beans.Document;
import org.esupportail.portal.channels.CIntranet.beans.DocumentFile;
import org.esupportail.portal.channels.CIntranet.beans.Intranet;
import org.esupportail.portal.channels.CIntranet.data.DataControler;
import org.esupportail.portal.channels.CIntranet.data.DataException;
import org.esupportail.portal.channels.CIntranet.security.Security;
import org.esupportail.portal.channels.CIntranet.security.SecurityException;
import org.esupportail.portal.channels.CIntranet.storage.IStorageControler;
import org.esupportail.portal.channels.CIntranet.storage.StorageException;
import org.esupportail.portal.channels.CIntranet.storage.StorageFactory;
import org.esupportail.portal.channels.CIntranet.utils.Notifier;
import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.channels.MainChannel;
import org.esupportail.portal.utils.channels.SubChannel;
import org.esupportail.portal.utils.channels.plugins.Message;
import org.esupportail.portal.utils.channels.plugins.MessageBean;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.PortalException;
import org.jasig.portal.security.IPerson;

/**
 * ValidSearchDocuments<br>
 * <br>
 * Cette classe prend en charge la validation de plusieurs documents  partir d'une recherche<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version $Revision: 1.1.2.2 $
 * 
 */
public class ValidSearchDocuments extends SubChannel {

    protected static Log log = LogFactory.getLog(ValidSearchDocuments.class);
    
    private String userid = null;
    private Intranet intranet = null;
    
    /**
    * Constructeur
    * @param mainChannel La channel principale
    */
    public ValidSearchDocuments(MainChannel mainChannel) {
        super(mainChannel);
    }
    
    /**
     * Implmente un comportement par dfaut pour le moteur de recherche
     * @param rd Les runtimeData
     * @return Boolean TRUE si l'utilisateur peut accder au moteur de recherche, Boolean.FALSE sinon
     * @throws PortalException
     * @throws FrameWorkException
     */
    public Boolean initialize(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
        if(log.isDebugEnabled()) {
            log.debug("ValidSearchDocuments::initialize()");
        }
        userid = getMainChannel().getStaticData().getPerson().getAttribute(IPerson.USERNAME).toString();
        if(getMainChannel().getStaticData().get("intranet") == null) {
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean("Erreur d'acc\u00E8s \u00E0 la page"), "intranet");
            return Boolean.FALSE;
        }
        intranet = (Intranet)getMainChannel().getStaticData().get("intranet");
        try {
            if(!Security.isAdmin(userid)) {
                if(!Security.isIntranetAccessible(userid, intranet.getId())) {
                    Message.message(getMainChannel(), getRuntimeData(), new MessageBean("Vous n'\u00EAtes pas autoris\u00E9 \u00E0 effectuer cette op\u00E9ration"), "intranet");
                    return Boolean.FALSE;
                }
            }
        }
        catch(SecurityException e) {
            log.error("Search::initialize() : SecurityException :\n" + e);
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean(e.getMessage()), "intranet");
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    /**
     * Etape 2/4 du cycle de vie de la SubChannel
     * Valide les changements de plusieurs document
     * Override SubChannel.init() method
     * @param rd Les runtimeData
     * @return Boolean TRUE si tout se passe bien, FALSE sinon
     * @throws PortalException
     * @throws FrameWorkException
     */
    public Boolean init(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
        super.init(rd);
        if(initialize(rd).equals(Boolean.FALSE)) {
            return Boolean.FALSE;
        }
        if(log.isDebugEnabled()) {
            log.debug("ValidSearchDocuments::init()");
        }
        String [] ids = getRuntimeData().getParameterValues("selected");
        if(ids == null) {
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean("Aucun document s\u00E9lectionn\u00E9"), "search");
            return Boolean.FALSE;
        }
        DataControler data = new DataControler();
        IStorageControler store = StorageFactory.make(intranet.getRessource());
        Vector messages = new Vector();
        for(int i=0;i<ids.length;i++) {
            String id = ids[i];
            Document doc = null;
            try {
                doc = data.getDocument(intranet.getId(), id);
                if(!Security.isAdmin(userid) && Security.getLevel(userid, doc.getFolderid()) < Security.ED_VAL) {
                    messages.add(new MessageBean(doc.getName() + " : Vous n'avez pas les droits pour r\u00E9aliser cette op\u00E9ration"));
                }
                else {   
                    data.validDocument(doc, true);
                    if(doc instanceof DocumentFile) {
                        if(doc.isPendingDeletion() || doc.isPendingModification()) {
                            store.destroyDocument(intranet.getId(), doc);
                        }
                    }
                    data.commit();
                    data.close();
                    messages.add(new MessageBean(doc.getDescription() + " : Valid\u00E9", Message.INFO));
                    
                    if(!doc.isPendingDeletion()) {
                    	if(doc.isPendingModification()) {
                    		if(doc instanceof DocumentFile) {
                    			Notifier.sendNotification(doc, Notifier.FILE_MODIFIED);
                    		}
                    		else {
                    			Notifier.sendNotification(doc, Notifier.LINK_MODIFIED);
                    		}
                    	}
                    	else {
                    		if(doc instanceof DocumentFile) {
                    			Notifier.sendNotification(doc, Notifier.FILE_NEW);
                    		}
                    		else {
                    			Notifier.sendNotification(doc, Notifier.LINK_NEW);
                    		}
                    	}
                    }
                }
            }
            catch(SecurityException e) {
                log.error("ValidSearchDocuments::init() : SecurityException :\n" + e);
                messages.add(new MessageBean(doc.getDescription() + " : " + e.getMessage()));
            }
            catch(DataException e) {
                log.error("ValidSearchDocuments::init() : DataException :\n" + e);
                messages.add(new MessageBean(doc.getDescription() + " : " + e.getMessage()));
            }
            catch(StorageException e) {
                log.error("ValidSearchDocuments::init() : StorageException :\n" + e);
                data.rollback();
                data.close();
                messages.add(new MessageBean(doc.getDescription() + " : " + e.getMessage()));
            }
        }
        if(!messages.isEmpty()) {
            Hashtable parameters = new Hashtable();
            parameters.put("new", "1");
            Message.message(getMainChannel(), getRuntimeData(), messages, "search", parameters);
            return Boolean.FALSE;
        }
        getRuntimeData().setParameter("new", "1");
        getMainChannel().redirect(getRuntimeData(), "search");
        return Boolean.FALSE;
    }
}
