package org.esupportail.portal.channels.CIntranet.actions.intranet;

import java.util.Hashtable;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CIntranet.beans.Document;
import org.esupportail.portal.channels.CIntranet.config.Config;
import org.esupportail.portal.channels.CIntranet.data.DataControler;
import org.esupportail.portal.channels.CIntranet.data.DataException;
import org.esupportail.portal.channels.CIntranet.security.Security;
import org.esupportail.portal.utils.Users;
import org.esupportail.portal.utils.channels.FrameWorkException;
import org.esupportail.portal.utils.channels.MainChannel;
import org.esupportail.portal.utils.channels.plugins.Message;
import org.esupportail.portal.utils.channels.plugins.MessageBean;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.PortalException;
import org.jasig.portal.properties.PropertiesManager;

/**
 * ViewDocument<br>
 * <br>
 * Cette classe prend en charge l'affichage d'un document<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version $Revision: 1.1.2.4 $
 * 
 */
public class ViewDocument extends AbstractAction {

    protected static Log log = LogFactory.getLog(ViewDocument.class);
    
    private static String CAS_URL_PROPERTY = "org.jasig.portal.security.provider.YaleCasContext.CasLoginUrl";
    private static String PORTAL_URL_PROPERTY = "org.jasig.portal.security.provider.YaleCasContext.PortalServiceUrl";
    
    private Document doc = null;
    private Document docmod = null;
    
    /**
     * Constructeur
     * @param mainChannel La channel principale
     */
    public ViewDocument(MainChannel mainChannel) {
        super(mainChannel);
    }

    /**
     * Indique le niveau requis pour raliser cette action
     * Implements AbstractAction.getLevel() method
     * @return level Le niveau requis pour accder  cette action
     */
    public int getLevel() {
        return Security.NONE;
    }
    
    /**
     * Etape 2/4 du cycle de vie de la SubChannel
     * Affiche un document
     * Override SubChannel.init() method
     * @param rd Les runtimeData
     * @return Boolean TRUE si tout se passe bien, FALSE sinon
     * @throws PortalException
     * @throws FrameWorkException
     */
    public Boolean init(ChannelRuntimeData rd) throws PortalException, FrameWorkException {
        super.init(rd);
        if(super.initialize(rd).equals(Boolean.FALSE)) {
            return Boolean.FALSE;
        }
        if(log.isDebugEnabled()) {
            log.debug("ViewDocument::init()");
        }
        String id = getRuntimeData().getParameter("id");
        if(id == null || id.equals("")) {
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean("Erreur d'acc\u00E8s \u00E0 la page"), "intranet");
            return Boolean.FALSE;
        }
        DataControler data = new DataControler();
        try {
            doc = data.getDocument(intranet.getId(), id);
            if(doc.isPendingModification()) {
                docmod = data.getLinkedDocument(intranet.getId(), id);
                docmod.setAuthor(Users.getUserDisplayName(docmod.getAuthor()));
            }
        }
        catch(DataException e) {
            log.error("ViewDocument::init() : DataException :\n" + e);
            Hashtable parameters = new Hashtable();
            parameters.put("folder", folderid);
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean(e.getMessage()), "viewfolder", parameters);
            return Boolean.FALSE;
        }
        if(!doc.isValid() && doc.isPendingModification()) {
            Hashtable parameters = new Hashtable();
            parameters.put("folder", folderid);
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean("Erreur d'acc\u00E8s \u00E0 la page"), "viewfolder", parameters);
            return Boolean.FALSE;
        }
        if(!doc.isValid() && level < Security.ED_VAL && !doc.getAuthor().equals(userid)) {
            Hashtable parameters = new Hashtable();
            parameters.put("folder", folderid);
            Message.message(getMainChannel(), getRuntimeData(), new MessageBean("Vous n'\u00EAtes pas autoris\u00E9 \u00E0 effectuer cette op\u00E9ration"), "viewfolder", parameters);
            return Boolean.FALSE;
        }
        doc.setAuthor(Users.getUserDisplayName(doc.getAuthor()));
        return Boolean.TRUE;
    }
    
    /**
     * Etape 3/4 du cycle de vie de la SubChannel
     * Affiche un document
     * Override SubChannel.setXML() method
     * @return Boolean TRUE si tout se passe bien, FALSE sinon
     * @throws FrameWorkException
     */
    public Boolean setXML() throws FrameWorkException {
        if(log.isDebugEnabled()) {
            log.debug("ViewDocument::setXML()");
        }
        StringBuffer xml = new StringBuffer();
        xml.append(doc.toXMLString());
        if(doc.isPendingModification() && level > Security.AUT_FULL) {
            xml.append("<mod>\n");
            xml.append(docmod.toXMLString());
            xml.append("</mod>\n");
        }
        if(log.isDebugEnabled()) {
            log.debug("ViewDocument::setXML()\n" + xml.toString());
        }
        setXML(xml.toString());
        getXSLParameter().put("intranet", intranet.getId());
        getXSLParameter().put("folder", folderid);
        getXSLParameter().put("fname", Config.getInstance().getProperty("fname"));
        getXSLParameter().put("server_cas", PropertiesManager.getProperty(CAS_URL_PROPERTY));
        getXSLParameter().put("server_esup", PropertiesManager.getProperty(PORTAL_URL_PROPERTY));
        return Boolean.TRUE;
    }
    
    /**
     * Etape 4/4 du cyle de vie de la SubChannel
     * Positionne le titre SSL  utiliser
     * Override SubChannel.setOutput() method
     */
    public void setOutput() throws FrameWorkException {
        super.setOutput();
        addDownloadXslParameter();
        if(level < Security.ED_VAL) {
            setXSL("normal");
            return;
        }
        if(doc.isPendingModification()) {
            setXSL("ed_mod");
            return;
        }
        if(doc.isPendingDeletion()) {
            setXSL("ed_del");
            return;
        }
        if(!doc.isValid()) {
            setXSL("ed_new");
            return;
        }
        setXSL("ed_normal");
    }
}
