package org.esupportail.portal.channels.CIntranet.beans;

import org.esupportail.portal.channels.CIntranet.utils.Date;

/**
 * Document<br>
 * <br>
 * Classe abstraite dfinissant les comportements par dfaut d'un document<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version $Revision: 1.1.2.4 $
 * 
 */
public abstract class Document implements Comparable, XMLSerializable {

    public static final int LINK = 1;
    public static final int FILE = 2;
    
    private int type = 0;
    private String id = "";
    private String intranet = "";
    private String folderid = "";
    private String name = "";
    private String description = "";
    private String author = "";
    private String date = "";
    private String validityDate = "";
    private int order = 0;
    private boolean valid = false;
    private boolean visible = false;
    private boolean pendingModification = false;
    private boolean pendingDeletion = false;    
    /**
     * Constructeur
     */
    public Document() {
    }
    
    /** 
     * Retourne le type de document
     * @return type Document.LINK | Document.FILE
     */
    public int getType() {
        return this.type;
    }
    
    /**
     * Positionne le type de document
     * @param type Document.LINK | Document.FILE
     */
    public void setType(int type) {
        this.type = type;
    }
    
    /**
     * Retourne l'identifiant
     * @return id L'identifiant
     */
    public String getId() {
        return id;
    }
    
    /**
     * Positionne l'identifiant
     * @param id L'identifiant
     */
    public void setId(String id) {
        this.id = id;
    }
    
    /**
     * Retourne l'identifiant d'intranet
     * @return intranet L'identifiant
     */
    public String getIntranet() {
        return intranet;
    }
    
    /**
     * Retourne l'identifiant d'intranet
     * @param intranet L'identifiant
     */
    public void setIntranet(String intranet) {
        this.intranet = intranet;
    }
    
    /**
     * Positionne le dossier
     * @return folderid Le dossier
     */
    public String getFolderid() {
        return folderid;
    }
    
    /**
     * Retourne le dossier
     * @param folderid Le dossier
     */
    public void setFolderid(String folderid) {
        this.folderid = folderid;
    }
        
    /**
     * Retourne le nom
     * @return name Le nom
     */
    public String getName() {
        return name;
    }
    
    /**
     * Positionne le nom
     * @param name Le nom
     */
    public void setName(String name) {
        this.name = name;
    }  
    
    /**
     * Retourne la description
     * @return description La description
     */
    public String getDescription() {
        return description;
    }
    
    /**
     * Positionne la description
     * @param description La description
     */
    public void setDescription(String description) {
        this.description = description;
    }
    
    /**
     * Retourne l'auteur
     * @return author L'auteur
     */
    public String getAuthor() {
        return author;
    }
    
    /**
     * Positionne l'auteur
     * @param author L'auteur
     */
    public void setAuthor(String author) {
        this.author = author;
    }
        
    /**
     * Retourne la date de dpt / modification
     * @return La date
     */
    public String getDate() {
        return date;
    }
    
    /**
     * Positionne la date de dpt / modification
     * @param date La date
     */
    public void setDate(String date) {
        this.date = date;
    }
    
    /**
     * Retourne la date de validit
     * @return validityDate La date
     */
    public String getValidityDate() {
        return validityDate;
    }
    
    /**
     * Retourne la date de validit au format jj/mm/aaaa
     * @return validityDate La date
     */
    public String getValidityInput() {
        if(validityDate.equals("99999999")) {
            return "";
        }
        return validityDate.substring(6) + "/" + validityDate.substring(4,6) + "/" + validityDate.substring(0,4);
    }
    
    /**
     * Positionne la date de validit
     * @param validityDate La date
     */
    public void setValidityDate(String validityDate) {
        this.validityDate = validityDate;
    }

    /**
     * Indique si le document est prim
     * @return perim La premption
     */
    public boolean isPerimed() {
        return validityDate.compareTo(Date.getCurrentDate()) < 0;
    }
    
    /**
     * Retourne le numro d'ordre
     * @return order L'ordre
     */
    public int getOrder() {
        return order;
    }
    
    /**
     * Positionne le numro d'ordre
     * @param order L'ordre
     */
    public void setOrder(int order) {
        this.order = order;
    }
    
    /**
     * Retourne la validit
     * @return valid La validit
     */
    public boolean isValid() {
        return valid;
    }
    
    /**
     * Positionne la validit
     * @param valid La validit
     */
    public void setValid(boolean valid) {
        this.valid = valid;
    }
    
    /**
     * Retourne la visibilit
     * @return visible La visibilit
     */
    public boolean isVisible() {
        return visible;
    }
    
    /**
     * Positionne la visibilit
     * @param visible La visibilit
     */
    public void setVisible(boolean visible) {
        this.visible = visible;
    }
    
    /**
     * Retourne l'tat de modification
     * @return pendingModification L'tat de modification
     */
    public boolean isPendingModification() {
        return pendingModification;
    }
    
    /**
     * Positionne l'tat de modification
     * @param pendingModification L'tat de modification
     */
    public void setPendingModification(boolean pendingModification) {
        this.pendingModification = pendingModification;
    }
    
    /**
     * Retourne l'tat de suppression
     * @return pendingDeletion L'tat de suppression
     */
    public boolean isPendingDeletion() {
        return pendingDeletion;
    }
    
    /**
     * Positionne l'tat de suppression
     * @param pendingDeletion L'tat de suppression
     */
    public void setPendingDeletion(boolean pendingDeletion) {
        this.pendingDeletion = pendingDeletion;
    }
    
    /**
     * Teste l'galit de deux documents
     * Override Object.equals() method
     * @param o Objet  tester
     */
    public abstract boolean equals(Object o);
    
    /**
     * Compare deux documents suivant leur nom
     * Implements Comparable interface
     * @param o Objet  comparer
     */
    public int compareTo(Object o) {
        if(!(o instanceof Document)) {
            throw new ClassCastException("Cannot compare objects from different classes");
        }
        Document doc = (Document)o;
        return getDescription().compareTo(doc.getDescription());
    }
    
    /**
     * La reprsentation XML de cet objet
     * Implements XMLSerializable interface
     * @return Le flux XML
     */
    public abstract String toXMLString();
}
