package org.esupportail.portal.channels.CIntranet.beans;

import org.esupportail.portal.channels.CIntranet.utils.Date;
import org.jasig.portal.utils.XMLEscaper;

/**
 * DocumentFile<br>
 * <br>
 * Document de type fichier<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version $Revision: 1.1.2.2 $
 * 
 */
public class DocumentFile extends Document {

    private String file = "";
    private String extension = "";
    
    /**
     * Constructeur
     */
    public DocumentFile() {
        super();
        setType(Document.FILE);
    }

    /**
     * Retourne le nom du fichier
     * @return file Le nom du fichier
     */
    public String getFile() {
        return file;
    }
    
    /**
     * Positionne le nom du fichier
     * @param file Le nom du fichier
     */
    public void setFile(String file) {
        this.file = file;
    }

    /**
     * Retourne l'extension
     * @return extension L'extension
     */
    public String getExtension() {
        return extension;
    }
    
    /**
     * Positionne l'extension
     * @param extension L'extension
     */
    public void setExtension(String extension) {
        this.extension = extension;
    }
    
    /**
     * Teste l'galit de deux documents
     * Override Object.equals() method
     * @param o Objet  tester
     */
    public boolean equals(Object o) {
        if(!(o instanceof DocumentFile)) {
            return false;
        }
        DocumentFile doc = (DocumentFile)o;
        return (getType() == doc.getType()) && getName().equals(doc.getName()) && getDescription().equals(doc.getDescription()) && getFile().equals(doc.getFile());
    }

    /**
     * La reprsentation XML de cet objet
     * Implements XMLSerializable interface
     * @return Le flux XML
     */
    public String toXMLString() {
        StringBuffer xml = new StringBuffer();
        xml.append("<document type=\"file\" id=\"");
        xml.append(getId());
        xml.append("\" folder=\"");
        xml.append(getFolderid());
        xml.append("\" name=\"");
        xml.append(XMLEscaper.escape(getName()));
        xml.append("\" description=\"");
        xml.append(XMLEscaper.escape(getDescription()));
        xml.append("\" author=\"");
        xml.append(getAuthor());
        xml.append("\" date=\"");
        xml.append(getDate());
        xml.append("\" datetext=\"");
        xml.append(Date.formatDate(getDate()));
        xml.append("\" validity=\"");
        xml.append(getValidityDate());
        xml.append("\" validitytext=\"");
        xml.append(Date.formatDate(getValidityDate()));
        xml.append("\" valid=\"");
        xml.append(isValid());
        xml.append("\" visible=\"");
        xml.append(isVisible());
        xml.append("\" modified=\"");
        xml.append(isPendingModification());
        xml.append("\" deleted=\"");
        xml.append(isPendingDeletion());
        xml.append("\" file=\"");
        xml.append(XMLEscaper.escape(getFile()));
        xml.append("\" extension=\"");
        xml.append(getExtension());
        xml.append("\" order=\"");
        xml.append(getOrder());
        xml.append("\" perimed=\"");
        xml.append(isPerimed());
        xml.append("\" validityinput=\"");
        xml.append(getValidityInput());
        xml.append("\" />\n");
        return xml.toString();
    }
}
