package org.esupportail.portal.channels.CIntranet.beans;

import org.esupportail.portal.channels.CIntranet.utils.Date;
import org.jasig.portal.utils.XMLEscaper;

/**
 * DocumentLink<br>
 * <br>
 * Document de type lien<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version $Revision: 1.1.2.3 $
 * 
 */
public class DocumentLink extends Document {
    
    private String url = "";
    
    /**
     * Constructeur
     */
    public DocumentLink() {
        super();
        setType(Document.LINK);
    }

    /**
     * Retourne l'URL
     * @return url L'URL
     */
    public String getUrl() {
        return url;
    }
    
    /**
     * Positionne l'URL
     * @param url L'URL
     */
    public void setUrl(String url) {
        this.url = url;
    }
    
    /**
     * Teste l'galit de deux documents
     * Override Object.equals() method
     * @param o Objet  tester
     */
    public boolean equals(Object o) {
        if(!(o instanceof DocumentLink)) {
            return false;
        }
        DocumentLink doc = (DocumentLink)o;
        return (getType() == doc.getType()) && getName().equals(doc.getName()) && getDescription().equals(doc.getDescription()) && getUrl().equals(doc.getUrl());
    }

    /**
     * La reprsentation XML de cet objet
     * Implements XMLSerializable interface
     * @return Le flux XML
     */
    public String toXMLString() {
        StringBuffer xml = new StringBuffer();
        xml.append("<document type=\"link\" id=\"");
        xml.append(getId());
        xml.append("\" folder=\"");
        xml.append(getFolderid());
        xml.append("\" name=\"");
        xml.append(XMLEscaper.escape(getName()));
        xml.append("\" description=\"");
        xml.append(XMLEscaper.escape(getDescription()));
        xml.append("\" author=\"");
        xml.append(getAuthor());
        xml.append("\" date=\"");
        xml.append(getDate());
        xml.append("\" datetext=\"");
        xml.append(Date.formatDate(getDate()));
        xml.append("\" validity=\"");
        xml.append(getValidityDate());
        xml.append("\" validitytext=\"");
        xml.append(Date.formatDate(getValidityDate()));
        xml.append("\" valid=\"");
        xml.append(isValid());
        xml.append("\" visible=\"");
        xml.append(isVisible());
        xml.append("\" modified=\"");
        xml.append(isPendingModification());
        xml.append("\" deleted=\"");
        xml.append(isPendingDeletion());
        xml.append("\" url=\"");
        xml.append(XMLEscaper.escape(getUrl()));
        xml.append("\" order=\"");
        xml.append(getOrder());
        xml.append("\" perimed=\"");
        xml.append(isPerimed());
        xml.append("\" validityinput=\"");
        xml.append(getValidityInput());
        xml.append("\" />\n");
        return xml.toString();
    }
}
