package org.esupportail.portal.channels.CIntranet.beans;

import java.util.Iterator;
import java.util.List;

import org.esupportail.portal.channels.CIntranet.utils.Date;
import org.jasig.portal.utils.XMLEscaper;

/**
 * FolderTree<br>
 * <br>
 * Cette classe prend en charge la gestion des dossiers sous forme arborescente<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version $Revision: 1.1.2.3 $
 * 
 */
public class FolderTree extends Folder {

    private List subfolders = null;
    
    /**
     * Constructeur
     * 
     */
    public FolderTree() {
        super();
    }
    
    /**
     * Positionne les sous dossiers
     * @param subfolders Les sous dossiers
     */
    public void setSubfolder(List subfolders) {
        this.subfolders = subfolders;
    }
    
    /**
     * La reprsentation XML de cet objet
     * Implements XMLSerializable interface
     * @return Le flux XML
     */
    public String toXMLString() {
        StringBuffer xml = new StringBuffer();
        xml.append("<folder id=\"");
        xml.append(getId());
        xml.append("\" intranet=\"");
        xml.append(getIntranet());
        xml.append("\" name=\"");
        xml.append(XMLEscaper.escape(getName()));
        xml.append("\" order=\"");
        xml.append(getOrder());
        xml.append("\" parent=\"");
        xml.append(getParentid());
        xml.append("\" date=\"");
        xml.append(getDate());
        xml.append("\" datetext=\"");
        xml.append(XMLEscaper.escape(Date.formatDate(getDate())));
        xml.append("\">\n");
        for(Iterator i = subfolders.iterator();i.hasNext();) {
            FolderTree tmp = (FolderTree)i.next();
            xml.append(tmp.toXMLString());
        }
        xml.append("</folder>\n");
        return xml.toString();
    }
}
