package org.esupportail.portal.channels.CIntranet.config;

import java.util.HashMap;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CIntranet.beans.Ressource;
import org.esupportail.portal.utils.channels.ConfigChannel;

/**
 * Config<br>
 * <br>
 * Classe permettant la lecture du fichier de configuration<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version $Revision: 1.1.2.3 $
 * 
 */

public class Config extends ConfigChannel {

    protected static final Log log = LogFactory.getLog(Config.class);
    private static Config singleton = null;
    
    private Map ressources;
    private Map properties;

	/**
	 * Retourne l'instance de la classe Config
	 * @return singleton L'instance unique
	 */
	public static Config getInstance() {
		if(singleton == null) {
			singleton = new Config();
		}
		return singleton;
	}
	
	/**
	 * Constructeur
	 */
	private Config() {
	}
	
	/**
	 * Retourne le fichier de configuration
	 * @return Le fichier
	 */
	protected String getConfigFile() {
		return "/properties/channels/org_esup/CIntranet/CIntranet.xml";
	}
	
	/**
	 * Rgles de parsing propres au canal Intranet
	 */
	protected void customDigester() {
	    if(log.isDebugEnabled()) {
		    log.debug("Config::customDigester()");
		}
	    		
		// Ressources de stockage
		
		ressources = new HashMap();
		properties = new HashMap();
		
		dig.addObjectCreate("config/storages/storage", Ressource.class);
		dig.addSetProperties("config/storages/storage");
		
			dig.addCallMethod("config/storages/storage/parameters/parameter", "addParameter", 2);
			dig.addCallParam("config/storages/storage/parameters/parameter", 0, "name");
			dig.addCallParam("config/storages/storage/parameters/parameter", 1, "value");
		
		dig.addSetNext("config/storages/storage", "addRessource");
		
		dig.addCallMethod("config/properties/property", "addProperty", 2);
		dig.addCallParam("config/properties/property", 0, "name");
		dig.addCallParam("config/properties/property", 1, "value");
	}
	
	/**
	 * Ajout d'une ressource physique de stockage
	 * @param res
	 */
	public void addRessource(Ressource res) {
	    if(log.isDebugEnabled()) {
		    log.debug("Config::addRessource() : " + res.getName() + " " + res.getClassname());
	    }
		ressources.put(res.getName(), res);
	}
	
	/**
	 * Retourne la liste des ressources de stockage
	 * @return storageControlers La liste des ressources
	 */
	public Map getRessources() {
	    if(log.isDebugEnabled()) {
		    log.debug("Config::getRessources()");
	    }
		return ressources;
	}

	/**
	 * Ajout d'un paramtre de configuration
	 * @param name Le nom du paramtre
	 * @param value La valeur du paramtre
	 */	
	public void addProperty(String name, String value) {
		properties.put(name, value);
	}
	
	/**
	 * Retourne la valeur d'un paramtre
	 * @param name Le nom du paramtre
	 * @return value La valeur du paramtre
	 */
	public String getProperty(String name) {
		return (String)properties.get(name);
	}
}