package org.esupportail.portal.channels.CIntranet.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Properties;

import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CIntranet.beans.Document;
import org.esupportail.portal.channels.CIntranet.beans.Folder;
import org.esupportail.portal.channels.CIntranet.beans.Intranet;
import org.esupportail.portal.channels.CIntranet.config.Config;
import org.esupportail.portal.channels.CIntranet.cron.CRONNotification;
import org.esupportail.portal.channels.CIntranet.data.DataControler;
import org.esupportail.portal.channels.CIntranet.data.DataException;
import org.jasig.portal.properties.PropertiesManager;

/**
 * Notifier<br>
 * <br>
 * Classe permettant d'avertir les utilisateurs par mail de la cration/modification d'un document<br>
 * <br>
 * (c)Copyright <a href="http://www.esup-portail.org">ESup-Portail 2004</a><br>
 * @author <a href="mailto:mathieu.larchet@univ-nancy2.fr">Mathieu Larchet</a>
 * @version $Revision: 1.1.2.2 $
 * 
 */

public class Notifier {
	
	public static final int FILE_NEW = 1;
	public static final int FILE_MODIFIED = 2;
	public static final int LINK_NEW = 3;
	public static final int LINK_MODIFIED = 4;
	
	private static String CAS_URL_PROPERTY = "org.jasig.portal.security.provider.YaleCasContext.CasLoginUrl";
    private static String PORTAL_URL_PROPERTY = "org.jasig.portal.security.provider.YaleCasContext.PortalServiceUrl";
	
	private static String TEMPLATE_MAIL = "/properties/channels/org_esup/CIntranet/templates/notifier_body.html";
	
	protected static Log log = LogFactory.getLog(Notifier.class);
	
	/**
	 * Envoie (si ncessaire) un mail afin d'avertir de modifications sur des fichiers
	 * @param doc Le document
	 * @param type Le type d'vnement
	 */
	public static void sendNotification(Document doc, int type) {
		if(log.isDebugEnabled()) {
			log.debug("Notifier::sendNotification()");
		}
		
		Intranet intranet = null;
		Folder folder = null;
		
		DataControler data = new DataControler();
		try {
			intranet = data.getIntranet(doc.getIntranet());
			folder = data.getFolder(doc.getFolderid());
		}
		catch(DataException e) {
			log.error("Notifier::sendNotification() : DataException :\n" + e);
			return;
		}
		
		if(!folder.isNotifiable()) {
			return;
		}
		
		mail(folder.getMail(), intranet, doc, type);
	}
	
	/**
	 * Envoie un message de notification
	 * @param mail L'adresse de destination
	 * @param intranet L'intranet concern
	 * @param folder Le dossier concern
	 * @param doc Le document concern
	 * @param type Le type d'vnement
	 */
    private static void mail(String mail, Intranet intranet, Document doc, int type) {
        Properties props = System.getProperties();
		props.put("mail.smtp.host", Config.getInstance().getProperty("mail.smtp"));
		Session session = Session.getDefaultInstance(props, null);
		MimeMessage message = new MimeMessage(session);
		try {
            message.setFrom(new InternetAddress(Config.getInstance().getProperty("mail.from")));
            InternetAddress[] dest = new InternetAddress[1];
            dest[0] = new InternetAddress(mail);
            message.setReplyTo(dest);
            message.addRecipients(Message.RecipientType.TO, dest);
			message.setSubject("[INTRANET]");
			BodyPart messageBodyPart = new MimeBodyPart();
			
			messageBodyPart.setText(getTextForEmail(intranet, doc, type));
			messageBodyPart.setContent(getHTMLForEmail(intranet, doc, type), "text/html"); 
	
			Multipart multipart = new MimeMultipart();
			multipart.addBodyPart(messageBodyPart);
			message.setContent(multipart);
			Transport.send(message);
        } 
		catch (MessagingException e) {
	        log.error("Notifier::mail() : MessagingException :\n" + e);
        }
    }
    
    /**
     * Construit le corps du message en plain/text
     * @param intranet L'intranet concern
     * @param folder Le dossier concern
     * @param doc Le document concern
     * @param type Le type d'vnement
     * @return body Le contenu du mail au format texte
     */
    private static String getTextForEmail(Intranet intranet, Document doc, int type) {
        switch(type) {
        	case FILE_MODIFIED : {
        		return "Le fichier '" + doc.getDescription() + "' a \u00E9t\u00E9 modifi\u00E9 sur l'intranet '" + intranet.getName() + "'\n";
        	}
        	case FILE_NEW : {
        		return "Le fichier '" + doc.getDescription() + "' vient d'\u00EAtre d\u00E9pos\u00E9 sur l'intranet '" + intranet.getName() + "'\n";
        	}
        	case LINK_MODIFIED : {
        		return "Le lien '" + doc.getDescription() + "' a \u00E9t\u00E9 modifi\u00E9 sur l'intranet '" + intranet.getName() + "'\n";
        	}
        	case LINK_NEW : {
        		return "Le lien '" + doc.getDescription() + "' vient d'\u00EAtre d\u00E9pos\u00E9 sur l'intranet '" + intranet.getName() + "'\n";
        	}
        	default : {
        		return null;
        	}
        }
    }
    
    /**
     * Construit le corps du message en HTML
     * @param documents La liste des documents  incorporer
     * @return Le texte du message
     */
    private static String getHTMLForEmail(Intranet intranet, Document doc, int type) {
  
        BufferedReader mail_reader = null;
        
        try {
            mail_reader = new BufferedReader(new FileReader(new File(CRONNotification.class.getResource(TEMPLATE_MAIL).getFile())));
        }
        catch(FileNotFoundException e) {
            System.out.println("FileNotFoundException :\n" + e);
            return "";
        }
            
        StringBuffer tmp = new StringBuffer();
        String read;
        try {
            while((read = mail_reader.readLine()) != null) {
            	tmp.append(read);
            	tmp.append("\n");
            }
        }
        catch(IOException e) {
            log.error("Notifier::getHTMLForEmail() : IOException :\n" + e);
            return null;
        }
        String mail = tmp.toString();
        switch(type) {
        	case FILE_NEW : {
        		mail = mail.replaceAll("\\$TITLE_DOC\\$", "Nouveau fichier");
        		break;
        	}
        	case FILE_MODIFIED : {
        		mail = mail.replaceAll("\\$TITLE_DOC\\$", "Fichier modifi\u00E9");
        		break;
        	}
        	case LINK_NEW : {
        		mail = mail.replaceAll("\\$TITLE_DOC\\$", "Nouveau lien");
        		break;
        	}
        	case LINK_MODIFIED : {
        		mail = mail.replaceAll("\\$TITLE_DOC\\$", "Lien modifi\u00E9");
        		break;
        	}
        }
        
        mail = mail.replaceAll("\\$INTRANET_NAME\\$", intranet.getName());
        mail = mail.replaceAll("\\$DOC_NAME\\$", doc.getDescription());
        
        StringBuffer url = new StringBuffer();
        
        url.append(PropertiesManager.getProperty(CAS_URL_PROPERTY));
        url.append("?service=");
        url.append(PropertiesManager.getProperty(PORTAL_URL_PROPERTY));
        url.append("?uP_fname=");
        url.append(Config.getInstance().getProperty("fname"));
        url.append("%26uP_args%3D");
        url.append("action%3Dviewdocument");
        url.append("%7Cintranet%3D" + intranet.getId());
        url.append("%7Cfolder%3D" + doc.getFolderid());
        url.append("%7Cid%3D" + doc.getId());
           
        mail = mail.replaceAll("\\$LINK\\$", url.toString());
            
        return mail.toString();
    }

}