/*
ESUP-portail is a french academic project developed under the GPL (General Public License) augmented according to the following :
A binary or source file developped by ESUP-portail can be used or compiled with products under Apache license.
The official english text of the GPL can be found here : http://www.gnu.org/licenses/gpl.html .
A non official french translation can be found here : http://www.linux-France.org/article/these/gpl.html .
The different kinds of licenses governing the products developed by the Apache foundation can be found here : http://www.apache.org/licenses .
It follows that you can as well as use download contents as well modify and redistribute them provided you respect the GPL terms.
Downloading and using such contents do not provide any guaranty.
Be sure that you have well understood the terms of the license before using the contents it covers.
The ESUP-portail distribution includes the following distributions :
    * UPortal :
      software developed by JA-SIG (Java Architecture - Special Interest Group)
      You can find the license page here : http://mis105.udel.edu/ja-sig/uportal/license.html
    * CAS :
      SSO solution developed by Yale University
      You can find the project page here : http://www.yale.edu/tp/auth
    * Cocoon :
      XML framework distributed by the Apache foundation under Apache license;
      Please find the full text here : http://cocoon.apache.org/2.1/license.html
    * Mod_dav:
      A DAV module for Apache web server
      You can find the project page here : http://www.webdav.org/mod_dav
    * IMP :
      webmail from Horde application framework
      You can find the project page here : http://www.horde.org
    * . To be completed
*/

package org.esupportail.portal.channels.CMailTo;

import java.util.HashMap;
import java.util.Iterator;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CMailTo.Mail.MailAttribute;
import org.esupportail.portal.channels.CMailTo.Mail.Mail;
import org.esupportail.portal.channels.CMailTo.MailExceptions.*;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.ChannelRuntimeProperties;
import org.jasig.portal.ChannelStaticData;
import org.jasig.portal.IChannel;
import org.jasig.portal.PortalEvent;
import org.jasig.portal.PortalException;
import org.jasig.portal.utils.XSLT;
import org.xml.sax.ContentHandler;


 
public class CMailTo implements IChannel{
    
    private static final Log log = LogFactory.getLog(CMailTo.class);
    protected ChannelRuntimeData runtimeData = null;
    private ChannelStaticData staticData = null;
    private HashMap attributesDefined = new HashMap();
    private Mail message =null;
    
    /*Constructeur*/
    public CMailTo() {
        message = new Mail();
    }

    /* (non-Javadoc)
     * @see org.jasig.portal.IChannel#setStaticData(org.jasig.portal.ChannelStaticData)
     */
    public void setStaticData(ChannelStaticData sd) throws PortalException {
        this.staticData = sd;

        MailAttribute att;
        
        att = new MailAttribute();
        if ( (staticData.getPerson().isGuest()) 
             || (staticData.getPerson().getAttribute("mail").toString()==null)
             || (staticData.getPerson().getAttribute("mail").toString().equals("")) ){
            att.setValue("");
            att.setModifiable(true);
            att.setVisible(true);
        }
        else {
            att.setValue(staticData.getPerson().getAttribute("mail").toString());
            att.setModifiable(false);
            att.setVisible(false);           
        }

        message.defineFrom(att);  
    }

    /* (non-Javadoc)
     * @see org.jasig.portal.IChannel#setRuntimeData(org.jasig.portal.ChannelRuntimeData)
     */
    public void setRuntimeData(ChannelRuntimeData rd) throws PortalException {
        this.runtimeData = rd;

        buildMail();
        
      if (runtimeData.getParameter("mailCancel")!=null){
          
          //L'utilisateur a cliqu sur le bouton "annul"
          runtimeData.setParameter("servantFinished","true");
                      
      }

      else if (runtimeData.getParameter("mailWritten")!=null){
          
          
        
          try {   
              
              message.send(); 
              
              runtimeData.setParameter("servantFinished","true");
              
              emptyForm();
              
          }catch (FromException e){
              log.error("CMailTo::setRuntimeData : FromException : "+e);
              MailAttribute att = message.getFrom();
              att.setError(true);
              message.defineFrom(att);
          }catch (ToException e){
              log.error("CMailTo::setRuntimeData : ToException : "+e);
              MailAttribute att = message.getTo();
              att.setError(true);
              message.defineTo(att);
          }catch (SubjectException e){
              log.error("CMailTo::setRuntimeData : SubjectException :  "+e);
              MailAttribute att = message.getSubject();
              att.setError(true);
              message.defineSubject(att);
          }catch (BodyException e){
              log.error("CMailTo::setRuntimeData : BodyException : "+e);
              MailAttribute att = message.getContent();
              att.setError(true);
              message.defineContent(att);
          }catch (BccException e){
              log.error("CMailTo::setRuntimeData : BccException : "+e);
              MailAttribute att = message.getBcc();
              att.setError(true);
              message.defineBcc(att);
          }catch (CcException e){
              log.error("CMailTo::setRuntimeData : CcException : "+e);
              MailAttribute att = message.getCc();
              att.setError(true);
              message.defineCc(att);
          }catch (MalFormedMailException e) {
              log.error("CMailTo::setRuntimeData : Une erreur a eu lieu lors de l'envoie du message."+e);
          }
      }
    }
    
    
    protected Mail buildMail(){
        
        MailAttribute att;
        
        att = new MailAttribute();
        
	    Iterator i = message.getAttributes().keySet().iterator();
	     
	    /*Rcuperation des valeurs saisies*/
		while (i.hasNext()){
		    String attName = (String)i.next();
		    MailAttribute attTemp = message.getAttribute(attName);
		    /*Recupre les paramtres saisis*/
		    if (runtimeData.getParameter(attTemp.getFieldForm())!=null){        
		        message.setAttribute(attName,runtimeData.getParameter(attTemp.getFieldForm())); 
		        if (log.isDebugEnabled()){
		              log.debug("CMailTo::buildMail() : *******\n"
		                      	+"\""+attName+"\" saisi par l'utilisateur : "
		                      	+"\t valeur  = "+runtimeData.getParameter(attTemp.getFieldForm()));
		        }
		    }
		    
		    
		    /*Recupre les paramtres envoys par le canal appellant*/
		    else if (runtimeData.getParameterValues(attName)!=null){
		        String[] myAttrib = runtimeData.getParameterValues(attName);
		        att = new MailAttribute();
		        att.setValue(myAttrib[0]);
		        if (log.isDebugEnabled()){
		              log.debug("CMailTo::buildMail() : *******\n"
		                      	+"\""+attName+"\" definit par le canal appelant : "
		                      	+"\t valeur  = "+myAttrib[0]);
		        }
		        if (myAttrib.length>1){
			        att.setModifiable(myAttrib[1].equalsIgnoreCase("true"));
			        if (log.isDebugEnabled()){
			              log.debug("\t modifiable = "+myAttrib[1]);
			        }
		        }
		        if (myAttrib.length>2){
			        att.setVisible(myAttrib[2].equalsIgnoreCase("true"));
			        if (log.isDebugEnabled()){
			              log.debug("\t visible = "+myAttrib[2]);
			        }
		        }
		        message.defineAttribute(attName,att);  
		        attributesDefined.put(attName,att);
		    }
		    
		    
		    /*Recupre les paramtres envoys par le canal appellant*/
		    else if (attributesDefined.get(attName)!=null){
		        message.defineAttribute(attName,(MailAttribute)attributesDefined.get(attName));
		        if (log.isDebugEnabled()){
		              log.debug("CMailTo::buildMail() : *******\n"
		                      	+"\""+attName+"\"  definit par le canal appelant..."
		                      	+"\t aucune modifiaction");
		        }
		    }
		        
		}
		
        return message;
        
    }
    
    protected void emptyForm(){     


        Iterator i = message.getAttributes().keySet().iterator();
	    
	    /*Rcuperation des valeurs saisies*/
		while (i.hasNext()){
		    String attName = (String)i.next();
		    MailAttribute attTemp = message.getAttribute(attName);
		    
		    if (runtimeData.getParameter(attTemp.getFieldForm())!=null){
		        runtimeData.remove(attTemp.getFieldForm());
		    }
		    
		}

        
    }
    
    

    /* (non-Javadoc)
     * @see org.jasig.portal.IChannel#receiveEvent(org.jasig.portal.PortalEvent)
     */
    public void receiveEvent(PortalEvent ev) {
    }

    /* (non-Javadoc)
     * @see org.jasig.portal.IChannel#getRuntimeProperties()
     */
    public ChannelRuntimeProperties getRuntimeProperties() {
        return null;
    }

    /* (non-Javadoc)
     * @see org.jasig.portal.IChannel#renderXML(org.xml.sax.ContentHandler)
     */
    public void renderXML(ContentHandler out) throws PortalException {


        
    StringBuffer xml = new StringBuffer();
    xml.append("<?xml version=\"1.0\"?><xml>");
    
    Iterator i = message.getAttributes().keySet().iterator();
    String temp = new String();
    
    /*Rcuperation des valeurs saisies*/
	while (i.hasNext()){
	    String attName = (String)i.next();
	    MailAttribute attTemp = message.getAttribute(attName);
	    temp = "";
    	if (attTemp.getValue()!=null)temp = attTemp.getValue();
	    xml.append("<"+attName.toUpperCase()+" ");
	    xml.append("name=\""+attTemp.getFieldForm()+"\" ");
	    xml.append("value=\""+temp+"\" ");
	    xml.append("visible=\""+attTemp.isVisible()+"\" ");
	    xml.append("modifiable=\""+attTemp.isModifiable()+"\" ");
	    int err = 0;
	    if (attTemp.isError())err = 1;
	    xml.append("error=\""+err+"\" ");
	    xml.append("/>");
	    
	    
	}
    xml.append("</xml>");
        
    XSLT xslt = new XSLT(this);
    xslt.setXML(xml.toString());
    xslt.setXSL("CMailTo.ssl", "main", runtimeData.getBrowserInfo());
    /*Envoie des paramtres au fichierXSL*/       
    xslt.setStylesheetParameter("baseActionURL", runtimeData.getBaseActionURL());
    

    xslt.setTarget(out);
    xslt.transform();
    }
    
    
}
