/*
 * Copyright  2004 ESUP-portail consortium  
 * 
 * Authors : Sbastien GAUDIN
 * 
 * This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation augmented according to the possibility of using it with programs developped under the Apache licence published by the Apache Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * 
 * See the license terms site for more details : http://www.esup-portail.org/license.html
*/
package org.esupportail.portal.channels.CMailTo;

import org.jasig.portal.ChannelStaticData;
import org.jasig.portal.IServant;
import org.jasig.portal.PortalException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CMailToServantFactory {

    private static final Log log = LogFactory.getLog(CMailTo.class);
    /**
	 * Retourne une instance de CMailToServant.
	 */
	public static IServant getMailServant(ChannelStaticData sd)
		throws PortalException {
		try {
			CMailToServant servant = new CMailToServant();
			servant.setStaticData(sd);

			return (IServant) servant;
		} catch (Exception e) {
		    log.error("CMailToServantFactory::getMailServant() : impossible d'initialiaser le servant : "
					+ e);
		    
			throw (
				new PortalException(
					"CMailToServantFactory - impossible d'initialiaser le servant : "
						+ e));
		}
	}
}
