<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
   <xsl:output method="html" indent="no" />
   
   <xsl:param name="baseActionURL"/>
   
   <xsl:template match="/xml">
   	<FORM NAME="mail" action="{$baseActionURL}">
		<table border="0">
		<xsl:apply-templates select="SMTP"/>
		<xsl:apply-templates select="FROM"/>
		<xsl:apply-templates select="TO"/>
		<xsl:apply-templates select="CC"/>
		<xsl:apply-templates select="BCC"/>
		<xsl:apply-templates select="SUBJECT"/>
		<xsl:apply-templates select="MESSAGE"/>
		</table>
		<INPUT class="uportal-button" TYPE="SUBMIT" name="mailWritten" VALUE="ENVOYER" />
		<INPUT class="uportal-button" TYPE="SUBMIT" name="mailCancel" VALUE="ANNULER" />
	</FORM>
   </xsl:template>
   
   
   
   
   <xsl:template match="TO">
   	<xsl:if test="@visible='true'">
   		<tr><td>
				<xsl:choose>
					<xsl:when test="@error=1"><font class="uportal-channel-error">ERREUR :<br/>
						Destinataire</font>
					</xsl:when>
					<xsl:otherwise>
						<font class="uportal-text">Destinataire</font>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<td>
			<xsl:choose>
				<xsl:when test="@modifiable='true'">
					<INPUT TYPE="TEXT" NAME="toField" VALUE="{@value}" SIZE="100" CLASS="uportal-input-text" />
				</xsl:when>
				<xsl:otherwise>
					<font class="uportal-text"><xsl:value-of select="@value"/></font>
				</xsl:otherwise>
			</xsl:choose>
			</td>
		</tr>
   	</xsl:if>
   </xsl:template>
   
   <xsl:template match="FROM">
   	<xsl:if test="@visible='true'">
		<tr><td>
				<xsl:choose>
					<xsl:when test="@error=1">
						<font class="uportal-channel-error">ERREUR :<br/>Expditeur</font>
					</xsl:when>
					<xsl:otherwise>
						<font class="uportal-text">Expditeur</font>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<td>
				<xsl:choose>
					<xsl:when test="@modifiable='true'">
						<INPUT TYPE="TEXT" NAME="fromField" VALUE="{@value}" SIZE="100" CLASS="uportal-input-text" />
					</xsl:when>
					<xsl:otherwise>
					<font class="uportal-text"><xsl:value-of select="@value"/></font>
					</xsl:otherwise>
				</xsl:choose>
			</td>
		</tr>
   	</xsl:if>
   </xsl:template>
   
   <xsl:template match="CC">
   	<xsl:if test="@visible='true'">
		<tr>
			<td>
				<xsl:choose>
					<xsl:when test="@error=1">
						<font class="uportal-channel-error">ERREUR :<br/>Copie visible </font>
					</xsl:when>
					<xsl:otherwise>
						<font class="uportal-text">Copie visible </font>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<td>
				<xsl:choose>
					<xsl:when test="@modifiable='true'">
						<INPUT TYPE="TEXT" NAME="ccField" VALUE="{@value}" SIZE="100" CLASS="uportal-input-text" />
					</xsl:when>
					<xsl:otherwise>
					<font class="uportal-text"><xsl:value-of select="@value"/></font>
					</xsl:otherwise>
				</xsl:choose>
			</td>
		</tr>
   	</xsl:if>
   </xsl:template>
   
   <xsl:template match="SUBJECT">
   	<xsl:if test="@visible='true'">
		<tr>
			<td>
				<xsl:choose>
					<xsl:when test="@error=1">
						<font class="uportal-channel-error">ERREUR :<br/>Objet</font>
					</xsl:when>
					<xsl:otherwise>
						<font class="uportal-text">Objet</font>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<td>
			<xsl:choose>
				<xsl:when test="@modifiable='true'">
					<INPUT TYPE="TEXT" NAME="subjectField" VALUE="{@value}" SIZE="100" CLASS="uportal-input-text" />
				</xsl:when>
				<xsl:otherwise>
					<font class="uportal-text"><xsl:value-of select="@value"/></font>
				</xsl:otherwise>
			</xsl:choose>
			</td>
		</tr>
   	</xsl:if>
   </xsl:template>
   
   <xsl:template match="MESSAGE">
   	<xsl:if test="@visible='true'">
		<tr>
			<td colspan="2" align="center">
				<xsl:if test="@error=1">
					<font class="uportal-channel-error">ERREUR :<br/>Vous devez saisir un message <br/></font>
				</xsl:if>
				<xsl:choose>
					<xsl:when test="@modifiable='true'">
						<TEXTAREA NAME="bodyField" rows="10" cols="100" CLASS="uportal-input-text"><xsl:value-of select="@value" /></TEXTAREA>
					</xsl:when>
					<xsl:otherwise>
					<font class="uportal-text"><xsl:value-of select="@value"/></font>
					</xsl:otherwise>
				</xsl:choose>
			</td>
		</tr>
   	</xsl:if>
   </xsl:template>
   
   <xsl:template match="BCC">
   	<xsl:if test="@visible='true'">
   		<tr>
			<td>
				<xsl:choose>
					<xsl:when test="@error=1">
						<font class="uportal-channel-error">ERREUR :<br/>Copie cache </font>
					</xsl:when>
					<xsl:otherwise>
						<font class="uportal-text">Copie cache </font>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<td>
				<xsl:choose>
					<xsl:when test="@modifiable='true'">
						<INPUT TYPE="TEXT" NAME="bccField" VALUE="{@value}" SIZE="100" CLASS="uportal-input-text" />
					</xsl:when>
					<xsl:otherwise>
					<font class="uportal-text"><xsl:value-of select="@value"/></font>
					</xsl:otherwise>
				</xsl:choose>
			</td>
		</tr>
   	</xsl:if>
   </xsl:template>
   
   <xsl:template match="SMTP">
   	<xsl:if test="@visible='true'">
   		<tr>
			<td>Serveur</td>
			<td>
				<xsl:choose>
					<xsl:when test="@modifiable='true'">
						<INPUT TYPE="TEXT" NAME="smtpField" VALUE="{@value}" SIZE="100" CLASS="uportal-input-text" />
					</xsl:when>
					<xsl:otherwise>
						<font class="uportal-text"><xsl:value-of select="@value"/></font>
					</xsl:otherwise>
				</xsl:choose>
			</td>
		</tr>
   	</xsl:if>
   </xsl:template>

</xsl:stylesheet>