/*
ESUP-portail is a french academic project developed under the GPL (General Public License) augmented according to the following :
A binary or source file developped by ESUP-portail can be used or compiled with products under Apache license.
The official english text of the GPL can be found here : http://www.gnu.org/licenses/gpl.html .
A non official french translation can be found here : http://www.linux-France.org/article/these/gpl.html .
The different kinds of licenses governing the products developed by the Apache foundation can be found here : http://www.apache.org/licenses .
It follows that you can as well as use download contents as well modify and redistribute them provided you respect the GPL terms.
Downloading and using such contents do not provide any guaranty.
Be sure that you have well understood the terms of the license before using the contents it covers.
The ESUP-portail distribution includes the following distributions :
    * UPortal :
      software developed by JA-SIG (Java Architecture - Special Interest Group)
      You can find the license page here : http://mis105.udel.edu/ja-sig/uportal/license.html
    * CAS :
      SSO solution developed by Yale University
      You can find the project page here : http://www.yale.edu/tp/auth
    * Cocoon :
      XML framework distributed by the Apache foundation under Apache license;
      Please find the full text here : http://cocoon.apache.org/2.1/license.html
    * Mod_dav:
      A DAV module for Apache web server
      You can find the project page here : http://www.webdav.org/mod_dav
    * IMP :
      webmail from Horde application framework
      You can find the project page here : http://www.horde.org
    * . To be completed
*/
package org.esupportail.portal.channels.CMailTo.Mail;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.Vector;
import javax.activation.DataHandler;
import javax.activation.FileDataSource;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CMailTo.CMailTo;
import org.esupportail.portal.channels.CMailTo.MailExceptions.*;

public class Mail {
    private static final Log log = LogFactory.getLog(CMailTo.class);
    private HashMap Attributes = new HashMap();
    //private HashMap AttributesField = new HashMap();

    public final static String FROM 	= "from";
    public final static String TO 		= "to";
    public final static String CC 		= "cc";
    public final static String BCC 		= "bcc";
    public final static String SUBJECT 	= "subject";
    public final static String CONTENT 	= "message";
    public final static String SERVER 	= "smtp";
    
    private  static String FROMFIELD 	= "";
    private  static String TOFIELD 		= "";
    private  static String CCFIELD 		= "";
    private  static String BCCFIELD 	= "";
    private  static String SUBJECTFIELD = "";
    private  static String CONTENTFIELD = "";
    private  static String SERVERFIELD 	= "";    
    private static String defaultSmtp;
    private static String defaultDomain;
    private final static String CONFIG_FILE_PATH = "/properties/channels/org_esup/CMailTo/Mail.properties";
    private static String FORMAT_MAIL 	= "";
    private static String FORMAT_LISTE_MAIL 	= "";
    private boolean CopyToSender 	= false;
  
    static {
        InputStream ins = null;
		try {
	        /*Lecture du fichier de proprietes*/
	        ins = CMailTo.class.getResourceAsStream(CONFIG_FILE_PATH);
	        Properties confFile = new Properties ();
	        confFile.load (ins);

	        /*Recuperation des parametres*/
	        //serveur smtp par dfaut
	        defaultSmtp = confFile.getProperty ("smtp");
	        
            // domain smtp par dfaut
            defaultDomain = confFile.getProperty ("domain");
            
            //champs du formulaire
	        FROMFIELD 	= confFile.getProperty ("nameOfFieldFrom");
	        TOFIELD 		= confFile.getProperty ("nameOfFieldTo");
	        CCFIELD 		= confFile.getProperty ("nameOfFieldCc");
	        BCCFIELD 		= confFile.getProperty ("nameOfFieldBcc");
	        SUBJECTFIELD 	= confFile.getProperty ("nameOfFieldSubject");
	        CONTENTFIELD 	= confFile.getProperty ("nameOfFieldContent");
	        SERVERFIELD 	= confFile.getProperty ("nameOfFieldSmtp");  
	        //expression regulire d'un mail
	        FORMAT_MAIL		= " *"+confFile.getProperty ("formatMail")+" *";  
	        FORMAT_LISTE_MAIL = FORMAT_MAIL+"(,"+FORMAT_MAIL+")*";	         
	    }
	    catch (Exception e) {
	        log.error("Mail::static : Impossible de lire le fichier de configuration : "+CONFIG_FILE_PATH,e);
	    } finally {
	        try {
	            if(ins != null)        
	                ins.close();
	        }catch(IOException ioe) {
		        log.error("Mail::static : Impossible de fermer l'InputStream : ",ioe);
	        }
	    }
    }     
        
	/**
	 * Constructeur
	 */
	public Mail() {	     
	    //Creation de l'attribut FROM par defaut
	    Attributes.put(FROM,new MailAttribute(FROMFIELD));
	    //Creation de l'attribut TO par defaut
	    Attributes.put(TO,new MailAttribute(TOFIELD));
	    //Creation de l'attribut CC par defaut
	    Attributes.put(CC,new MailAttribute(CCFIELD));
	    //Creation de l'attribut BCC par defaut
	    Attributes.put(BCC,new MailAttribute(BCCFIELD));
	    //Creation de l'attribut SUBJECT par defaut
	    Attributes.put(SUBJECT,new MailAttribute(SUBJECTFIELD));
	    //Creation de l'attribut CONTENT par defaut
	    Attributes.put(CONTENT,new MailAttribute(CONTENTFIELD));               
	    //Creation de l'attribut SERVER par defaut
	    MailAttribute serveur = new MailAttribute(SERVERFIELD);
		
        serveur.setValue(defaultSmtp);
		serveur.setModifiable(false);
		serveur.setVisible(false);
        
	    Attributes.put(SERVER,serveur);	  
	}
		
	/**
	 * Teste si le mail contient toute les proprits obligatoires
	 * @throws MalFormedMailException
	 */
	private void isValid() throws MalFormedMailException{
		getFrom().setError(false);
		getTo().setError(false);
		getSubject().setError(false);
		getContent().setError(false);
		getCc().setError(false);
		getBcc().setError(false);
		
        /* PRE-TRAITEMENT DES DESTINATAIRES */
        String finalAddr = null;
        if(getAttribute(TO).getValue()!=null && !getAttribute(TO).getValue().equals("")) {
            finalAddr = "";
            String[] preTo = getAttribute(TO).getValue().split(",");   
            for (int i=0;i<preTo.length;i++){
                if(!preTo[i].matches("(.*)\\@(.*)")){
                    finalAddr += preTo[i] + "@" + defaultDomain;
                } else {
                    finalAddr += preTo[i];                
                }
                
                if(i<(preTo.length-1)) {                
                    finalAddr +=",";
                }
            }
            setAttribute(TO,finalAddr);
        } 
        
        if(getAttribute(CC).getValue()!=null && !getAttribute(CC).getValue().equals("")) {
            finalAddr = "";
            String[] preCC = getAttribute(CC).getValue().split(",");   
            for (int i=0;i<preCC.length;i++){
                if(!preCC[i].matches("(.*)\\@(.*)")){
                    finalAddr += preCC[i] + "@" + defaultDomain;
                } else {
                    finalAddr += preCC[i];                
                }
                
                if(i<(preCC.length-1)) {                
                    finalAddr +=",";
                }
            }
            setAttribute(CC,finalAddr);
        }
        
        if(getAttribute(BCC).getValue()!=null && !getAttribute(BCC).getValue().equals("")) {
            finalAddr = "";
            String[] preBCC = getAttribute(BCC).getValue().split(",");   
            for (int i=0;i<preBCC.length;i++){
                if(!preBCC[i].matches("(.*)\\@(.*)")){
                    finalAddr += preBCC[i] + "@" + defaultDomain;
                } else {
                    finalAddr += preBCC[i];                
                }
                
                if(i<(preBCC.length-1)) {                
                    finalAddr +=",";
                }
            }
            setAttribute(BCC,finalAddr);
        }
        /* FIN DE PRE-TRAITEMENT DES DESTINATAIRES */
        
	    /*Attributs obligatoires*/
	    if ( (getAttribute(FROM)==null)
	         || (getAttribute(FROM).getValue()==null)
	         || (getAttribute(FROM).getValue().equals("")) 
	         || (!getAttribute(FROM).getValue().matches(FORMAT_LISTE_MAIL)) ){ 
			getFrom().setError(true);
	        throw new FromException(getAttribute(FROM).getValue());
	    }
	    if ( (getAttribute(TO)==null) 
	         || (getAttribute(TO).getValue()==null)
	         || (getAttribute(TO).getValue().equals("")) 
	         || (!getAttribute(TO).getValue().matches(FORMAT_LISTE_MAIL)) ){ 
			getTo().setError(true);
	       throw new ToException(getAttribute(TO).getValue());
	    }
	    if ( (getAttribute(SUBJECT)==null) 
	         || (getAttribute(SUBJECT).getValue()==null) 
	         || (getAttribute(SUBJECT).getValue().equals("")) 
	         ){ 
			getSubject().setError(true);
	        throw new SubjectException(getAttribute(SUBJECT).getValue());
	    }
	    if ( (getAttribute(CONTENT)==null) 
	         || (getAttribute(CONTENT).getValue()==null)
	         || (getAttribute(CONTENT).getValue().equals("")) 
	         ){ 
	    	getContent().setError(true);
	        throw new BodyException(getAttribute(CONTENT).getValue());
	    }	    
	    
	    /*attributs optionnels mais avec controle de valeur*/
	    if ( (getAttribute(CC)!=null) 
	         && (getAttribute(CC).getValue()!=null)
	         && (!getAttribute(CC).getValue().equals("")) 
	         && (!getAttribute(CC).getValue().matches(FORMAT_LISTE_MAIL)) 
	         ){ 
	    	getCc().setError(true);
	        throw new CcException(getAttribute(CC).getValue());
	    }
	    if ( (getAttribute(BCC)!=null) 
	         && (getAttribute(BCC).getValue()!=null)
	         && (!getAttribute(BCC).getValue().equals("")) 
	         && (!getAttribute(BCC).getValue().matches(FORMAT_LISTE_MAIL)) 
	         ){ 
	    	getBcc().setError(true);
	        throw new BccException(getAttribute(BCC).getValue());
	    }
	}
	
	public void send() throws MalFormedMailException {
	    send(null);
	}
		
	/**
	 * Envoyer l'e-mail
	 * @param fich liste contenant les fichiers joints de classe java.io.File
	 * @throws MessagingException
	 * @throws Exception
	 */
	public void send(Vector fich) throws MalFormedMailException {        
        isValid();
        
        Properties props = System.getProperties(); // Obtenir les proprits du system de la machine cliente
        if(this.getAttribute(SERVER).getValue()!=null && !this.getAttribute(SERVER).getValue().equals("")){
            props.put("mail.smtp.host", this.getAttribute(SERVER).getValue());
        } else {
            props.put("mail.smtp.host", defaultSmtp);
        }
            
        // Ajouter le nom du serveur SMTP aux proprits
        // Obtenir un objet session bas sur les proprits
        Session session = Session.getDefaultInstance(props, null);
        // Crer un MimeMessage bas sur la session
        MimeMessage message = new MimeMessage(session);
        try {
            // dfinir ladresse de lexpditeur du message
            message.setFrom(new InternetAddress(getFrom().getValue()));
            InternetAddress[] dest = new InternetAddress[1];
            dest[0] = new InternetAddress(this.getAttribute(FROM).getValue());
            message.setReplyTo(dest);
            dest = null;
            
            // dfinir ladresse du destinataire du message
            String[] addr = getTo().getValue().split(",");
            dest = new InternetAddress[addr.length];
            for (int i=0;i<addr.length;i++){
                dest[i] = new InternetAddress(addr[i]);
            }
            message.addRecipients(Message.RecipientType.TO, dest);
            addr = null;
            dest = null;
            
            // dfinir ladresse du destinataire en copie 
            if ((getCc().getValue()!=null) && (!getCc().getValue().equals(""))){
                addr = getCc().getValue().split(",");
                dest = new InternetAddress[addr.length];
                for (int i=0;i<addr.length;i++){
                    dest[i] = new InternetAddress(addr[i]);
                }
                message.addRecipients(Message.RecipientType.CC, dest);
                addr = null;
                dest = null;                
            }
            
            // dfinir ladresse du destinataire en copie cache
            if ((getBcc().getValue()!=null) && (!getBcc().getValue().equals(""))){
            	if (isCopyToSender()){
            		getBcc().setValue(getBcc().getValue()+","+getFrom().getValue());
                }
                addr = getBcc().getValue().split(",");
                dest = new InternetAddress[addr.length];
                for (int i=0;i<addr.length;i++){
                    dest[i] = new InternetAddress(addr[i]);
                }     
                message.addRecipients(Message.RecipientType.BCC, dest);
                addr = null;
                dest = null;
            }
            else if (isCopyToSender()){
            	dest = new InternetAddress[1];
                dest[0] = new InternetAddress(getFrom().getValue());
                message.addRecipients(Message.RecipientType.BCC, dest);
                dest = null;
            }
            
            // dfinir le sujet du message
            message.setSubject(getSubject().getValue(),"ISO-8859-1");
            
            // Create the message part
            BodyPart messageBodyPart = new MimeBodyPart();
            
            // Fill the message
            messageBodyPart.setText(getContent().getValue());
            messageBodyPart.setContent(getContent().getValue(), "text/plain; charset=\"iso-8859-1\""); 
    
            Multipart multipart = new MimeMultipart();
            multipart.addBodyPart(messageBodyPart);
            
            // Attache les fichiers joints
            if(fich!=null){
                Enumeration enum = fich.elements();
                while(enum.hasMoreElements()){
                    File fd= (File)enum.nextElement();
                    messageBodyPart = new MimeBodyPart();
                    javax.activation.DataSource source = new FileDataSource(fd);
                    messageBodyPart.setDataHandler(new DataHandler(source));
                    messageBodyPart.setFileName(fd.getName());
                    multipart.addBodyPart(messageBodyPart);
                }
              }
            
            // Attache au message
            message.setContent(multipart);
            // envoie du message
            
            Transport.send(message);
                        
            log.info("Mail:send() : Le mail a bien \u00E9t\u00E9 envoy\u00E9 : ");
            log.info("\t de "+getFrom()+" a "+getTo());
              
        } catch (MessagingException e) {
            log.error("Mail::send() : erreur dans l'envoi du message : ",e);
            throw new MalFormedMailException();
        }
    }

	/**
	 * @param nom du paramtre
	 * @param nom du valeur
	 */
	public void setAttribute(String name,String value){                
	    ((MailAttribute)Attributes.get(name)).setValue(value);
	}

	/**
	 * @param mail de l'expditeur du message
	 */
	public void setFrom(String value){
	    ((MailAttribute)Attributes.get(FROM)).setValue(value);
	}	

	/**
	 * @param mail du destinaitaire du message
	 */
	public void setTo(String value){
	    ((MailAttribute)Attributes.get(TO)).setValue(value);
	}	

	/**
	 * @param mail du destinaitaire du message
	 */
	public void setCc(String value){
	    ((MailAttribute)Attributes.get(CC)).setValue(value);
	}	

	/**
	 * @param mail du destinaitaire du message
	 */
	public void setBcc(String value){
	    ((MailAttribute)Attributes.get(BCC)).setValue(value);
	}	

	/**
	 * @param sujet du message
	 */
	public void setSubject(String value){
	    ((MailAttribute)Attributes.get(SUBJECT)).setValue(value);
	}	

	/**
	 * @param corps du message
	 */
	public void setContent(String value){
	    ((MailAttribute)Attributes.get(CONTENT)).setValue(value);
	}		

	/**
	 * @param nom du paramtre
	 * @param attribut
	 */
	public void defineAttribute (String name,MailAttribute attrib){
	    getAttribute(name).setValue(attrib.getValue());
	    getAttribute(name).setModifiable(attrib.isModifiable());
	    getAttribute(name).setVisible(attrib.isVisible());
	}	

	/**
	 * @param mail de l'expditeur du message
	 */
	public void defineFrom(MailAttribute attrib){
	    ((MailAttribute)Attributes.get(FROM)).setFieldForm(FROMFIELD);
	    ((MailAttribute)Attributes.get(FROM)).setValue(attrib.getValue());
	    ((MailAttribute)Attributes.get(FROM)).setModifiable(attrib.isModifiable());
	    ((MailAttribute)Attributes.get(FROM)).setVisible(attrib.isVisible());
	}	

	/**
	 * @param mail du destinaitaire du message
	 */
	public void defineTo(MailAttribute attrib){
	    ((MailAttribute)Attributes.get(TO)).setFieldForm(TOFIELD);
	    ((MailAttribute)Attributes.get(TO)).setValue(attrib.getValue());
	    ((MailAttribute)Attributes.get(TO)).setModifiable(attrib.isModifiable());
	    ((MailAttribute)Attributes.get(TO)).setVisible(attrib.isVisible());
	}	

	/**
	 * @param mail du destinaitaire du message
	 */
	public void defineCc(MailAttribute attrib){
	    ((MailAttribute)Attributes.get(CC)).setFieldForm(CCFIELD);
	    ((MailAttribute)Attributes.get(CC)).setValue(attrib.getValue());
	    ((MailAttribute)Attributes.get(CC)).setValue(attrib.getValue());
	    ((MailAttribute)Attributes.get(CC)).setModifiable(attrib.isModifiable());
	    ((MailAttribute)Attributes.get(CC)).setVisible(attrib.isVisible());
	}	

	/**
	 * @param mail du destinaitaire du message
	 */
	public void defineBcc(MailAttribute attrib){
	    ((MailAttribute)Attributes.get(BCC)).setFieldForm(BCCFIELD);
	    ((MailAttribute)Attributes.get(BCC)).setValue(attrib.getValue());
	    ((MailAttribute)Attributes.get(BCC)).setModifiable(attrib.isModifiable());
	    ((MailAttribute)Attributes.get(BCC)).setVisible(attrib.isVisible());
	}	

	/**
	 * @param sujet du message
	 */
	public void defineSubject(MailAttribute attrib){
	    ((MailAttribute)Attributes.get(SUBJECT)).setFieldForm(SUBJECTFIELD);
	    ((MailAttribute)Attributes.get(SUBJECT)).setValue(attrib.getValue());
	    ((MailAttribute)Attributes.get(SUBJECT)).setModifiable(attrib.isModifiable());
	    ((MailAttribute)Attributes.get(SUBJECT)).setVisible(attrib.isVisible());
	}	

	/**
	 * @param corps du message
	 */
	public void defineContent(MailAttribute attrib){
	    ((MailAttribute)Attributes.get(CONTENT)).setFieldForm(FROMFIELD);
	    ((MailAttribute)Attributes.get(CONTENT)).setValue(attrib.getValue());
	    ((MailAttribute)Attributes.get(CONTENT)).setModifiable(attrib.isModifiable());
	    ((MailAttribute)Attributes.get(CONTENT)).setVisible(attrib.isVisible());
	}		
	
	/**
	 * @return un attribut du mail
	 */
	public MailAttribute getAttribute(String name) {
		return (MailAttribute)Attributes.get(name);
	}
	
	/**
	 * @return l'expditeur du message
	 */
	public MailAttribute getFrom() {
		return (MailAttribute)Attributes.get(FROM);
	}	

	/**
	 * @return le destinaitaire du message
	 */
	public MailAttribute getTo() {
		return (MailAttribute)Attributes.get(TO);
	}	

	/**
	 * @return le destinaitaire du message
	 */
	public MailAttribute getCc() {
		return (MailAttribute)Attributes.get(CC);
	}	

	/**
	 * @return le destinaitaire du message
	 */
	public MailAttribute getBcc() {
		return (MailAttribute)Attributes.get(BCC);
	}	

	/**
	 * @return le sujet du message
	 */
	public MailAttribute getSubject() {
		return (MailAttribute)Attributes.get(SUBJECT);
	}	

	/**
	 * @return le corps du message
	 */
	public MailAttribute getContent() {
		return (MailAttribute)Attributes.get(CONTENT);
	}		
	
	/**
	 * @return Tous les attributs
	 */
	public HashMap getAttributes(){
	    return Attributes;
	}
	/**
	 * @return Returns the cOPYTOSENDER.
	 */
	public boolean isCopyToSender() {
		return CopyToSender;
	}
	/**
	 * @param copytosender The cOPYTOSENDER to set.
	 */
	public void setCopyToSender(boolean copytosender) {
		CopyToSender = copytosender;
	}
}