<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
  <xsl:output method="html" indent="no" />
  <xsl:param name="baseActionURL">baseActionURL_false</xsl:param>
  <xsl:param name="allowCopyBox">false</xsl:param>
   
   <xsl:template match="/xml">
   	<FORM NAME="mail" action="{$baseActionURL}" method="post">
		<table border="0">
		<xsl:apply-templates select="SMTP"/>
		<xsl:apply-templates select="FROM"/>
		<xsl:apply-templates select="TO"/>
		<xsl:apply-templates select="CC"/>
		<xsl:apply-templates select="BCC"/>
		<xsl:apply-templates select="COPYBOX"/>
		<xsl:apply-templates select="SUBJECT"/>
		<xsl:apply-templates select="MESSAGE"/>
		</table>
		<INPUT class="uportal-button" TYPE="SUBMIT" name="mailWritten" VALUE="ENVOYER" />
		<INPUT class="uportal-button" TYPE="SUBMIT" name="mailCancel" VALUE="ANNULER" />
	</FORM>
   </xsl:template>         
   
   <xsl:template match="TO">
   	<xsl:if test="@visible='true'">
   		<tr><td>
				<xsl:choose>
					<xsl:when test="@error=1"><font class="uportal-channel-error">ERREUR :<br/>
						Destinataire</font>
					</xsl:when>
					<xsl:otherwise>
						<font class="uportal-text">Destinataire</font>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<td>
			<xsl:choose>
				<xsl:when test="@modifiable='true'">
					<INPUT TYPE="TEXT" NAME="toField" VALUE="{@value}" SIZE="100" CLASS="uportal-input-text" />
				</xsl:when>
				<xsl:otherwise>
					<font class="uportal-text"><xsl:value-of select="@value"/></font>
				</xsl:otherwise>
			</xsl:choose>
			</td>
		</tr>
   	</xsl:if>
   </xsl:template>
   
   <xsl:template match="FROM">
   	<xsl:if test="@visible='true'">
		<tr><td>
				<xsl:choose>
					<xsl:when test="@error=1">
						<font class="uportal-channel-error">ERREUR :<br/>Expéditeur</font>
					</xsl:when>
					<xsl:otherwise>
						<font class="uportal-text">Expéditeur</font>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<td>
				<xsl:choose>
					<xsl:when test="@modifiable='true'">
						<INPUT TYPE="TEXT" NAME="fromField" VALUE="{@value}" SIZE="100" CLASS="uportal-input-text" />
					</xsl:when>
					<xsl:otherwise>
					<font class="uportal-text"><xsl:value-of select="@value"/></font>
					</xsl:otherwise>
				</xsl:choose>
			</td>
		</tr>
   	</xsl:if>
   </xsl:template>
   
   <xsl:template match="COPYBOX">
   	<xsl:if test="$allowCopyBox='true'">
		<tr>
			<td colspan="2">
				<font class="uportal-text">Recevoir une copie</font>
				<xsl:choose>
					<xsl:when test="@checked='true'">
						<input type="checkbox" name="sendCopyToSender" value="true" checked="true"/>
					</xsl:when>
					<xsl:otherwise>
						<input type="checkbox" name="sendCopyToSender" value="true" />
					</xsl:otherwise>
				</xsl:choose>
				
			</td>
		</tr>
   	</xsl:if>
   </xsl:template>
   
   <xsl:template match="SUBJECT">
   	<xsl:if test="@visible='true'">
		<tr>
			<td>
				<xsl:choose>
					<xsl:when test="@error=1">
						<font class="uportal-channel-error">ERREUR :<br/>Objet</font>
					</xsl:when>
					<xsl:otherwise>
						<font class="uportal-text">Objet</font>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<td>
			<xsl:choose>
				<xsl:when test="@modifiable='true'">
					<INPUT TYPE="TEXT" NAME="subjectField" VALUE="{@value}" SIZE="100" CLASS="uportal-input-text" />
				</xsl:when>
				<xsl:otherwise>
					<font class="uportal-text"><xsl:value-of select="@value"/></font>
				</xsl:otherwise>
			</xsl:choose>
			</td>
		</tr>
   	</xsl:if>
   </xsl:template>
   
   <xsl:template match="MESSAGE">
   	<xsl:if test="@visible='true'">
		<tr>
			<td colspan="2" align="center">
				<xsl:if test="@error=1">
					<font class="uportal-channel-error">ERREUR :<br/>Vous devez saisir un message <br/></font>
				</xsl:if>
				<xsl:choose>
					<xsl:when test="@modifiable='true'">
						<TEXTAREA NAME="bodyField" rows="10" cols="100" CLASS="uportal-input-text"><xsl:value-of select="@value" /></TEXTAREA>
					</xsl:when>
					<xsl:otherwise>
					<font class="uportal-text"><xsl:value-of select="@value"/></font>
					</xsl:otherwise>
				</xsl:choose>
			</td>
		</tr>
   	</xsl:if>
   </xsl:template>
   
   <xsl:template match="CC">
   	<xsl:if test="@visible='true'">
   		<tr>
			<td>
				<xsl:choose>
					<xsl:when test="@error=1">
						<font class="uportal-channel-error">ERREUR :<br/>Copie à</font>
					</xsl:when>
					<xsl:otherwise>
						<font class="uportal-text">Copie à</font>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<td>
				<xsl:choose>
					<xsl:when test="@modifiable='true'">
						<INPUT TYPE="TEXT" NAME="ccField" VALUE="{@value}" SIZE="100" CLASS="uportal-input-text" />
					</xsl:when>
					<xsl:otherwise>
					<font class="uportal-text"><xsl:value-of select="@value"/></font>
					</xsl:otherwise>
				</xsl:choose>
			</td>
		</tr>
   	</xsl:if>
   </xsl:template>
   
   <xsl:template match="BCC">
   	<xsl:if test="@visible='true'">
   		<tr>
			<td>
				<xsl:choose>
					<xsl:when test="@error=1">
						<font class="uportal-channel-error">ERREUR :<br/>Copie cachée à</font>
					</xsl:when>
					<xsl:otherwise>
						<font class="uportal-text">Copie cachée à</font>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<td>
				<xsl:choose>
					<xsl:when test="@modifiable='true'">
						<INPUT TYPE="TEXT" NAME="bccField" VALUE="{@value}" SIZE="100" CLASS="uportal-input-text" />
					</xsl:when>
					<xsl:otherwise>
					<font class="uportal-text"><xsl:value-of select="@value"/></font>
					</xsl:otherwise>
				</xsl:choose>
			</td>
		</tr>
   	</xsl:if>
   </xsl:template>
   
   <xsl:template match="SMTP">
   	<xsl:if test="@visible='true'">
   		<tr>
			<td>Serveur</td>
			<td>
				<xsl:choose>
					<xsl:when test="@modifiable='true'">
						<INPUT TYPE="TEXT" NAME="smtpField" VALUE="{@value}" SIZE="100" CLASS="uportal-input-text" />
					</xsl:when>
					<xsl:otherwise>
						<font class="uportal-text"><xsl:value-of select="@value"/></font>
					</xsl:otherwise>
				</xsl:choose>
			</td>
		</tr>
   	</xsl:if>
   </xsl:template>

</xsl:stylesheet>
