package org.esupportail.portal.channels.CTestMailToMag;


import java.util.Iterator;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.esupportail.portal.channels.CMailTo.Mail.Mail;
import org.esupportail.portal.channels.CTestMailToMag.Config;
import org.esupportail.portal.utils.channels.ActionParam;
import org.esupportail.portal.utils.channels.MainChannel;
import org.esupportail.portal.utils.channels.plugins.Message;
import org.jasig.portal.IServant;
import org.jasig.portal.PortalException;

public class CTestMailToMag extends MainChannel {
	    
	private static final Log log = LogFactory.getLog(CTestMailToMag.class);
	/**
	 * Constructeur
	 */
	public CTestMailToMag() throws PortalException {
		
	    try {
			setConfigActions(Config.getInstance());
		} catch (PortalException e) {
			log.error("CTestMailToMag:CPersInfo() : probleme avec la config ");
		} 
		Message.register(this);
	}


	/**
	 * Mthode appele lors de l'appel  un canal servant<br>
	 * permettant de fixer des paramtres pour ce canal
	*/ 
	public void initServant(IServant servant) throws PortalException {
	    
		 
			
	    Iterator i = this.getCurrentAction().getParams().keySet().iterator();
		/*Rcupration des paramtres sur les actions*/
		while (i.hasNext()){
		    String apName = (String)i.next();
		    
		    String param = null;
		    
		    if (apName.equals("from")){
		        param = Mail.FROM;
		    }else if (apName.equals("to")){
		        param = Mail.TO;
		    }else if (apName.equals("subject")){
		        param = Mail.SUBJECT;
		    }else if (apName.equals("cc")){
		        param = Mail.CC;
		    }else if (apName.equals("bcc")){
		        param = Mail.BCC;
		    }else if (apName.equals("content")){
		        param = Mail.CONTENT;
		    }else if (apName.equals("server")){
		        param = Mail.SERVER;
		    }
		    
		    
		    ActionParam ap = (ActionParam)this.getCurrentAction().getParams().get(apName);
		    Iterator j = ap.getValues().iterator();
		    int count = 0;
		    
		    String[] att = new String[ap.getValues().size()]; 
		    while (j.hasNext()){
		        String val = (String)j.next();
		        att[count] = val;
		        count++;
		    }
		    runtimeData.setParameterValues(param,att);
		}
		
		super.initServant(servant);
	}
}
