/*
ESUP-portail is a french academic project developed under the GPL (General Public License) augmented according to the following :
A binary or source file developped by ESUP-portail can be used or compiled with products under Apache license.
The official english text of the GPL can be found here : http://www.gnu.org/licenses/gpl.html .
A non official french translation can be found here : http://www.linux-France.org/article/these/gpl.html .
The different kinds of licenses governing the products developed by the Apache foundation can be found here : http://www.apache.org/licenses .
It follows that you can as well as use download contents as well modify and redistribute them provided you respect the GPL terms.
Downloading and using such contents do not provide any guaranty.
Be sure that you have well understood the terms of the license before using the contents it covers.
The ESUP-portail distribution includes the following distributions :
    * UPortal :
      software developed by JA-SIG (Java Architecture - Special Interest Group)
      You can find the license page here : http://mis105.udel.edu/ja-sig/uportal/license.html
    * CAS :
      SSO solution developed by Yale University
      You can find the project page here : http://www.yale.edu/tp/auth
    * Cocoon :
      XML framework distributed by the Apache foundation under Apache license;
      Please find the full text here : http://cocoon.apache.org/2.1/license.html
    * Mod_dav:
      A DAV module for Apache web server
      You can find the project page here : http://www.webdav.org/mod_dav
    * IMP :
      webmail from Horde application framework
      You can find the project page here : http://www.horde.org
    * . To be completed
*/

package org.esupportail.portal.channels.CTestMailToMag;

import java.util.Iterator;

import org.esupportail.portal.channels.CMailTo.Mail.MailAttribute;
import org.esupportail.portal.channels.CMailTo.Mail.Mail;
import org.esupportail.portal.channels.CMailTo.MailExceptions.MalFormedMailException;
import org.esupportail.portal.utils.channels.ActionParam;
import org.esupportail.portal.utils.channels.MainChannel;
import org.esupportail.portal.utils.channels.SubChannel;


public class SendAuto  extends SubChannel{

    public SendAuto(MainChannel mainChannel) {
        super(mainChannel);

        Mail myMail = new Mail();
        
        myMail.setFrom(mainChannel.getStaticData().getPerson().getAttribute("mail").toString());
		
	    Iterator i = mainChannel.getCurrentAction().getParams().keySet().iterator();
		/*Rcupration des paramtres sur les actions*/
		while (i.hasNext()){
		    String apName = (String)i.next();
		    
		    String param = null;
		    
		    if (apName.equals("from")){
		        param = Mail.FROM;
		    }else if (apName.equals("to")){
		        param = Mail.TO;
		    }else if (apName.equals("subject")){
		        param = Mail.SUBJECT;
		    }else if (apName.equals("cc")){
		        param = Mail.CC;
		    }else if (apName.equals("bcc")){
		        param = Mail.BCC;
		    }else if (apName.equals("content")){
		        param = Mail.CONTENT;
		    }else if (apName.equals("server")){
		        param = Mail.SERVER;
		    } 
		    
		    
		    ActionParam ap = (ActionParam)mainChannel.getCurrentAction().getParams().get(apName);
		    Iterator j = ap.getValues().iterator();
		    MailAttribute att = new MailAttribute();
		    int count = 0;
		    while (j.hasNext()){
		        String val = (String)j.next();
		        if (count==0)att.setValue(val);
		        else if (count==1)att.setModifiable(val.equals("true"));
		        else if (count==2)att.setVisible(val.equals("true"));
		        count++;
		    }
		    myMail.defineAttribute(param,att);
		} 
		
		try {
		    myMail.send();
		    
        } catch (MalFormedMailException e) {
            //catch of MalFormedMailException 
            e.printStackTrace();
        }
		
        
    }

}
