package org.esupportail.portal.channels.CNabmis;

import org.jasig.portal.IChannel;
import org.jasig.portal.ChannelStaticData;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.ChannelRuntimeProperties;
import org.jasig.portal.PortalEvent;
import org.jasig.portal.PortalException;
import org.jasig.portal.utils.XSLT;
import org.jasig.portal.services.LogService;
import org.xml.sax.ContentHandler;
import java.io.StringWriter;
import org.jasig.portal.security.*;
import org.jasig.portal.security.provider.*;
//import java.lang.reflect.*;
//import java.security.MessageDigest;
//import java.security.NoSuchAlgorithmException;
//import java.util.Random;
import java.util.Calendar;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.jasig.portal.channels.BaseChannel;
import org.jasig.portal.utils.ResourceLoader;
//import org.xml.sax.helpers.XMLFilterImpl;
// Librairies LDAP
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
//import javax.naming.directory.BasicAttribute;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
//import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
// Parsing XML
import org.apache.commons.digester.*;


 /**
  * Description :<br/>
  * Application (channel) de type UPortal
  * permettant la consultation des missions dans NABuCo
  * @version $Id : CNabMis.java, V1.0, 12 juillet 2004<br/>
  * Copyright (c) 2004 Esup Portail (www.esup-portail.org)<br/>
  * Classe(s) : CNabmis<br/>
  * @author Frederic BROSSEL<br/>
  */
public class CNabmis extends BaseChannel  { 
	
  ChannelStaticData staticData = null;

  private static final String sslLocation = "CNabmis.ssl";
  
  // Variables nabuco
  private String _NABUCO_host ;		//Adresse IP ou nom du serveur NABuCo
  private String _NABUCO_port ;		//Port
  private String _NABUCO_instance ;	//Instance
  private String _NABUCO_user ;		//Utilisateur ORACLE ayant les droits de lecture
  private String _NABUCO_pwd ;		//Mot de passe de cet utilisateur
  private String _NABUCO_niveau1 ;	//Niveau 1 de l'etablissement
  
  // Variables acces LDAP
  private String _LDAP_gfocod ;		//Nom de l'attribut de l'annuaire contenant le code Fournisseur/Missionnaire de l'utilisateur
  private String _LDAP_Url;			//URL d'acces
  private String _LDAP_login ;		//Compte ayant acces en lecture a l'attribut ldapGfocod
  private String _LDAP_Password ;	//Mot de passe de cet utilisateur
  private String _LDAP_People ;		//Branche People

  private String g_fo_cod ="";			//Valeur de l'attribut g_fo_cod de l'utilisateur connecte (lue dans le LDAP)
  
  private ParseCNabmisProperties parsCNabmis =new ParseCNabmisProperties() ;
  
  //Contexte d'interrogation de l'annuaire
  private DirContext context;
  
  //Variables pour test : savoir si l'utilisateur est connecte...
  private ISecurityContext ic;
  private boolean bAuthenticated = false ;
  
  //Constructeur
  public CNabmis ()  {   
	 this.staticData = new ChannelStaticData ();
  }

  public void setStaticData (ChannelStaticData sd)  {
	this.staticData = sd;

	//Savoir si l'utilisateur est connecte...
    ic = staticData.getPerson().getSecurityContext();
    if (ic!=null && ic.isAuthenticated()) bAuthenticated = true;
  
    //Initialisation des variables d'accs a la base NABUCO
    _NABUCO_host = parsCNabmis.getNabucoHost() ;
    _NABUCO_port = parsCNabmis.getNabucoPort() ;
    _NABUCO_instance = parsCNabmis.getNabucoInstance() ;
    _NABUCO_user = parsCNabmis.getNabucoUser() ;
    _NABUCO_pwd = parsCNabmis.getNabucoPwd() ;
    _NABUCO_niveau1 = parsCNabmis.getNabucoNiveau1() ;

    //Initialisation des variables d'accs au LDAP
    _LDAP_gfocod = parsCNabmis.getLdapGfocod() ;
    _LDAP_Url = parsCNabmis.getLdapUrl() ;
    _LDAP_login = parsCNabmis.getLdapLogin() ;
    _LDAP_Password = parsCNabmis.getLdapPassword() ;
    _LDAP_People = parsCNabmis.getLdapPeople() ;

    //paramtres de connexion
	Hashtable env = new Hashtable();
	env.put(Context.INITIAL_CONTEXT_FACTORY, "com.sun.jndi.ldap.LdapCtxFactory");
	env.put(Context.PROVIDER_URL, _LDAP_Url);

	//on effectue une authentification simple
	env.put(Context.SECURITY_AUTHENTICATION, "simple");
	env.put(Context.SECURITY_PRINCIPAL, _LDAP_login);
	env.put(Context.SECURITY_CREDENTIALS, _LDAP_Password);

	//on cre le contexte d'accs
	try {
	context = new InitialDirContext(env);
	}
	catch(NamingException e) {
	System.err.println("Erreur dans la cration du contexte: "+e);
	}

	String userid = null;
    if( bAuthenticated ) {
           userid = ic.getPrincipal().getUID();
    } 	

    if (userid.equals("admin")) userid = "testperso" ;	//pour les tests
    
    //Mthode de bind : SearchControls.OBJECT_SCOPE >	je ne recherche que l'objet
	SearchControls constraints = new SearchControls();
	constraints.setSearchScope(SearchControls.OBJECT_SCOPE);

	//le noeud sur lequel je base la recherche: ici sur la personne ( dn )
	String baseDN = "uid="+userid+","+_LDAP_People;

	//le filtre: je recherche ici les objets de tout type
	String filtre="(objectClass=*)";

	//lancement de la recherche
	try {
		NamingEnumeration ne = context.search(baseDN, filtre, constraints);
		//on regarde chaque lment trouve
		while (ne.hasMoreElements()) {
			//un lment retrouve
			SearchResult searchRes = (SearchResult)ne.nextElement();
			//tous les attributs de cet lment
			Attributes atts = searchRes.getAttributes();
			//je recupere l'attribut gfocod
			Attribute att = atts.get(_LDAP_gfocod);
			if (att == null)
				System.out.println("Aucun attribut gfocod trouve");
			else {
				//rcupration de la valeur de l'attribut gfocod
				NamingEnumeration enum = att.getAll();
				while(enum.hasMoreElements()) {
					g_fo_cod = enum.nextElement().toString();
				}
			}
		}
	}
	catch(NamingException e) {
		System.err.println("Erreur dans la recherche: "+e);
	}
  }

/**
 * @param out de type XML
 * @throws PortalException
 */
  public void renderXML (ContentHandler out) throws PortalException  {
	String action =  runtimeData.getParameter("action") ;
	StringWriter w = new StringWriter ();

	//Ecriture entete XML
	w.write ("<?xml version='1.0'?>\n") ;
	w.write ("<content>\n") ;
	w.write ("<baseActionURL>"+runtimeData.getBaseActionURL()+"</baseActionURL>\n") ;

	if((action==null)||(!action.equals("recherche"))){
		//Formulaire de choix de l'exercice de recherche
		w.write ("</content>\n") ;
		XSLT xslt = new XSLT(this);
		xslt.setXML(w.toString());
		xslt.setXSL(sslLocation, "main", runtimeData.getBrowserInfo());
		xslt.setTarget(out);
		xslt.transform();
	}
	else {
		//Rsultat de la recherche
		String requete =  runtimeData.getParameter("recherche") ;
		String annee =  runtimeData.getParameter("annee") ;
		//On effectue la recherche sur l'annee souhaitee (annee=decalage par rapport a annee courante)
		recherche(annee,g_fo_cod,w);
		w.write ("</content>\n") ;
		System.out.println(w);
		XSLT xslt = new XSLT(this);
		xslt.setXML(w.toString());
		xslt.setXSL(sslLocation, "result", runtimeData.getBrowserInfo());
		xslt.setTarget(out);
		xslt.transform();
	}
  }

  /**
   * Description :<br/>
   * Methode de recherche des ordres de mission pour un exercice (une annee) et un missionnaire donnes
   * @param	decal_ex	le decalage d'exercice par rapport a l'exercice courant : 0 (cette annee), 1 (l'annee passee), 2 (l'annee d'avant)
   * @param	gfocod		le code de fournisseur/missionnaire de l'utilisateur connecte
   * @param	w			le StringWriter dans lequel on envoie les resultats en XML
   */
  public void recherche (String decal_ex, String gfocod, StringWriter w) {
	try{
		//On calcule l'exercice de recherche dans nabuco a partir de l'annee systeme et du nombre d'annee de decalage (0, 1 ou 2)
		Calendar aujourdhui = Calendar.getInstance() ;
		int annee_en_chiffres = aujourdhui.get(Calendar.YEAR) - (java.lang.Integer.valueOf(decal_ex)).intValue() ;
		String g_ex_cod = java.lang.String.valueOf(annee_en_chiffres);

		//Deux variables pour calculer les montants rembourses et a venir
		double montant_remb=0 ;			//montant rembourse
		double montant_non_remb=0 ;		//montant a venir

		w.write("<exercice>" + g_ex_cod + "</exercice>\n") ;

		//Connexion JDBC a la base NABUCO
		//Remarque : Pas d'utilisation de pool de connexion, car faible charge
		Connection cnx = null;

		//La base NABUCO est obligatoirement une base ORACLE
		String jdbcDriver="oracle.jdbc.driver.OracleDriver";
		String jdbcUrl="jdbc:oracle:thin:@" + _NABUCO_host + ":" + _NABUCO_port + ":" + _NABUCO_instance ;

		//Instanciation du driver JDBC
		Class.forName(jdbcDriver);
		cnx = DriverManager.getConnection(jdbcUrl,_NABUCO_user,_NABUCO_pwd);

		try{
			//Si le gfocod de l'utilisateur n'est pas renseigne dans l'annuaire, affichage message specifie dans 'Affichage.xsl'
			if (g_fo_cod.equals("")) w.write("<pas_de_gfocod>message</pas_de_gfocod>") ;
			else {
				// Infos gnrales sur le missionnaire : nom, emploi, service
				String sqlString = "select G_FO_NOM, M_MS_EMP_AG, M_MS_SER from ops$maint.m_mis where g_fo_cod=" + g_fo_cod ;
				PreparedStatement statement = cnx.prepareStatement(sqlString);
				ResultSet rs = statement.executeQuery();
				while(rs.next()) {
					w.write("<missionnaire>" + rs.getString(1) + "</missionnaire>\n") ;	//nom du missionnaire
					//w.write("<emploi>" + rs.getString(2) + "</emploi>\n") ; 			//emploi du missionnaire
					//w.write("<service>" + rs.getString(3) + "</service>\n") ; 			//libelle service du missionnaire
				}
				statement.close();

				// Missions en attente de remboursement (Estimations de remboursement)
				sqlString = "select " +
				"s.G_N1_COD, " +
				"s.G_N2_COD, " +
				"s.G_N3_COD, " +
				"nvl(s.E_VC_COD,' ') CodConv, " +
				"s.M_EE_COD_OM, " +
				"upper(ltrim(rtrim(s.M_EE_MTF_DPL))) Motif, " +
				"replace(nvl(sum(elf.M_EL_MT),0.00),',','.')," +
				"to_char(nvl(sum(elf.M_EL_MT),0.00),'999999.00') MontantAffiche ," +
				"to_char(s.M_EE_DAT_DVA,'DD/MM/YY'), " +
				"to_char(s.M_EE_DAT_FVA,'DD/MM/YY') " +
				"from ops$maint.m_est_etf s, ops$maint.m_est_lig elf " +
				"where s.g_fo_cod='" + g_fo_cod + "' " +
				"and s.g_ex_cod='" + g_ex_cod + "' " +
				"and s.g_n1_cod='" + _NABUCO_niveau1 + "' " +
				"and s.M_EE_COD_OM not in (" +
				"	select M_EE_COD_OM from ops$maint.m_eta_fra" +
				"	where g_fo_cod='" + g_fo_cod + "' " +
				"	and g_ex_cod='" + g_ex_cod + "' " +
				"	and s.g_n1_cod='" + _NABUCO_niveau1 + "' " +
				") " +
				"and elf.g_ex_cod=s.g_ex_cod " +
				"and elf.g_n1_cod=s.g_n1_cod " +
				"and elf.g_n2_cod=s.g_n2_cod " +
				"and elf.g_n3_cod=s.g_n3_cod " +
				"and elf.m_ee_cod_om=s.m_ee_cod_om " +
				"group by s.G_N1_COD, s.G_N2_COD, s.G_N3_COD, nvl(s.E_VC_COD,' '), s.M_EE_COD_OM, " +
				"ltrim(rtrim(s.M_EE_MTF_DPL)), decode(s.M_CP_COD,'P','Passager','C','Conducteur'), " +
				"decode(s.M_EE_COD_SFR,'O','Sans Frais','N',' '), to_char(s.M_EE_DAT_DVA,'DD/MM/YY'), to_char(s.M_EE_DAT_FVA,'DD/MM/YY')"
				;
				statement = cnx.prepareStatement(sqlString);
				rs = statement.executeQuery();
				while(rs.next()) {
					w.write("<mission-en-attente>\n") ;
					w.write("<niveau1>" + rs.getString(1) + "</niveau1>\n") ; 			//niveau 1
					w.write("<niveau2>" + rs.getString(2) + "</niveau2>\n") ; 			//niveau 2
					w.write("<niveau3>" + rs.getString(3) + "</niveau3>\n") ; 			//niveau 3
					if (rs.getString(4).equals(" ") == false) {
						w.write("<conv>" + rs.getString(4) + "</conv>\n") ; 			//code convention (eventuellement)
					}
					w.write("<om>" + rs.getString(5) + "</om>\n") ; 					//code OM
					w.write("<motif>" + rs.getString(6) + "</motif>\n") ; 				//Motif
					w.write("<estimation-montant>" + rs.getString(8) + "</estimation-montant>\n") ;	//Estimation Remboursement
					w.write("<dva>" + rs.getString(9) + "</dva>\n") ; 				//Date de debut de validite de l'OM
					w.write("<fva>" + rs.getString(10) + "</fva>\n") ; 				//Date de fin de validite de l'OM
					w.write("</mission-en-attente>\n") ;
					//On cumule le montant...
					montant_non_remb += (java.lang.Double.valueOf(rs.getString(7))).doubleValue();
				}
				statement.close();

				// Recherche des missions rembourses
				sqlString = "select " +
				"e.G_N1_COD, " +
				"e.G_N2_COD, " +
				"e.G_N3_COD, " +
				"nvl(e.E_VC_COD,' '), " +
				"e.M_EE_COD_OM, " +
				"upper(ltrim(rtrim(s.M_EE_MTF_DPL)))," +
				"replace(lpad(f.E_FF_MOT_TTC,7,' '),',','.'), " +
				"to_char(f.E_FF_DAT_LIQ,'DD/MM/YYYY'), " +
				"to_char(f.E_FF_MOT_TTC,'999999.00') MontantAffiche, " +
				"to_char(s.M_EE_DAT_DVA,'DD/MM/YY'), " +
				"to_char(s.M_EE_DAT_FVA,'DD/MM/YY') " +
				"from ops$maint.m_eta_fra e, ops$maint.e_faf f, ops$maint.m_est_etf s " +
				"where e.g_fo_cod='" + g_fo_cod + "' " +
				"and e.g_ex_cod='" + g_ex_cod + "' " +
				"and e.g_n1_cod='" + _NABUCO_niveau1 + "' " +
				"and e.g_ex_cod=f.g_ex_cod " +
				"and e.g_n1_cod=f.g_n1_cod " +
				"and e.g_n2_cod=f.g_n2_cod " +
				"and e.g_n3_cod=f.g_n3_cod " +
				"and e.e_ff_cod=f.e_ff_cod " +
				"and e.g_ex_cod=s.g_ex_cod " +
				"and e.g_n1_cod=s.g_n1_cod " +
				"and e.g_n2_cod=s.g_n2_cod " +
				"and e.g_n3_cod=s.g_n3_cod " +
				"and e.g_fo_cod=s.g_fo_cod " +
				"and e.m_ee_cod_om=s.m_ee_cod_om " +
				"order by f.E_FF_DAT_LIQ";

				statement = cnx.prepareStatement(sqlString);
				rs = statement.executeQuery();
				while(rs.next()) {
					w.write("<mission-remboursee>\n") ;
					w.write("<niveau1>" + rs.getString(1) + "</niveau1>\n") ; 			//niveau 1
					w.write("<niveau2>" + rs.getString(2) + "</niveau2>\n") ; 			//niveau 2
					w.write("<niveau3>" + rs.getString(3) + "</niveau3>\n") ; 			//niveau 3
					if (rs.getString(4).equals(" ") == false) {
						w.write("		<conv>" + rs.getString(4) + "</conv>\n") ; 		//code convention (eventuellement)
					}					
					w.write("<om>" + rs.getString(5) + "</om>\n") ; 					//code OM
					w.write("<motif>" + rs.getString(6) + "</motif>\n") ; 				//Motif
					w.write("<montant-rembourse>" + rs.getString(9) + "</montant-rembourse>\n") ; 	//Montant TTC de la facture
					w.write("<date-liquidation>" + rs.getString(8) + "</date-liquidation>\n") ; 	//Date Liquidation
					w.write("<dva>" + rs.getString(10) + "</dva>\n") ; 				//Date de debut de validite de l'OM
					w.write("<fva>" + rs.getString(11) + "</fva>\n") ; 				//Date de fin de validite de l'OM
					w.write("</mission-remboursee>\n") ;
					//On cumule le montant...
					montant_remb += (java.lang.Double.valueOf(rs.getString(7))).doubleValue();
				}
				statement.close();

				
				//On genere les elements totaux
				w.write("<montant-remb>" + Math.round(montant_remb*100d)/100d + "</montant-remb>\n") ;
				w.write("<montant-en-attente>" + Math.round(montant_non_remb*100d)/100d + "</montant-en-attente>\n") ;
			}
		}
		catch(SQLException e) {
			w.write("Erreur SQL : "+ e.getMessage());
		}
	}
	catch(Exception e){
		LogService.instance().log(LogService.ERROR, e);
 	}
  }
}
