/*
 * Created on 17 juin 2004
 *
 *
 */
package org.esupportail.portal.channels.CNabmis;
 
/**
 * @author F. BROSSEL
 *
 * 
 */
import org.apache.commons.digester.*;

public class ParseCNabmisProperties {

	private CNabmisProperties prop;
	
	/**
	 * on pointe sur le fichier de proprits
	 * 
	 */
	private String _propertyFile="/properties/channels/org_esup/CNabmis/CNabmis.xml";
//	String urlConfigFile = this.getClass().getResource( _configurationFile ).getFile() ;
	String urlConfigFile = this.getClass().getResource( _propertyFile ).getFile() ;

	/**
	 * Parsing du fichier de Properties pour en extraire les infos
	 */
	public ParseCNabmisProperties () {
		
		try {
			/**
			 *  Cration d'un objet Digester
			 */
			Digester objdig = new Digester();
		
			objdig.setValidating(false);
			objdig.addObjectCreate("properties","org.esupportail.portal.channels.CNabmis.CNabmisProperties");
		
			objdig.addBeanPropertySetter("properties/nabucoHost","nabucoHost");
			objdig.addBeanPropertySetter("properties/nabucoPort","nabucoPort");
			objdig.addBeanPropertySetter("properties/nabucoInstance","nabucoInstance");
			objdig.addBeanPropertySetter("properties/nabucoNiveau1","nabucoNiveau1");
			objdig.addBeanPropertySetter("properties/nabucoUser","nabucoUser");
			objdig.addBeanPropertySetter("properties/nabucoPwd","nabucoPwd");
			objdig.addBeanPropertySetter("properties/ldapUrl","ldapUrl");
			objdig.addBeanPropertySetter("properties/ldapGfocod","ldapGfocod");
			objdig.addBeanPropertySetter("properties/ldapLogin","ldapLogin");
			objdig.addBeanPropertySetter("properties/ldapPassword","ldapPassword");
			objdig.addBeanPropertySetter("properties/ldapPeople","ldapPeople");

		 
			//prop = (CNabmisProperties)objdig.parse(_propertyFile);
			prop = (CNabmisProperties)objdig.parse(urlConfigFile);
		}
		catch (Exception e){
			e.printStackTrace();
		}
  
	}
	

	public String getNabucoHost() {
		return prop.getNabucoHost();
	}

	public String getNabucoPort() {
		return prop.getNabucoPort();
	}

	public String getNabucoInstance() {
		return prop.getNabucoInstance();
	}

	public String getNabucoNiveau1() {
		return prop.getNabucoNiveau1();
	}

	public String getNabucoUser() {
		return prop.getNabucoUser();
	}

	public String getNabucoPwd() {
		return prop.getNabucoPwd();
	}

	public String getLdapUrl() {
		return prop.getLdapUrl();
	}

	public String getLdapGfocod() {
		return prop.getLdapGfocod();
	}

	public String getLdapLogin() {
		return prop.getLdapLogin();
	}

	public String getLdapPassword() {
		return prop.getLdapPassword();
	}

	public String getLdapPeople() {
		return prop.getLdapPeople();
	}

}
