<?xml version='1.0'?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<xsl:template match="content">
	<xsl:variable name="baseActionURL"><xsl:value-of select="baseActionURL"/></xsl:variable>
	<xsl:variable name="action">nouvelle</xsl:variable>
	<br/>
	<xsl:if test="missionnaire">
		Missions de <xsl:value-of select="missionnaire"/>
		&#160;pour l'exercice <xsl:value-of select="exercice"/><br/>
		<br/>En attente de remboursement (calcul bas&#233; sur les estimations de frais) : <xsl:value-of select="montant-en-attente"/> &#8364;<br/>
		<TABLE border="1">
		<xsl:for-each select="mission-en-attente">
		<xsl:call-template name="mission-en-attente"/>
		</xsl:for-each>
		</TABLE>
		<br/>Rembours&#233;es ou en cours de remboursement (la date present&#233;e correspond a la liquidation) : <xsl:value-of select="montant-remb"/> &#8364;<br/>
		<TABLE border="1">
		<xsl:for-each select="mission-remboursee">
		<xsl:call-template name="mission-remboursee"/>
		</xsl:for-each>
		</TABLE>
	</xsl:if>
	<xsl:if test="pas_de_gfocod">
		Desole, votre numero de missionnaire n'est pas renseigne dans l'annuaire.
	</xsl:if>
	<form method="post" action="{$baseActionURL}?action={$action}">
		<input type="submit" value="Nouvelle recherche" />
	</form>
</xsl:template>

<xsl:template name="mission-en-attente">
	<TR>
	<TD><font color="#669933" ><xsl:value-of select="motif"/></font></TD>
	<TD align="RIGHT"><xsl:value-of select="estimation-montant"/> &#8364;</TD>
	<TD>OM n°<xsl:value-of select="om"/> du <xsl:value-of select="dva"/> au <xsl:value-of select="fva"/></TD>
	<TD align="CENTER">
		<xsl:value-of select="niveau1"/>
		/ <xsl:value-of select="niveau2"/>
		/ <xsl:value-of select="niveau3"/>
		<xsl:if test="conv"> / <xsl:value-of select="conv"/></xsl:if>
	</TD>
	</TR>
</xsl:template>

<xsl:template name="mission-remboursee">
	<TR>
	<TD><font color="#669933" ><xsl:value-of select="motif"/></font></TD>
	<TD align="RIGHT"><xsl:value-of select="montant-rembourse"/> &#8364; le <xsl:value-of select="date-liquidation"/></TD>
	<TD>OM n°<xsl:value-of select="om"/> du <xsl:value-of select="dva"/> au <xsl:value-of select="fva"/></TD>
	<TD align="CENTER">
		<xsl:value-of select="niveau1"/>
		/ <xsl:value-of select="niveau2"/>
		/ <xsl:value-of select="niveau3"/>
		<xsl:if test="conv"> / <xsl:value-of select="conv"/></xsl:if>
	</TD>
	</TR>
</xsl:template>

</xsl:stylesheet> 
