/**
 * ESUP-Portail Practice - Copyright (c) 2004 ESUP-Portail consortium 
 * 
 * This program is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software Foundation.
 * 
 * See the license terms site for more details: http://www.esup-portail.org/license
 * 
 * @author Alexandre Boisseau <thetyrex at users.sourceforge.net>
 * @author Pascal Aubry  <pascal.aubry at univ-rennes1.fr>
*/

package org.esupportail.portal.channels.CPracticeChannel;

/**
 * Inner Class used to parse the configuration file.
 */
public final class Receiver {

	/**
	 * Constructor.
	 */
	public Receiver() {
		// needed by JDO
	} 
	
	/** 
	 * The name of the attribute. 
	 */
	private String attribute;

	/**
	 * @return the name of the attribute.
	 * 
	 * @uml.property name="attribute"
	 */
	public String getAttribute() {
		return attribute;
	}

	/**
	 * @param attribute the name of the attribute.
	 * 
	 * @uml.property name="attribute"
	 */
	public void setAttribute(final String attribute) {
		this.attribute = attribute;
	}


	/** 
	 * The value the attribute should have for a user to be able to receive.
	 */
	private String value;

	/**
	 * @return the value of the attribute.
	 * 
	 * @uml.property name="value"
	 */
	public String getValue() {
		return value;
	}

	/**
	 * @param value the value of the attribute
	 * 
	 * @uml.property name="value"
	 */
	public void setValue(final String value) {
		this.value = value;

	}

 
}
