package org.esupportail.portal.channels.CPracticeChannel.util.sort;

import java.util.Comparator;

import org.esupportail.portal.channels.CPracticeChannel.CPractice;

/**
 * This class is used to sort pratices by sender, then by date.
 */
public class CPracticeSenderComparer implements Comparator {		
    /**
     * A method to compare objects.
     * @param obj1 the first object (a practice is attended)
     * @param obj2 the second object (a practice is attended)
     * @return An integer
	 * @see org.jasig.portal.IMimeResponse#getHeaders()
     */
    public final int compare(final Object obj1, final Object obj2) {
    	CPractice p1 = (CPractice) obj1;
    	CPractice p2 = (CPractice) obj2;        	
    	int n = p1.getSender().getDisplayName().compareTo(p2.getSender().getDisplayName());
    	if (n != 0) {
    		return n;
    	}
    	return p1.getDate().compareTo(p2.getDate());
    }
}

