<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
	<xsl:output method="html" indent="no" />
	
	<xsl:include href="message.xsl" /> 

	<xsl:param name="baseActionURL">default</xsl:param>

	<xsl:template match="/delete-practice">	
	
		<!-- Display (error) message if set -->
	<xsl:apply-templates select="message"/>

		<h1>Suppression d'un TP (confirmation)</h1>

		<p class="uportal-channel-strong">Confirmez pour supprimer ce TP :</p>
		<li>Envoyé par 
			<a>
				<xsl:attribute name="href">mailto:<xsl:value-of select="practice/sender/esup-user/email"/></xsl:attribute>
				<xsl:value-of select="practice/sender/esup-user/display-name"/>
			</a> à <a>
				<xsl:attribute name="href">mailto:<xsl:value-of select="practice/receiver/esup-user/email"/></xsl:attribute>
				<xsl:value-of select="practice/receiver/esup-user/display-name"/>
			</a> ;
		</li>
		<li>Date : <xsl:value-of select="practice/date" /></li>			
		<li>Description :<pre><xsl:value-of select="practice/description" /></pre></li>
		<li>Fichier(s) joints :
			<ul>
				<xsl:for-each select="practice/files/file">
					<li>
						<xsl:value-of select="filename"/> 
					</li>
				</xsl:for-each>
			</ul>
		</li>
		<form name="deleteForm" action="{$baseActionURL}" method="post">
			<input type="hidden" name="action" value="cancel"/>
			<table width="100%" border="0">
				<tr>
					<td nowrap="true" align="left" valign="bottom">
						<input type="submit" 
							onclick="document.deleteForm.action.value='cancel'" 
							value="&lt; Précédent"
							class="uportal-button"/>			
						<input type="submit" 
							onclick="document.deleteForm.action.value='doIt'" 
							value="Confirmer"
							class="uportal-button"/>
					</td>
					<td nowrap="true" align="right" valign="bottom">
						<input type="submit" 
							onclick="document.deleteForm.action.value='cancel'" 
							value="Annuler"
							class="uportal-button"/>		
					</td>
				</tr>
			</table>	
		</form>
		<!-- Display (error) message if set -->
		<xsl:apply-templates select="message"/>		
		
	</xsl:template>	

</xsl:stylesheet>
