<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
	<xsl:output method="html" indent="no" />
	
	<xsl:include href="message.xsl" /> 

	<xsl:param name="baseActionURL">default</xsl:param>

	<xsl:template match="/display-file">
		
		<form name="displayFile1" action="{$baseActionURL}" method="post">
			<input type="hidden" name="action" value="back"/>
			<input type="submit" 
				onclick="document.displayFile1.action.value='back'" 
				value="Retour"
				class="uportal-button"/>
		</form>
		
		<!-- Display (error) message if set -->
		<xsl:apply-templates select="message"/>
	
		<h1>Visualisation du fichier (<xsl:value-of select="file/filename"/>)</h1>	
		<li>Envoyé par
			<a>
				<xsl:attribute name="href">
					mailto:<xsl:value-of select="practice/sender/esup-user/email"/>
				</xsl:attribute>
				<xsl:value-of select="practice/sender/esup-user/display-name"/> (<xsl:value-of select="practice/sender/esup-user/id"/>)
			</a>
				&#160;à&#160;
			<a>
				<xsl:attribute name="href">
					mailto:<xsl:value-of select="practice/receiver/esup-user/email"/>
				</xsl:attribute>
				<xsl:value-of select="practice/receiver/esup-user/display-name"/> (<xsl:value-of select="practice/receiver/esup-user/id"/>)
			</a>
		</li>
		<li>Date : <xsl:value-of select="practice/date" /></li>
			
		<li>Contenu :<br/>
			<pre>
				<xsl:value-of select="file/content"/>
			</pre>
		</li>	
			
		<form name="displayFile2" action="{$baseActionURL}" method="post">
			<input type="hidden" name="action" value="back"/>
			<input type="submit" 
				onclick="document.displayFile2.action.value='back'" 
				value="Retour"
				class="uportal-button"/>
		</form>
		
		<!-- Display (error) message if set -->
		<xsl:apply-templates select="message"/>

	</xsl:template>	

</xsl:stylesheet>
