<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
	<xsl:output method="html" encoding="UTF-8" indent="no" />
	
	<xsl:include href="message.xsl" /> 

	<xsl:param name="baseActionURL">default</xsl:param>
	<xsl:param name="resourceURL">default</xsl:param>
	<xsl:param name="sortOpt">default</xsl:param>

	<xsl:variable name="mediaPath">media/org/esupportail/portal/channels/CPracticeChannel</xsl:variable>
					
	<xsl:template match="/display-practices">
	
		
		<xsl:apply-templates select="message"/>

		<center>		
		
			<form name="sendForm1" action="{$baseActionURL}" method="post">
				<input type="hidden" name="action" value="refresh"/>
				<input type="submit" 
					onclick="document.sendForm1.action.value='sendPractice'" 
					value="Rendre un nouveau TP"
					class="uportal-button"/>
				&#160;
				<input type="submit" 
					onclick="document.sendForm1.action.value='sort'" 
					class="uportal-button">
					<xsl:attribute name="value"><xsl:value-of select="sort-text"/></xsl:attribute>
				</input>
				&#160;
				<input type="submit" 
					onclick="document.sendForm1.action.value='refresh'" 
					value="Actualiser"
					class="uportal-button"/>
			</form>	
	
			<table align="center" border="0" width="95%">
				<xsl:if test="sent">
					<tr>
						<th nowrap="true" colspan="5">
							<hr  size="3" color="black"/>
						</th>
					</tr>

					<tr>
						<th nowrap="true" colspan="5">
							<h1>TP envoyés 
								<a target="_blank"
									href="{$resourceURL}?action=downloadAll&amp;sent=true">	
									<img width="32" height="32" src="{$mediaPath}/save-zip.gif" border="0" 
										alt="Télécharger tous les fichiers de tous les TPs sous forme d'un fichier zip" 
										align="middle"/>
								</a>
							</h1>
						</th>
					</tr>
				
					<tr>
						<th nowrap="true" align="left">Date</th>
						<th nowrap="true" align="left">Enseignant</th>
						<th nowrap="true" align="left">Description</th>
						<th nowrap="true" align="left">Fichiers joints</th>
						<th nowrap="true" align="left">Actions</th>
					</tr>
					
					<xsl:for-each select="sent/practice">
				
						<xsl:variable name="practice-id"><xsl:value-of select="id"/></xsl:variable>		
						<tr>
							<td nowrap="true">
								<xsl:value-of select="date"/>
							</td>
							<td nowrap="true">
								<a>
									<xsl:attribute name="href">
										mailto:<xsl:value-of select="receiver/esup-user/email"/>
									</xsl:attribute>
									<xsl:value-of select="receiver/esup-user/display-name"/> (<xsl:value-of select="receiver/esup-user/id"/>)
								</a>
							</td>
							<td nowrap="true" class="uportal-text-small">
								<em><xsl:value-of select="description"/></em>
							</td>
							<td nowrap="true" class="uportal-text-small">
								<xsl:apply-templates select="files"/>						
							</td>
							<td nowrap="true">
								<a href="{$baseActionURL}?action=delete&amp;practiceId={$practice-id}">
									<img src="{$mediaPath}/delete.gif" border="0" 
										alt="Détruire le TP" align="middle"/>
								</a>
								&#160;
								<a target="_blank" 
							href="{$resourceURL}?action=downloadPractice&amp;practiceId={$practice-id}">	
									<img src="{$mediaPath}/save-zip.gif" border="0" 
										alt="Télécharger tous les fichiers du TP sous forme d'un fichier zip" 
										align="middle"/>
								</a>
							</td>					
						</tr>	
					</xsl:for-each>		
				</xsl:if>				
				<xsl:if test="received">
					<tr>
						<th nowrap="true" colspan="5">
							<hr  size="3" color="black"/>
						</th>
					</tr>

					<tr>
						<th nowrap="true" colspan="5">
							<h1>TP reçus 
								<a target="_blank"
									href="{$resourceURL}?action=downloadAll&amp;sent=false">	
									<img width="32" height="32" src="{$mediaPath}/save-zip.gif" border="0" 
										alt="T&#130;l&#130;charger tous les fichiers de tous les TPs sous forme d'un fichier zip" 
										align="middle"/>
								</a>
							</h1>
						</th>
					</tr>
			
					<tr>
						<th nowrap="true" align="left">Date</th>
						<th nowrap="true" align="left">Etudiant</th>
						<th nowrap="true" align="left">Description</th>
						<th nowrap="true" align="left">Fichiers joints</th>
						<th nowrap="true" align="left">Actions</th>
					</tr>
					
					<xsl:for-each select="received/practice">
				
						<xsl:variable name="practice-id"><xsl:value-of select="id"/></xsl:variable>		
						<tr>
							<td nowrap="true">
								<xsl:value-of select="date"/>		
							</td>
							<td nowrap="true">
								<a>
									<xsl:attribute name="href">
										mailto:<xsl:value-of select="sender/esup-user/email"/>
									</xsl:attribute>
									<xsl:value-of select="sender/esup-user/display-name"/> (<xsl:value-of select="sender/esup-user/id"/>)
								</a>
							</td>
							<td nowrap="true" class="uportal-text-small">
								<em><xsl:value-of select="description"/></em>
							</td>
							<td nowrap="true" class="uportal-text-small">
								<xsl:apply-templates select="files"/>						
							</td>
							<td nowrap="true">
								<a href="{$baseActionURL}?action=delete&amp;practiceId={$practice-id}">
									<img src="{$mediaPath}/delete.gif" border="0" 
										alt="Supprimer le TP" align="middle"/>
								</a>
								&#160;
								<a target="_blank"
						href="{$resourceURL}?action=downloadPractice&amp;practiceId={$practice-id}">	
									<img src="{$mediaPath}/save-zip.gif" border="0" 
										alt="T&#130;l&#130;charger tous les fichiers du TP sous forme d'un fichier zip" 
										align="middle"/>
								</a>
							</td>		
						</tr>
								
					</xsl:for-each>		
				</xsl:if> 			

				<tr>
					<th nowrap="true" colspan="5">
						<hr  size="3" color="black"/>
					</th>
				</tr>
			</table>	
		
			<form name="sendForm2" action="{$baseActionURL}" method="post">
				<input type="hidden" name="action" value="refresh"/>
				<input type="submit" 
					onclick="document.sendForm2.action.value='sendPractice'" 
					value="Rendre un nouveau TP"
					class="uportal-button"/>
				&#160;
				<input type="submit" 
					onclick="document.sendForm2.action.value='sort'" 
					class="uportal-button">
					<xsl:attribute name="value"><xsl:value-of select="sort-text"/></xsl:attribute>
				</input>
				&#160;
				<input type="submit" 
					onclick="document.sendForm1.action.value='refresh'" 
					value="Actualiser"
					class="uportal-button"/>
			</form>	

		</center>

		<xsl:apply-templates select="message"/>		
		
	</xsl:template>	
		
	<xsl:template match="files">	
		<xsl:for-each select="file">
			<xsl:value-of select="filename"/>
			&#160; 
			<xsl:variable name="fileId"><xsl:value-of select="file-id"/></xsl:variable> 
			<a target="_blank"
				href="{$resourceURL}?action=downloadFile&amp;fileId={$fileId}"> 
				<img src="{$mediaPath}/save.gif" border="0"
					title="Enregistrer le fichier"/> 
			</a>
			&#160;
			<a
				href="{$baseActionURL}?action=displayFile&amp;fileId={$fileId}"> 
				<img src="{$mediaPath}/view.gif" border="0"
					title="Visualiser le fichier"/>  
			</a>
			<br/>
		</xsl:for-each>					
	</xsl:template>

</xsl:stylesheet>
