<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<!-- stylesheet called in ENTER_FILEMSG_MODE -->

	<xsl:output method="html" indent="no" />
	
	<xsl:include href="message.xsl" /> 

	<xsl:param name="baseActionURL">default</xsl:param>
	
	<xsl:template match="/enter-description">
		
		<!-- Display (error) message if set -->
		<xsl:apply-templates select="message"/>

		<h1>Rendu d'un nouveau TP (étape 2/3)</h1>
	
		<li>Destinataire : 
			<a>
				<xsl:attribute name="href">mailto:<xsl:value-of select="receiver/esup-user/email"/></xsl:attribute>
				<xsl:value-of select="receiver/esup-user/display-name"/>	
			</a>
			 (<xsl:value-of select="receiver/esup-user/id"/>)
		</li>
					
		<p class="uportal-channel-strong">Indiquez toutes les informations concernant votre TP.</p>

		<xsl:variable name="previousDescription"><xsl:value-of select="description"/></xsl:variable>
		<form name="enterDesc" action="{$baseActionURL}" enctype="multipart/form-data" method="post">
			<input type="hidden" name="action" value="next"/>
			Donnez une description du TP (formation, binôme, commentaires, ...) :
			<br/><textarea name="description" 
				cols="50" rows="5"
				class="uportal-input-text"><xsl:value-of select="description"/></textarea>
			<br/>     
			
			<p>
				<input type="submit" 
					onclick="document.enterDesc.action.value='back'" 
					value="&lt; Précédent"
					class="uportal-button"/>
				<input type="submit" 
					onclick="document.enterDesc.action.value='next'" 
					value="Suivant &gt;"
					title="Enregistrer le TP."
					class="uportal-button"/>
				<div align="right">
					<input type="submit" 
						onclick="document.enterDesc.action.value='cancel'" 
						value="Annuler"
						class="uportal-button"/>
				</div>
			</p>
		</form>
		
		<!-- Display (error) message if set -->
		<xsl:apply-templates select="message"/>				
				
	</xsl:template>	
</xsl:stylesheet>
