<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

	<xsl:output method="html" indent="no" />
	
	<xsl:include href="message.xsl" /> 

	<xsl:param name="baseActionURL">default</xsl:param>
	<xsl:param name="uploadFileNumber">10</xsl:param>
	
	<xsl:template match="/enter-files">
		
		<!-- Display (error) message if set -->
		<xsl:apply-templates select="message"/>

		<h1>Rendu d'un nouveau TP (étape 3/3)</h1>
	
		<li>Destinataire : 
			<a>
				<xsl:attribute name="href">mailto:<xsl:value-of select="receiver/esup-user/email"/></xsl:attribute>
				<xsl:value-of select="receiver/esup-user/display-name"/>	
			</a>
			 (<xsl:value-of select="receiver/esup-user/id"/>)
		</li>
		<li>Description :<br/><pre> 
			<xsl:value-of select="description"/>
		</pre></li>

		<p class="uportal-channel-strong">Indiquez le(s) fichier(s) à joindre à votre TP.</p>
					
		<form name="sendPractice" action="{$baseActionURL}" enctype="multipart/form-data" method="post">
			<input type="hidden" name="action" value="sendPractice"/>
			<input type="hidden" name="MAX_FILE_SIZE" value="1"/>
			Fichier n°1 (obligatoire) : 
			<input type="file" name="file0"/>
            <xsl:call-template name="addInputFile">
            	<!-- start at one because one input file is already displayed -->
                <xsl:with-param name="i" select="1"/> 
            </xsl:call-template>        
			
			<p>
				<input type="submit" 
					onclick="document.sendPractice.action.value='back'" 
					value="&lt; Précédent"
					class="uportal-button"/>
				<input type="submit" 
					onclick="document.sendPractice.action.value='sendPractice'" 
					value="Terminer"
					title="Enregistrer le TP."
					class="uportal-button"/>
				<div align="right">
					<input type="submit" 
						onclick="document.sendPractice.action.value='cancel'" 
						value="Annuler"
						class="uportal-button"/>
				</div>
			</p>
		</form>
		
		<!-- Display (error) message if set -->
		<xsl:apply-templates select="message"/>				
				
	</xsl:template>	
	
	<!-- recursive template to print file inputs -->
	<xsl:template name="addInputFile">
		<xsl:param name="i"/> <!-- counter -->
		<xsl:if test="not($i >= $uploadFileNumber)"> <!-- stop condition -->
			<br/>Fichier supplémentaire : 
			<input type="file" name="file{$i}"/>
			<xsl:call-template name="addInputFile">
				<xsl:with-param name="i" select="$i + 1"/>
			</xsl:call-template>
		</xsl:if>
	</xsl:template> 

</xsl:stylesheet>
