<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

	<xsl:output method="html" indent="no" />
	
	<xsl:include href="message.xsl" /> 
	
	<xsl:param name="baseActionURL">default</xsl:param>

	<xsl:template match="/enter-teacher">
		
		<xsl:apply-templates select="message"/>	
				
		<h1>Rendu d'un nouveau TP (étape 1/3)</h1>
	
		<p class="uportal-channel-strong">Indiquez le destinataire du TP (son identifiant dans l'annuaire LDAP).</p>
	
		<form name="sendTeacher" action="{$baseActionURL}" method="post">
			<input type="hidden" name="action" value="next"/>
			<xsl:variable name="previousId"><xsl:value-of select="receiver/esup-user/id"/></xsl:variable>
			
			<table cellspacing="2" cellpading="2" border="0">
				<tr>
					<td nowrap="true" align="right">Identifiant LDAP du destinataire :</td>
					<td nowrap="true" align="left"> 
						<input type="text" name="receiverId" value="{$previousId}" class="uportal-input-text"/>
					</td>
				</tr>
			</table>

			<table width="100%" border="0">
				<tr>
					<td nowrap="true" align="left" valign="bottom">
						<input type="submit" 
							onclick="document.sendTeacher.action.value='cancel'" 
							value="&lt; Précédent"
							class="uportal-button"/>
						<input type="submit" 
							onclick="document.sendTeacher.action.value='next'" 
							value="Suivant &gt;"
							class="uportal-button"/>
					</td>
					<td nowrap="true" align="right" valign="bottom">
						<input type="submit" 
							onclick="document.sendTeacher.action.value='cancel'" 
							value="Annuler"
							class="uportal-button"/>		
					</td>
				</tr>
			</table>	
		</form>
		
		<xsl:apply-templates select="message"/>	
							
	</xsl:template>	

</xsl:stylesheet>
