/*
 * Decompiled with CFR 0.152.
 */
package com.google.soap.search;

import com.google.soap.search.GoogleSearchFault;
import com.google.soap.search.GoogleSearchResult;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import org.apache.soap.Fault;
import org.apache.soap.SOAPException;
import org.apache.soap.encoding.SOAPMappingRegistry;
import org.apache.soap.encoding.soapenc.BeanSerializer;
import org.apache.soap.rpc.Call;
import org.apache.soap.rpc.Parameter;
import org.apache.soap.rpc.Response;
import org.apache.soap.util.xml.QName;

public class GoogleSearch {
    private static final String defaultEndpointURL = "http://api.google.com/search/beta2";
    private String key = null;
    private String soapServiceURL = "";
    private String q = null;
    private Integer start = new Integer(0);
    private Integer maxResults = new Integer(10);
    private Boolean filter = new Boolean(true);
    private String restrict = "";
    private Boolean safeSearch = new Boolean(false);
    private String lr = "";
    private String ie = "latin1";
    private String oe = "latin1";
    private static /* synthetic */ Class class$Ljava$lang$String;
    private static /* synthetic */ Class class$Ljava$lang$Integer;
    private static /* synthetic */ Class class$Ljava$lang$Boolean;
    private static /* synthetic */ Class class$Lcom$google$soap$search$GoogleSearchResult;
    private static /* synthetic */ Class class$Lcom$google$soap$search$GoogleSearchDirectoryCategory;
    private static /* synthetic */ Class class$Lcom$google$soap$search$GoogleSearchResultElement;

    public void setKey(String string) {
        this.key = string;
    }

    public void setSoapServiceURL(String string) {
        this.soapServiceURL = string;
    }

    public void setQueryString(String string) {
        this.q = string;
    }

    public void setStartResult(int n) {
        this.start = new Integer(n);
    }

    public void setMaxResults(int n) {
        this.maxResults = new Integer(n);
    }

    public void setFilter(boolean bl) {
        this.filter = new Boolean(bl);
    }

    public void setRestrict(String string) {
        this.restrict = string;
    }

    public void setSafeSearch(boolean bl) {
        this.safeSearch = new Boolean(bl);
    }

    public void setLanguageRestricts(String string) {
        this.lr = new String(string);
    }

    public void setInputEncoding(String string) {
        this.ie = string;
    }

    public void setOutputEncoding(String string) {
        this.oe = string;
    }

    public GoogleSearchResult doSearch() throws GoogleSearchFault {
        Response response = null;
        try {
            response = this.callRemoteMethodUsingSOAP("doGoogleSearch", this.generateParamsVector());
        }
        catch (Exception exception) {
            throw new GoogleSearchFault(exception.toString());
        }
        if (!response.generatedFault()) {
            Parameter parameter = response.getReturnValue();
            return (GoogleSearchResult)parameter.getValue();
        }
        Fault fault = response.getFault();
        throw new GoogleSearchFault("Fault Code = " + fault.getFaultCode() + "\nFault String = " + fault.getFaultString());
    }

    public byte[] doGetCachedPage(String string) throws GoogleSearchFault {
        Object object;
        Response response = null;
        try {
            object = new Vector<Parameter>();
            ((Vector)object).addElement(new Parameter("key", class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = GoogleSearch.class$("java.lang.String")), this.key, null));
            ((Vector)object).addElement(new Parameter("url", class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = GoogleSearch.class$("java.lang.String")), string, null));
            response = this.callRemoteMethodUsingSOAP("doGetCachedPage", (Vector)object);
        }
        catch (Exception exception) {
            throw new GoogleSearchFault(exception.toString());
        }
        if (!response.generatedFault()) {
            object = response.getReturnValue();
            return (byte[])((Parameter)object).getValue();
        }
        object = response.getFault();
        throw new GoogleSearchFault("Fault Code = " + ((Fault)object).getFaultCode() + "\nFault String = " + ((Fault)object).getFaultString());
    }

    public String doSpellingSuggestion(String string) throws GoogleSearchFault {
        Object object;
        Response response = null;
        try {
            object = new Vector<Parameter>();
            ((Vector)object).addElement(new Parameter("key", class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = GoogleSearch.class$("java.lang.String")), this.key, null));
            ((Vector)object).addElement(new Parameter("phrase", class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = GoogleSearch.class$("java.lang.String")), string, null));
            response = this.callRemoteMethodUsingSOAP("doSpellingSuggestion", (Vector)object);
        }
        catch (Exception exception) {
            throw new GoogleSearchFault(exception.toString());
        }
        if (!response.generatedFault()) {
            object = response.getReturnValue();
            return (String)((Parameter)object).getValue();
        }
        object = response.getFault();
        throw new GoogleSearchFault("Fault Code = " + ((Fault)object).getFaultCode() + "\nFault String = " + ((Fault)object).getFaultString());
    }

    private Vector generateParamsVector() {
        Vector<Parameter> vector = new Vector<Parameter>();
        vector.addElement(new Parameter("key", class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = GoogleSearch.class$("java.lang.String")), this.key, null));
        vector.addElement(new Parameter("q", class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = GoogleSearch.class$("java.lang.String")), this.q, null));
        vector.addElement(new Parameter("start", class$Ljava$lang$Integer != null ? class$Ljava$lang$Integer : (class$Ljava$lang$Integer = GoogleSearch.class$("java.lang.Integer")), this.start, null));
        vector.addElement(new Parameter("maxResults", class$Ljava$lang$Integer != null ? class$Ljava$lang$Integer : (class$Ljava$lang$Integer = GoogleSearch.class$("java.lang.Integer")), this.maxResults, null));
        vector.addElement(new Parameter("filter", class$Ljava$lang$Boolean != null ? class$Ljava$lang$Boolean : (class$Ljava$lang$Boolean = GoogleSearch.class$("java.lang.Boolean")), this.filter, null));
        vector.addElement(new Parameter("restrict", class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = GoogleSearch.class$("java.lang.String")), this.restrict, null));
        vector.addElement(new Parameter("safeSearch", class$Ljava$lang$Boolean != null ? class$Ljava$lang$Boolean : (class$Ljava$lang$Boolean = GoogleSearch.class$("java.lang.Boolean")), this.safeSearch, null));
        vector.addElement(new Parameter("lr", class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = GoogleSearch.class$("java.lang.String")), this.lr, null));
        vector.addElement(new Parameter("ie", class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = GoogleSearch.class$("java.lang.String")), this.ie, null));
        vector.addElement(new Parameter("oe", class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = GoogleSearch.class$("java.lang.String")), this.oe, null));
        return vector;
    }

    private SOAPMappingRegistry constructTypeRegistryForGoogleSearch() {
        SOAPMappingRegistry sOAPMappingRegistry = new SOAPMappingRegistry();
        BeanSerializer beanSerializer = new BeanSerializer();
        sOAPMappingRegistry.mapTypes("http://schemas.xmlsoap.org/soap/encoding/", new QName("urn:GoogleSearch", "GoogleSearchResult"), class$Lcom$google$soap$search$GoogleSearchResult != null ? class$Lcom$google$soap$search$GoogleSearchResult : (class$Lcom$google$soap$search$GoogleSearchResult = GoogleSearch.class$("com.google.soap.search.GoogleSearchResult")), beanSerializer, beanSerializer);
        sOAPMappingRegistry.mapTypes("http://schemas.xmlsoap.org/soap/encoding/", new QName("urn:GoogleSearch", "DirectoryCategory"), class$Lcom$google$soap$search$GoogleSearchDirectoryCategory != null ? class$Lcom$google$soap$search$GoogleSearchDirectoryCategory : (class$Lcom$google$soap$search$GoogleSearchDirectoryCategory = GoogleSearch.class$("com.google.soap.search.GoogleSearchDirectoryCategory")), beanSerializer, beanSerializer);
        sOAPMappingRegistry.mapTypes("http://schemas.xmlsoap.org/soap/encoding/", new QName("urn:GoogleSearch", "ResultElement"), class$Lcom$google$soap$search$GoogleSearchResultElement != null ? class$Lcom$google$soap$search$GoogleSearchResultElement : (class$Lcom$google$soap$search$GoogleSearchResultElement = GoogleSearch.class$("com.google.soap.search.GoogleSearchResultElement")), beanSerializer, beanSerializer);
        return sOAPMappingRegistry;
    }

    private Response callRemoteMethodUsingSOAP(String string, Vector vector) throws MalformedURLException, SOAPException {
        URL uRL = new URL(this.soapServiceURL);
        Call call = new Call();
        call.setSOAPMappingRegistry(this.constructTypeRegistryForGoogleSearch());
        call.setTargetObjectURI("urn:GoogleSearch");
        call.setMethodName(string);
        call.setEncodingStyleURI("http://schemas.xmlsoap.org/soap/encoding/");
        call.setParams(vector);
        return call.invoke(uRL, "urn:GoogleSearchAction");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public GoogleSearch() {
        if (System.getProperty("google.soapEndpointURL") != null) {
            this.setSoapServiceURL(System.getProperty("google.soapEndpointURL"));
        } else {
            this.setSoapServiceURL(defaultEndpointURL);
        }
    }
}

