/**
 * Copyright  2004 ESUP-portail consortium
 * Authors : Doriane.Dusart@univ-valenciennes.fr
 * This program is free software; you can redistribute 
 * it and/or modify it under the terms of the GNU 
 * General Public License as published by the Free 
 * Software Foundation augmented according to the
 * possibility of using it with programs developped under 
 * the Apache licence published by the Apache Software Foundation.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 *  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 *  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY 
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, 
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE 
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 * See the license terms site for more details : 
 * http://www.esup-portail.org/license.html
 */

package org.esupportail.portal.channels.CRecherche;

import org.jasig.portal.IChannel;
import org.jasig.portal.ChannelStaticData;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.ChannelRuntimeProperties;
import org.jasig.portal.PortalEvent;
import org.jasig.portal.PortalException;
import org.jasig.portal.utils.XSLT;
import org.jasig.portal.services.LogService;
import org.xml.sax.ContentHandler;
import java.io.StringWriter;
import org.jasig.portal.security.*;
import org.jasig.portal.security.provider.*;
import java.lang.reflect.*;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;
import java.util.Date;

import org.jasig.portal.channels.BaseChannel;
import com.google.soap.search.*;

import org.jasig.portal.utils.ResourceLoader;


import org.xml.sax.helpers.XMLFilterImpl;


 /**
  * 
  * Description :<br/>
  * Application de recherche de type UPortal bas sur le webservices google
  * @version $Id : CRecherche.java, V1.0, 16 juillet 2003<br/>
  * Copyright (c) 2004 Esup Portail (www.esup-portail.org)<br/>
  * Classe(s) : CRecherche<br/>
  * @author Doriane Dusart<br/>
  */

public class CRecherche extends BaseChannel  {
  ChannelStaticData staticData = null;

  private static final String sslLocation = "CRecherche.ssl";
  private String _univurl = null;
  private String _key = null;
  private String _image = null;
  //"http://www.google.com/logos/Logo_40wht.gif";
  private String _nom = "l'universit";
  
  public CRecherche ()  {   
	 this.staticData = new ChannelStaticData ();

  }


  
  public void setStaticData (ChannelStaticData sd)  {
	this.staticData = sd;
	_univurl = sd.getParameter( "univurl" );
	_key = sd.getParameter( "key");
	if(sd.getParameter( "nomuniv")!=null)	_nom = sd.getParameter( "nomuniv");
	if(sd.getParameter( "image")!=null)	_image = sd.getParameter( "image");
}


/**
 * DTD :
  * Voir les fichiers de dtd
 * @param out de type XML
 * @throws PortalException
 */
  
  public void renderXML (ContentHandler out) throws PortalException  {
	String action =  runtimeData.getParameter("action");
	StringWriter w = new StringWriter ();
	/*try{
		image = ResourceLoader.getResourceAsURLString(this.getClass(),image);
	}
	catch(Exception e){System.out.println("erreur "+e);}
	*/
	w.write ("<?xml version='1.0'?>\n");
	w.write ("<content>\n");
	w.write ("<baseActionURL>"+runtimeData.getBaseActionURL()+"</baseActionURL>\n");
	if (_image!=null)w.write ("<image>"+_image+"</image>");
	if((action==null)||(!action.equals("recherche"))){	
		w.write ("<nom>"+_nom+"</nom>");	
		w.write ("</content>");
		XSLT xslt = new XSLT(this);
		xslt.setXML(w.toString());
		xslt.setXSL(sslLocation, "main", runtimeData.getBrowserInfo());
		xslt.setTarget(out);
		//xslt.setStylesheetParameter("baseActionURL", runtimeData.getBaseActionURL());
		xslt.transform();
	}
	else {
		String requete =  runtimeData.getParameter("recherche");
		String type =  runtimeData.getParameter("type");
				if(type.equals("externe")) recherche(requete,"",w);
				else recherche(requete,_univurl,w);
			w.write ("</content>");
		System.out.println(w);
			XSLT xslt = new XSLT(this);
			xslt.setXML(w.toString());
			xslt.setXSL(sslLocation, "result", runtimeData.getBrowserInfo());
			xslt.setTarget(out);
			//xslt.setStylesheetParameter("baseActionURL", runtimeData.getBaseActionURL());
			xslt.transform();
	}
	}


public void recherche (String recherche, String site, StringWriter w){
	try
	  {
		GoogleSearch s = new GoogleSearch();
		s.setKey(_key);
		s.setStartResult(0);
		s.setMaxResults(10);
		if (!site.equals(""))	{
			s.setQueryString(recherche+" site:"+site);
			w.write("<site>"+HTML2XHTML(site)+"</site>");
		} 
		else s.setQueryString(recherche);
		GoogleSearchResult r = s.doSearch();
		w.write( "<question>"+ HTML2XHTML(r.getSearchQuery()) + "</question>\n");
		w.write( "<temps>"+r.getSearchTime() + "</temps>\n");

		GoogleSearchResultElement[] elements = r.getResultElements();
		if(r.getStartIndex() > 0){
			for(int i = r.getStartIndex()-1; i < r.getEndIndex(); i++){
				w.write("<resultat>\n");
				GoogleSearchResultElement result = elements[i];
				w.write("<url>"+ HTML2XHTML(result.getURL()) +"</url>\n");
				w.write("<titre>"+HTML2XHTML(result.getTitle()) +"</titre>\n");
				w.write("<snippet>"+HTML2XHTML(result.getSnippet())+"</snippet>\n");
				if (result.getDirectoryTitle() != null && result.getDirectoryTitle().length()>1 ) {
						w.write("<repertoire>"+HTML2XHTML(result.getDirectoryTitle())+"</repertoire>\n");
				}
				GoogleSearchDirectoryCategory cats;
				if ( ( cats=result.getDirectoryCategory() ) != null && cats.getFullViewableName().length()>1 ){
					w.write("<categorie>"+HTML2XHTML(cats.getFullViewableName())+"</categorie>\n");
				}
				if (result.getSummary() != null &&  !result.getSummary().equals("") && result.getSummary().length()>1 ){ 
					w.write("<resume> "+HTML2XHTML(result.getSummary())+"</resume>\n");
				}
				w.write("</resultat>\n");
			}
		}
		else{
			w.write("<resultat>Pas de resultat</resultat>"); 
		}
	  }
	 catch(Exception e){
		LogService.instance().log(LogService.ERROR, e);
	 }
		
		
		
}

private String HTML2XHTML(String s){
	String temp;
	temp = s.replaceAll("<br>","<br/>");
	temp = temp.replaceAll("&","&#38;");
	return temp;
}

}
