<?xml version='1.0'?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<xsl:template match="content">
	<xsl:variable name="baseActionURL"><xsl:value-of select="baseActionURL"/></xsl:variable>
	<xsl:variable name="action">nouvelle</xsl:variable>
	<img><xsl:attribute name="src"><xsl:value-of select="image"/></xsl:attribute><xsl:attribute name="alt">logo google</xsl:attribute></img>	
	<br/>
	<xsl:if test='resultat="Pas de resultat"'>
		Google n'a pas de r&#233;sultat pour cette requ&#234;te 
		<xsl:if test='site'>
		&#160;sur le site <xsl:value-of select="site"/>.
		</xsl:if>
	</xsl:if>
	<xsl:if test="question">
		La recherche <xsl:value-of select="question"/> a &#233;t&#233; effectu&#233;e par Google en <xsl:value-of select="temps"/>secondes<br/><br/>
		<xsl:for-each select="resultat">
		<xsl:call-template name="resultat"/>
		</xsl:for-each>
	<form method="post" action="{$baseActionURL}?action={$action}">
		<input type="submit" value="Nouvelle recherche" />
	</form>
	</xsl:if>
</xsl:template>

<xsl:template name="resultat">
<a><xsl:attribute name="href"><xsl:value-of select="url"/></xsl:attribute><xsl:attribute name="target">_blank</xsl:attribute><b><xsl:value-of select="titre"/></b></a>
<br/>
	<i>  <xsl:copy-of select="snippet"/></i><br/>
	<font color="#996633" ><xsl:value-of select="url"/></font> <br/>
	<xsl:if test="repertoire">
		R&#233;pertoire : <xsl:value-of select="repertoire"/><br/>
	</xsl:if>
	<xsl:if test="categorie">
	Cat&#233;gorie : 
 <a><xsl:attribute name="href">http://directory.google.com<xsl:value-of select="categorie"/></xsl:attribute><xsl:attribute name="target">_blank</xsl:attribute><xsl:value-of select="categorie"/></a>
 <br/>
	</xsl:if>
	<xsl:if test="resume">
		R&#233;sum&#233; : <xsl:value-of select="resume"/><br/>
	</xsl:if>
	<br/>
</xsl:template>



</xsl:stylesheet> 



