/*
ESUP-portail is a french academic project developed under the GPL (General Public License) augmented according to the following :
A binary or source file developped by ESUP-portail can be used or compiled with products under Apache license.
The official english text of the GPL can be found here : http://www.gnu.org/licenses/gpl.html .
A non official french translation can be found here : http://www.linux-France.org/article/these/gpl.html .
The different kinds of licenses governing the products developed by the Apache foundation can be found here : http://www.apache.org/licenses .
It follows that you can as well as use download contents as well modify and redistribute them provided you respect the GPL terms.
Downloading and using such contents do not provide any guaranty.
Be sure that you have well understood the terms of the license before using the contents it covers.
The ESUP-portail distribution includes the following distributions :
    * UPortal : 
      software developed by JA-SIG (Java Architecture - Special Interest Group)
      You can find the license page here : http://mis105.udel.edu/ja-sig/uportal/license.html
    * CAS :
      SSO solution developed by Yale University
      You can find the project page here : http://www.yale.edu/tp/auth
    * Cocoon :
      XML framework distributed by the Apache foundation under Apache license;
      Please find the full text here : http://cocoon.apache.org/2.1/license.html
    * Mod_dav:
      A DAV module for Apache web server
      You can find the project page here : http://www.webdav.org/mod_dav
    * IMP :
      webmail from Horde application framework
      You can find the project page here : http://www.horde.org
    * . To be completed
*/
package org.esupportail.portal.channels.CSMS.serverSending;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Vector;

import org.esupportail.portal.channels.CSMS.Etudiant;
import org.esupportail.portal.channels.CSMS.exception.ExceptionConfigurationCanal;
import org.esupportail.portal.channels.CSMS.exception.ExceptionConfirmationEnvoiSms;
import org.esupportail.portal.channels.CSMS.exception.ExceptionParametresEnvoiSms;
import org.esupportail.portal.channels.CSMS.exception.ExceptionServeurSmsIndisponible;
import org.esupportail.portal.channels.CSMS.properties.ParseProprietesCanal;
import org.esupportail.portal.channels.CSMS.smsServerResponse.ParseReponseServeurSms;
import org.jasig.portal.services.LogService;

/**
 * Id: EnvoieSms.java,v 1.0 1 dc. 2004
 * Copyright (c) 2004 Esup Portail (www.esup-portail.org)
 * Classes: EnvoieSms
 * Original Author: Yohan Colmant
 * 
 */
public class EnvoieSms {

	

	/**
	 * Sujet du message
	 */
	private String sujet;
	
	/**
	 * Corps du message
	 */
	private String message;

	
	
	
	/**
	 * Url du serveur pour SMS
	 */
	private String smsServeur;
	
	/**
	 * Login pour serveur SMS
	 */
	private String smsLogin;
	
	/**
	 * Password pour serveur SMS
	 */
	private String smsPassword;
	
	
	
	/**
	 * Le login de l'expediteur
	 */
	private String loginExpediteur;
	
	/**
	 * Le nom de l'expediteur
	 */
	private String nomExpediteur;
	
	
	
	/**
	 * L'id du message envoye
	 */
	private String id;
	
	/**
	 * La date d'envoi du message
	 */
	private String date;
	
	
	
	/**
	 * Constructeur
	 * @param sujet sujet du message
	 * @param message corps du message
	 * @param smsServeur le serveur d'envoi
	 * @param smsLogin le login pour acces au serveur
	 * @param smsPassword le mot de passe du serveur
	 * @param loginExpediteur le login de l'expediteur
	 * @param nomExpediteur le nom de l'expediteur
	 */
	public EnvoieSms(String sujet, String message, String smsServeur, String smsLogin, String smsPassword, String loginExpediteur, String nomExpediteur) {
		this.sujet = sujet;
		this.message = message;
		this.smsServeur = smsServeur;
		this.smsLogin = smsLogin;
		this.smsPassword = smsPassword;
		this.loginExpediteur = loginExpediteur;
		this.nomExpediteur = nomExpediteur;
		
	}
	
	
	/**
	 * Retourne l'id du message envoye
	 * @return l'id du message envoye
	 */
	public String getID() {
		return this.id;
	}
	
	/**
	 * Retourne la date d'envoi
	 * @return la date d'envoi
	 */
	public String getDateEnvoi() {
		return this.date;
	}
	
	

	/**
	 * Pour generer un destinataire dans le fichier XML de profil
	 * @param name nom du destinataire
	 * @param id id du destinataire
	 * @param phone telephone du destinataire
	 * @return une string au format xml
	 */
	private String createProfileDest(String name, String id, String phone) {
		String xml = "";
		
		if ( phone!=null ) {
			xml += "<PROFILE>";
			xml += "<DEST_NAME>" + name + "</DEST_NAME>\n";
			xml += "<DEST_FORENAME>" + name + "</DEST_FORENAME>\n";
			xml += "<DEST_ID>" + id + "</DEST_ID>\n";
			xml += "<TERMINAL_GROUP>\n";
			
			xml += "<TERMINAL>\n";
			xml += "<TERMINAL_NAME>personal_mobile</TERMINAL_NAME>\n";
			xml += "<TERMINAL_ADDR>" + phone + "</TERMINAL_ADDR>\n";
			xml += "<MEDIA_TYPE_GROUP>\n";
			xml += "<MEDIA_TYPE>sms</MEDIA_TYPE>\n";
			xml += "</MEDIA_TYPE_GROUP>\n";
			xml += "</TERMINAL>\n";
		
			xml += "</TERMINAL_GROUP>\n";
			xml += "</PROFILE>";
		}
		
		return xml;
	}
	
	
	/**
	 * Pour generer le fichier de profil a envoyer au serveur de multidiffusion
	 * @param destinataires un vecteur de destinataires de type Student
	 * @return l'ensemble des fichiers  envoyer
	 */
	private Vector[] createSmsProfileFile(Vector destinataires) {
		
		Vector nomFichiers = new Vector();
		Vector profilEnvois = new Vector();
		
		int nbDestMax = 5;
		int nbDest = destinataires.size();
		
		// on compte le nombre de fichiers a generer et a envoyer		
		int nbFichiers = nbDest/nbDestMax;
		if ((nbDest%nbDestMax)>0) 
			nbFichiers += 1;
		
		// le nom de ce fichier
		String nomFichier = loginExpediteur+System.currentTimeMillis();
		
		// on parcourt tous les fichiers
		for (int i=0; i<nbFichiers; i++) {			
			
			nomFichiers.addElement(nomFichier+"_"+i);
			
			// on genere le XML
			String xml = "";
			
			xml += "<?xml version=\"1.0\" ?>\n" + "\n";				
			xml += "<PROFILE_LIST Name=\"" + nomFichier + "\">\n";
			
			// on parcourt tous les destinataires
			for (int j=i*nbDestMax; j<(i+1)*nbDestMax && j<nbDest; j++) {		
				Etudiant etudiant = (Etudiant)destinataires.elementAt(j);
				xml += this.createProfileDest(etudiant.getName(), j+"", etudiant.getPhone());
			}			
			
			xml += "</PROFILE_LIST>";
			
			// le profil
			profilEnvois.addElement(xml);						
		}
		
		Vector[] result = new Vector[2];
		result[0] = nomFichiers;
		result[1] = profilEnvois;
		return result;
		
	}
	
	
	
	/**
	 * Envoie le SMS et passe en mode resultat
	 * @param destinataires les destinataires du message
	 * @return le nombre de messages envoyes
	 * @throws ExceptionServeurSmsIndisponible
	 * @throws ExceptionConfirmationEnvoiSms
	 * @throws ExceptionParametresEnvoiSms
	 * @throws ExceptionConfigurationCanal
	 */
	public int sendMessage(Vector destinataires) throws ExceptionServeurSmsIndisponible, ExceptionConfirmationEnvoiSms, ExceptionParametresEnvoiSms, ExceptionConfigurationCanal {	
		
		// je genere les fichiers profil
		Vector[] profFile = createSmsProfileFile(destinataires);
		
		Vector nomFichiers = profFile[0];
		Vector profilEnvois = profFile[1];
		
		// nombre d'etudiants concernes
		int nombreSms = 0;
		for (int i=0; i<destinataires.size(); i++) {
			Etudiant s = (Etudiant)destinataires.elementAt(i);
			if (s.getPhone()!=null)
				nombreSms++;
		}
		
		LogService.log(LogService.DEBUG, "EnvoieSms::sendMessage: Nouveau message: profil de destinaire cree");
		
		// pour chaque fichier a envoyer
		for (int indexFichiers=0; indexFichiers<nomFichiers.size(); indexFichiers++) {

			// le nom du fichier a traiter
			String nomFichier = (String)nomFichiers.elementAt(indexFichiers);
			String nomFichierXml = nomFichier+".xml";
			
			// le profil a traiter
			String profil = (String)profilEnvois.elementAt(indexFichiers);
			
			PostURLConnection post = null;
			
			// 	je poste sur le serveur
			try {        	
				//System.out.println("\n--> "+this.nomExpediteur+" envoie le message");
				//System.out.println("    sujet: "+this.sujet);
				//System.out.println("    message: "+this.message);
				//System.out.println("    serveur: "+this.serveur);
				//System.out.println("    fichier: "+nomFichierXml);	
				LogService.log(LogService.DEBUG, "EnvoieSms::sendMessage: Nouveau message");
				
								
				this.message = ParseProprietesCanal.getInstance().getSmsFrom()+" "+this.nomExpediteur+": "+this.sujet+". "+this.message;
				
				post = new PostURLConnection(this.smsServeur);	        
				post.writeParam("COMMANDE", "DIFFUSER");
				post.writeParam("LOGIN", this.smsLogin);
				post.writeParam("PASSWORD", this.smsPassword);
				post.writeParam("FROM", this.nomExpediteur);
				LogService.log(LogService.DEBUG, "EnvoieSms::sendMessage: Poste l'expediteur du message:"+this.nomExpediteur);
				post.writeParam("SUBJECT", this.sujet);
				LogService.log(LogService.DEBUG, "EnvoieSms::sendMessage: Poste le sujet du message");
				post.writeParam("CONTENT", this.message);
				LogService.log(LogService.DEBUG, "EnvoieSms::sendMessage: Poste le contenu du message");
				post.writeFileContent("PROFILE_FILE", profil, nomFichierXml);
				LogService.log(LogService.DEBUG, "EnvoieSms::sendMessage: Poste le profil XML");
				post.close();        
			}
			catch(IOException e) {
				//e.printStackTrace();
				LogService.log(LogService.ERROR, "EnvoieSms::sendMessage: "+e);
				
				// on propage une nouvelle exception
				throw new ExceptionServeurSmsIndisponible();
			}    
			LogService.log(LogService.INFO, "EnvoieSms::sendMessage: Message bien envoy");
        
			try {
				// le retour du serveur				
				BufferedReader inStream = new BufferedReader(new InputStreamReader(post.getInputStream()));
				
				//LogService.log(LogService.DEBUG, "GereMessage::sendMessage: La reponse est ecrite dans le fichier "+fichierReponse);	        	
	        	
	        	String reponse = "";
	        	String str = "";                       				       	
				while (( str = inStream.readLine()) != null) {				
					if (!str.trim().equals("")) {						
						reponse+=str;
						LogService.log(LogService.DEBUG, "EnvoieSms::sendMessage: Reponse du serveur: "+str);
					}
				}
				inStream.close();				
				//System.out.println("Reponse du serveur:"+reponse);
				StringReader sr = new StringReader(reponse);
				
				// on parse le retour maintenant
				ParseReponseServeurSms resp = new ParseReponseServeurSms(sr);
				
				//System.out.println("Server response is: ");
				LogService.log(LogService.DEBUG, "EnvoieSms::sendMessage: Reponse du serveur");
				id = resp.getMsgId();
				
			 	// si on a une ou plusieurs erreurs
				if (id == null) {
					
					ArrayList erreurs = resp.getErrors();
					
					for (int i=0; i<erreurs.size(); i++)
	            		//System.out.println("Erreur:\n"+erreurs.get(i));
						LogService.log(LogService.DEBUG, "EnvoieSms::sendMessage: Erreur= "+erreurs.get(i));
					
					// on propage une nouvelle exception
					throw new ExceptionParametresEnvoiSms();
				}
				else {
					date = resp.getMsgDate();
					
					LogService.log(LogService.DEBUG, "EnvoieSms::sendMessage: ID= "+id);
					LogService.log(LogService.DEBUG, "EnvoieSms::sendMessage: Date= "+date);					
				}
				
							
			}
			catch(IOException e) {
				LogService.log(LogService.ERROR, "EnvoieSms::sendMessage: "+e);
				throw new ExceptionConfirmationEnvoiSms();
				
			}
			catch(ExceptionParametresEnvoiSms e) { 
				LogService.log(LogService.ERROR, "EnvoieSms::sendMessage: "+e);
				throw e;
				
			}
			/*finally {
				System.out.println("passe dans le finally");//TODO 
				this.id = null;
				this.date = null;
			}*/
		}
		
		return nombreSms;
	}
	
	
	
}
