/*
ESUP-portail is a french academic project developed under the GPL (General Public License) augmented according to the following :
A binary or source file developped by ESUP-portail can be used or compiled with products under Apache license.
The official english text of the GPL can be found here : http://www.gnu.org/licenses/gpl.html .
A non official french translation can be found here : http://www.linux-France.org/article/these/gpl.html .
The different kinds of licenses governing the products developed by the Apache foundation can be found here : http://www.apache.org/licenses .
It follows that you can as well as use download contents as well modify and redistribute them provided you respect the GPL terms.
Downloading and using such contents do not provide any guaranty.
Be sure that you have well understood the terms of the license before using the contents it covers.
The ESUP-portail distribution includes the following distributions :
    * UPortal : 
      software developed by JA-SIG (Java Architecture - Special Interest Group)
      You can find the license page here : http://mis105.udel.edu/ja-sig/uportal/license.html
    * CAS :
      SSO solution developed by Yale University
      You can find the project page here : http://www.yale.edu/tp/auth
    * Cocoon :
      XML framework distributed by the Apache foundation under Apache license;
      Please find the full text here : http://cocoon.apache.org/2.1/license.html
    * Mod_dav:
      A DAV module for Apache web server
      You can find the project page here : http://www.webdav.org/mod_dav
    * IMP :
      webmail from Horde application framework
      You can find the project page here : http://www.horde.org
    * . To be completed
*/
package org.esupportail.portal.channels.CSMS.serverSending;


import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;

import org.esupportail.portal.channels.CSMS.Etudiant;
import org.esupportail.portal.channels.CSMS.changeProfile.AccesLdap;
import org.esupportail.portal.channels.CSMS.exception.ExceptionAccesLdap;
import org.esupportail.portal.channels.CSMS.exception.ExceptionConfigurationCanal;
import org.esupportail.portal.channels.CSMS.properties.*;
import org.jasig.portal.services.LogService;

import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import java.util.StringTokenizer;


/**
 * <p>Titre : GereDestinataire</p>
 * <p>Description : Permet de gerer le destinataire du message </p>
 * <p>Copyright : Copyright (c) 2004</p>
 * <p>Socit : Universit de Valenciennes et du Hainaut Cambrsis </p>
 * @author Yohan Colmant
 * @version 1.0
 */
public class GereDestinataire {
	
	
	/**
	 * La liste des instituts
	 */
	private TreeSet instituts;
	
	/**
	 * Les formations
	 */
	private TreeSet formations;
	
	/**
	 * Les etudiants
	 */
	private TreeSet etudiants;
	
	/**
	 * Les indices des etudiants que l'on a selectionnes. Ces indices sont ceux dans le TreeSet etudiants
	 */
	private Vector indicesEtudiantsSelectionnes;
	
	/**
	 * L'institut que l'on a deja selectionne
	 */
	private String institutSelectionne;
	
	/**
	 * La formation que l'on a deja selectionnee
	 */
	private String formationSelectionnee;
	
	/**
	 * L'url de l'annuaire
	 */
	private String ldapUrl;
	
	/**
	 * Login ldap
	 */
	private String ldapLogin;
	
	/**
	 * Mot de passe LDAP
	 */
	private String ldapPassword;
	
	/**
	 * La branche groups de l'annuaire
	 */
	private String ldapGroups;
	
	/**
	 * Le filtre pour chercher les instituts
	 */
	private String filtreInstituts;
	
	/**
	 * Le filtre pour chercher les formations
	 */
	private String filtreFormations;
	
	
	
	
	
	
	/**
	 * Constructeur
	 * @throws ExceptionConfigurationCanal
	 */
	public GereDestinataire() throws ExceptionConfigurationCanal {
		//	les parametres de connexion au serveur de multidiffusion
		ProprietesCanal prop = ParseProprietesCanal.getInstance();
		this.ldapUrl = prop.getLdapUrl();
		this.ldapLogin = prop.getLoginLdap();
		this.ldapPassword = prop.getPasswordLdap();
		this.ldapGroups = prop.getLdapGroups();
		this.filtreInstituts = prop.getFiltreInstituts();
		this.filtreFormations = prop.getFiltreFormations();
	}
	
	/**
	 * Initialise les instituts
	 *
	 */
	public void initInstituts() {
		this.instituts = null;
		this.institutSelectionne = null;
	}
	
	/**
	 * Initialise les formations
	 *
	 */
	public void initFormations() {
		this.formations = null;
		this.formationSelectionnee = null;
	}
	
	/**
	 * Initialise les etudiants
	 *
	 */
	public void initEtudiants() {
		this.etudiants = null;
		this.indicesEtudiantsSelectionnes = null;
	}
	
	/**
	 * Initialise les etudiants
	 *
	 */
	public void initIndicesEtudiantsSelectionnes() {		
		this.indicesEtudiantsSelectionnes = new Vector();
	}
	
	/**
	 * Ajoute l'indice d'un etudiant selectionne
	 * @param ind l'indice
	 */
	public void addIndiceEtudiantSelectionne(String ind) {
		this.indicesEtudiantsSelectionnes.addElement(ind);
	}
	
	/**
	 * Retourne l'indice d'un etudiant selectionne
	 * @param index l'indice dans le vecteur
	 * @return l'indice de l'etudiant
	 */
	public int getIndiceEtudiantSelectionne(int index) {
		return Integer.parseInt( (String)this.indicesEtudiantsSelectionnes.elementAt(index) );
	}
	
	/**
	 * Retourne le nombre d'etudiants selectionnes
	 * @return le nombre d'etudiants selectionnes
	 */
	public int getIndicesEtudiantsSelectionnesSize() {
		return this.indicesEtudiantsSelectionnes.size();
	}
	
	/**
	 * Dit si l'index passe en parametre fait partie des indices selectionnes
	 * @param index l'indice a tester
	 * @return true si contient, false sinon
	 */
	public boolean indicesEtudiantsSelectionnesContains(int index) {
		if (this.indicesEtudiantsSelectionnes==null)
			return false;
		return this.indicesEtudiantsSelectionnes.contains(""+index);
	}
	
	
	/**
	 * Dit si la liste des institus est vide ou non
	 * @return true si vide, false sinon
	 */
	public boolean listeInstitutsVide() {
		return instituts==null || instituts.isEmpty();
	}
	
	/**
	 * Dit si aucun institut n'a ete selctionne pour le moment
	 * @return true si aucun, false sinon
	 */
	public boolean aucunInstitutSelectionne() {
		return this.institutSelectionne==null;
	}
	
	/**
	 * Dit si aucune formation n'a ete selctionnee pour le moment
	 * @return true si aucun, false sinon
	 */
	public boolean aucuneFormationSelectionnee() {
		return this.formationSelectionnee==null;
	}
	
	/**
	 * Dit si aucun etudiant n'a ete selctionne pour le moment
	 * @return true si aucun, false sinon
	 */
	public boolean aucunEtudiantSelectionne() {
		return indicesEtudiantsSelectionnes==null;
	}
	
	
	
	/**
	 * Retourne un iterateur d'instituts
	 * @return un iterateur
	 */
	public Iterator getInstitutsIterator() {
		return this.instituts.iterator();
	}
	
	/**
	 * Retourne un iterateur de formations
	 * @return un iterateur
	 */
	public Iterator getFormationsIterator() {
		return this.formations.iterator();
	}
	
	/**
	 * Retourne un iterateur d'etudiants
	 * @return un iterateur
	 */
	public Iterator getEtudiantsIterator() {
		return this.etudiants.iterator();
	}
	
	/**
	 * Renvoie un tableau d'etudiants
	 * @return un tableau
	 */
	public Object[] getArrayOfEtudiants() {
		return this.etudiants.toArray();
	}
	
	/**
	 * Renvoie l'institut qui est selectionne
	 * @return l'institut en cours
	 */
	public String getInstitutSelectionne () {
		return this.institutSelectionne;
	}
	
	/**
	 * Renvoie la formation qui est selectionnee
	 * @return la formation en cours
	 */
	public String getFormationSelectionnee () {
		return this.formationSelectionnee;
	}
	
	
	
	/**
	 * Affecte l'institut selectionne
	 * @param institut l'institut choisi
	 */
	public void setInstitutSelectionne(String institut) {
		this.institutSelectionne = institut;
	}
	
	/**
	 * Affecte la formation selectionne
	 * @param formation la formation choisie
	 */
	public void setFormationSelectionne(String formation) {
		this.formationSelectionnee = formation;
	}
	
	
	
	
	/**
	 * Recupere la liste des instituts dans l'annuaire
	 * @throws ExceptionAccesLdap
	 */
	public void loadInstituts() throws ExceptionAccesLdap {
		
		try {
			instituts = new TreeSet();
		
			// je cherche dans l'annuaire
			String baseDN = this.ldapGroups;
			String providerUrl = this.ldapUrl;
			String filtre = this.filtreInstituts;
		
			// on lance la recherche
			Hashtable env = new Hashtable();
			env.put(Context.INITIAL_CONTEXT_FACTORY, "com.sun.jndi.ldap.LdapCtxFactory");
			env.put(Context.PROVIDER_URL, providerUrl);
		
			env.put(Context.SECURITY_AUTHENTICATION, "simple");
			env.put(Context.SECURITY_PRINCIPAL, ldapLogin);
			env.put(Context.SECURITY_CREDENTIALS, ldapPassword);
		
			DirContext ctx = new InitialDirContext(env);

			SearchControls constraints = new SearchControls();
			constraints.setSearchScope(SearchControls.SUBTREE_SCOPE);

			NamingEnumeration ne = ctx.search(baseDN	, filtre, constraints);

			// on regarde chaque element trouve
			while (ne.hasMoreElements()) {
				SearchResult searchRes = (SearchResult)ne.nextElement();
				Attributes atts =  searchRes.getAttributes();		     
				Attribute att = atts.get("cn");
				NamingEnumeration enum = att.getAll();
				String institut = (String)enum.nextElement();
				instituts.add(institut);
			}
		}
		catch(NamingException e) {
			LogService.log(LogService.ERROR, "GereDestinataire::loadInstituts: "+e);
			throw new ExceptionAccesLdap();
		}
	}
	
	
	
	/**
	 * Recupere la liste des formations de l'institut donne
	 * @param institut l'institut, exemple: istv
	 * @throws ExceptionAccesLdap
	 */
	public void loadFormations(String institut) throws ExceptionAccesLdap {
		
		try {
			formations = new TreeSet();
			this.etudiants = null;
			this.indicesEtudiantsSelectionnes = null;
			
			if (institut != null) {
							
				Vector dnFormations = new Vector();
				String baseDN = this.ldapGroups;
				String providerUrl = this.ldapUrl;
				String filtre = "";
				
				// on lance la recherche
				Hashtable env = new Hashtable();
				env.put(Context.INITIAL_CONTEXT_FACTORY, "com.sun.jndi.ldap.LdapCtxFactory");
				env.put(Context.PROVIDER_URL, providerUrl);
				
				env.put(Context.SECURITY_AUTHENTICATION, "simple");
				env.put(Context.SECURITY_PRINCIPAL, ldapLogin);
				env.put(Context.SECURITY_CREDENTIALS, ldapPassword);
				
				DirContext ctx = new InitialDirContext(env);
	
				SearchControls constraints = new SearchControls();
				constraints.setSearchScope(SearchControls.SUBTREE_SCOPE);			      
				      
				// je recupere la liste des dn des formations de cet institut
				filtre = "(&"+this.filtreInstituts+"(cn="+institut+"))";
				NamingEnumeration ne = ctx.search(baseDN	, filtre, constraints);
	
				// on regarde chaque element trouve
				while (ne.hasMoreElements()) {
					SearchResult searchRes = (SearchResult)ne.nextElement();
				    Attributes atts =  searchRes.getAttributes();		     
				    Attribute att = atts.get("member");
				    NamingEnumeration enum = att.getAll();
				    while (enum.hasMoreElements()) {
				    	String form = (String)enum.nextElement();
				        dnFormations.addElement(form);			        	
				    }
				}			    	
				
				// je cherche les formations dans l'annuaire			      			      
				for (int i=0; i<dnFormations.size(); i++) {
					baseDN = (String)dnFormations.elementAt(i);
				    filtre = "(objectClass=*)";			
				    ne = ctx.search(baseDN , filtre, constraints);
				      
				    // on regarde chaque element trouve
				    while (ne.hasMoreElements()) {
				    	SearchResult searchRes = (SearchResult)ne.nextElement();
				    	Attributes atts =  searchRes.getAttributes();		     
				    	Attribute att = atts.get("cn");
				    	NamingEnumeration enum = att.getAll();
				    	String formation = (String)enum.nextElement();
				    	att = atts.get("description");
				    	enum = att.getAll();
				    	String description = (String)enum.nextElement();
				    	description = description.replaceAll("&","et");			      		
				    	formations.add(formation+"-->"+description);
				    }
				}			      			     			    			    			    	
			}
		}
		catch(NamingException e) {
			LogService.log(LogService.ERROR, "GereDestinataire::loadFormations: "+e);
			throw new ExceptionAccesLdap();
		}	
	}
	
	
	
	/**
	 * Recupere la liste des etudiants de l'institut et de la formation donnes
	 * @param formation la formation, exemple: S3inf0
	 * @throws ExceptionAccesLdap
	 * @throws ExceptionConfigurationCanal
	 */
	public void loadEtudiants(String formation) throws ExceptionAccesLdap, ExceptionConfigurationCanal {
		
		try {
			etudiants = new TreeSet();
			
			if (formation!=null) {			
				
				// le code etape de la formation
				StringTokenizer strToken = new StringTokenizer(formation, "-->");
				String codeEtape = strToken.nextToken();			
				
				Vector dnEtudiants = new Vector();
				String baseDN = this.ldapGroups;
				String providerUrl = this.ldapUrl;
				String filtre = "";
				
				// on lance la recherche
				Hashtable env = new Hashtable();
				env.put(Context.INITIAL_CONTEXT_FACTORY, "com.sun.jndi.ldap.LdapCtxFactory");
				env.put(Context.PROVIDER_URL, providerUrl);
				
				env.put(Context.SECURITY_AUTHENTICATION, "simple");
				env.put(Context.SECURITY_PRINCIPAL, ldapLogin);
				env.put(Context.SECURITY_CREDENTIALS, ldapPassword);
				
				DirContext ctx = new InitialDirContext(env);
	
				SearchControls constraints = new SearchControls();
				constraints.setSearchScope(SearchControls.SUBTREE_SCOPE);
				      
				      
				// je recupere la liste des dn des etudiants de cette formation
				filtre ="(&"+this.filtreFormations+"(cn="+codeEtape+"))"; 
				NamingEnumeration ne = ctx.search(baseDN	, filtre, constraints);
	
				// on regarde chaque element trouve
				while (ne.hasMoreElements()) {
					SearchResult searchRes = (SearchResult)ne.nextElement();
					Attributes atts =  searchRes.getAttributes();		     
					Attribute att = atts.get("member");
					NamingEnumeration enum = att.getAll();
					while (enum.hasMoreElements()) {
				        String form = (String)enum.nextElement();
				        dnEtudiants.addElement(form);			        	
				    }
				}
				    
				
				
				// je cherche les etudiants dans l'annuaire			      			      
				for (int i=0; i<dnEtudiants.size(); i++) {
					baseDN = (String)dnEtudiants.elementAt(i);
					filtre = "(objectClass=*)";			
					ne = ctx.search(baseDN , filtre, constraints);
					
					// on regarde chaque element trouve
					while (ne.hasMoreElements()) {
						SearchResult searchRes = (SearchResult)ne.nextElement();
						Attributes atts =  searchRes.getAttributes();		     
						Attribute att = atts.get("cn");
						NamingEnumeration enum = att.getAll();
						String nomEtudiant = (String)enum.nextElement();
						
						String contactMode = null;
						String email = null;
						String telephone = null;
						
						att = atts.get(ParseProprietesCanal.getInstance().getContactModeAttribute());
						if (att != null) {
							enum = att.getAll();
							contactMode = (String)enum.nextElement();
				      	}
						
						if (contactMode==null) {
							att = atts.get(ParseProprietesCanal.getInstance().getMailAttribute());
					      	if (att != null) {
					      		enum = att.getAll();
					      		email = (String)enum.nextElement();
					      	}
						}
						else if (contactMode.equals(AccesLdap.SMS)) {
							att = atts.get(ParseProprietesCanal.getInstance().getMobileAttribute());
					      	if (att != null) {
					      		enum = att.getAll();
					      		telephone = (String)enum.nextElement();
					      	}
						}
						else if (contactMode.equals(AccesLdap.MAIL_AND_SMS)) {
							att = atts.get(ParseProprietesCanal.getInstance().getMobileAttribute());
					      	if (att != null) {
					      		enum = att.getAll();
					      		telephone = (String)enum.nextElement();
					      	}
					      	
					      	att = atts.get(ParseProprietesCanal.getInstance().getMailAttribute());
							if (att != null) {
								enum = att.getAll();
								email = (String)enum.nextElement();
					      	}				      	
						}
						else {
							att = atts.get(ParseProprietesCanal.getInstance().getMailAttribute());
							if (att != null) {
								enum = att.getAll();
								email = (String)enum.nextElement();
					      	}
						}
						
				      		
				      	Etudiant etudiant = new Etudiant(nomEtudiant, email, telephone);
				      	//System.out.println(etudiant.getName()+" "+etudiant.getEmail()+" "+etudiant.getPhone());			      		
				      	etudiants.add(etudiant);
				      	}
				      }			      			     			
			}
		}
		catch(NamingException e) {
			LogService.log(LogService.ERROR, "GereDestinataire::loadEtudiants: "+e);
			throw new ExceptionAccesLdap();
		}
	}
	
	
	
	
	
}
