/*
ESUP-portail is a french academic project developed under the GPL (General Public License) augmented according to the following :
A binary or source file developped by ESUP-portail can be used or compiled with products under Apache license.
The official english text of the GPL can be found here : http://www.gnu.org/licenses/gpl.html .
A non official french translation can be found here : http://www.linux-France.org/article/these/gpl.html .
The different kinds of licenses governing the products developed by the Apache foundation can be found here : http://www.apache.org/licenses .
It follows that you can as well as use download contents as well modify and redistribute them provided you respect the GPL terms.
Downloading and using such contents do not provide any guaranty.
Be sure that you have well understood the terms of the license before using the contents it covers.
The ESUP-portail distribution includes the following distributions :
    * UPortal : 
      software developed by JA-SIG (Java Architecture - Special Interest Group)
      You can find the license page here : http://mis105.udel.edu/ja-sig/uportal/license.html
    * CAS :
      SSO solution developed by Yale University
      You can find the project page here : http://www.yale.edu/tp/auth
    * Cocoon :
      XML framework distributed by the Apache foundation under Apache license;
      Please find the full text here : http://cocoon.apache.org/2.1/license.html
    * Mod_dav:
      A DAV module for Apache web server
      You can find the project page here : http://www.webdav.org/mod_dav
    * IMP :
      webmail from Horde application framework
      You can find the project page here : http://www.horde.org
    * . To be completed
*/
package org.esupportail.portal.channels.CSMS.smsServerResponse;

import java.util.ArrayList;


/**
 * <p>Titre : ServerReport</p>
 * <p>Description : Garde les donnees du rapport du serveur </p>
 * <p>Copyright : Copyright (c) 2004</p>
 * <p>Socit : Universit de Valenciennes et du Hainaut Cambrsis </p>
 * @author Yohan Colmant
 * @version 1.0
 */


public class RapportServeurSms {
	
	/**
	 * L'id du message envoye
	 */
	private String msgId;
	
	/**
	 * La date d'envoi du message
	 */
	private String msgDate;
	
	/**
	 * Les erreurs renvoyees par le serveur
	 */
	private ArrayList errors = new ArrayList();
	
	
	
	
	
	
	/**
	 * Constructeur	 
	 */
	public RapportServeurSms () {		
	}
	
	/**
	 * Retourne l'id du message envoye
	 * @return l'id du message
	 */
	public String getMsgId() {
		return this.msgId;
	}
	
	/**
	 * Retourne la date d'envoi du message
	 * @return la date d'envoi du message
	 */
	public String getMsgDate() {
		return this.msgDate;
	}
	
	/**
	 * Retourne les erreurs
	 * @return les erreurs
	 */
	public ArrayList getErrors() {
		return this.errors;
	}
	
	
	
	
	
	
	
	/**
	 * Affecte l'id du message envoye
	 * @return l'id du message envoye
	 */
	public void setMsgId(String msgId) {
		this.msgId = msgId;
	}
	
	/**
	 * Affecte la date d'envoi du message
	 * @return la date d'envoi du message
	 */
	public void setMsgDate(String msgDate) {
		this.msgDate = msgDate;
	}
	
	/**
	 * Affecte l'erreur du message le cas echeant
	 * @return l'erreur du message le cas echeant
	 */
	public void setErrors(ErreurServeurSms error) {
		errors.add(error);
	}
	
	
	
	
	
	/**
	 * Renvoie une chaine representant les infos
	 * @return une chaine representant les infos
	 */
	public String toString() {
		String s = "";
				
		s += "Message envoye --> ";
		s += "ID="+this.msgId;
		s += " ... Date="+this.msgDate;
		
		ArrayList list = this.getErrors();
		for (int i=0; i<list.size(); i++) {
			ErreurServeurSms err = (ErreurServeurSms)list.get(i);
			s += "Erreur dans l'envoi --> ";
			s += "Code="+err.getErrorCode();
			s += " ... Module="+err.getErrorModule();
			s += " ... Message="+err.getErrorMessage();
		}
					
		return s;
	}
	
	
	
	
}
