/*
ESUP-portail is a french academic project developed under the GPL (General Public License) augmented according to the following :
A binary or source file developped by ESUP-portail can be used or compiled with products under Apache license.
The official english text of the GPL can be found here : http://www.gnu.org/licenses/gpl.html .
A non official french translation can be found here : http://www.linux-France.org/article/these/gpl.html .
The different kinds of licenses governing the products developed by the Apache foundation can be found here : http://www.apache.org/licenses .
It follows that you can as well as use download contents as well modify and redistribute them provided you respect the GPL terms.
Downloading and using such contents do not provide any guaranty.
Be sure that you have well understood the terms of the license before using the contents it covers.
The ESUP-portail distribution includes the following distributions :
    * UPortal : 
      software developed by JA-SIG (Java Architecture - Special Interest Group)
      You can find the license page here : http://mis105.udel.edu/ja-sig/uportal/license.html
    * CAS :
      SSO solution developed by Yale University
      You can find the project page here : http://www.yale.edu/tp/auth
    * Cocoon :
      XML framework distributed by the Apache foundation under Apache license;
      Please find the full text here : http://cocoon.apache.org/2.1/license.html
    * Mod_dav:
      A DAV module for Apache web server
      You can find the project page here : http://www.webdav.org/mod_dav
    * IMP :
      webmail from Horde application framework
      You can find the project page here : http://www.horde.org
    * . To be completed
*/
package org.esupportail.portal.channels.CSMS.serverSending;



import java.util.Vector;


import org.esupportail.portal.channels.CSMS.changeProfile.AccesLdap;
import org.esupportail.portal.channels.CSMS.exception.ExceptionAccesLdap;
import org.esupportail.portal.channels.CSMS.exception.ExceptionConfigurationCanal;
import org.esupportail.portal.channels.CSMS.exception.ExceptionConfirmationEnvoiSms;
import org.esupportail.portal.channels.CSMS.exception.ExceptionEnvoi;
import org.esupportail.portal.channels.CSMS.exception.ExceptionEnvoiMail;
import org.esupportail.portal.channels.CSMS.exception.ExceptionEnvoiSms;
import org.esupportail.portal.channels.CSMS.exception.ExceptionParametresEnvoiSms;
import org.esupportail.portal.channels.CSMS.exception.ExceptionServeurSmsIndisponible;
import org.esupportail.portal.channels.CSMS.log.Log;
import org.esupportail.portal.channels.CSMS.properties.*;
import org.jasig.portal.services.LogService;

/**
 * <p>Titre : GereMessage</p>
 * <p>Description : Classe permettant de gerer un message </p>
 * <p>Copyright : Copyright (c) 2004</p>
 * <p>Socit : Universit de Valenciennes et du Hainaut Cambrsis </p>
 * @author Yohan Colmant
 * @version 1.0
 */
public class GereMessage {
	
	/**
	 * Sujet du message
	 */
	private String sujet;
	
	/**
	 * Corps du message
	 */
	private String message;

	
	
	
	
	
	/**
	 * Url du serveur pour SMS
	 */
	private String smsServeur;
	
	/**
	 * Login pour serveur SMS
	 */
	private String smsLogin;
	
	/**
	 * Password pour serveur SMS
	 */
	private String smsPassword;
	
	
	

	/**
	 * Url du serveur pour les mails
	 */
	private String mailServeur;
	
	
	
	
	
	
	
	/**
	 * Le login de l'expediteur du message
	 */
	private String loginExpediteur;
	
	/**
	 * Le nom de l'expditeur du message 
	 */
	private String nomExpediteur;
	
	/**
	 * Le mail de l'expediteur du message
	 */
	private String mailExpediteur;
	
	
	/**
	 * Si tout est initialise
	 */
	private boolean initialized = false;
	
	
	
	/**
	 * Constructeur
	 * @throws ExceptionConfigurationCanal
	 */
	public GereMessage() throws ExceptionConfigurationCanal {
		// les parametres de connexion au serveur de multidiffusion
		ProprietesCanal prop = ParseProprietesCanal.getInstance();
		
		this.smsServeur = prop.getSmsServeur();
		this.smsLogin = prop.getSmsLogin();
		this.smsPassword = prop.getSmsPassword();
		
		this.mailServeur = prop.getMailServeur();					
	}
	
	
	
	/**
	 * Dit si le message est vide
	 * @return true si vide, false sinon
	 */
	public boolean messageVide() {
		return message == null;
	}
	
	/**
	 * Affecte le message
	 * @param message le message
	 */
	public void setMessage (String message) {
		this.message = message;
	}
	
	/**
	 * Affecte le sujet
	 * @param sujet le sujet
	 */
	public void setSujet (String sujet) {
		this.sujet = sujet;
	}
	
	/**
	 * Affecte le nom de l'expediteur du message
	 * @param nom le nom de l'expediteur
	 */
	public void setNomExpediteur(String nom) {
		this.nomExpediteur = nom;
	}
	
	
	/**
	 * Affecte le login de connexion au portail de l'expediteur du message
	 * @param login le login de connexion
	 */
	public void setLoginNomMailExpediteur(String login) {
		this.loginExpediteur = login;
		
		try {			
			this.nomExpediteur = AccesLdap.getDisplayName(login).trim();
			this.mailExpediteur = AccesLdap.getMail(login);			
		}
		catch (ExceptionAccesLdap e) {
			this.nomExpediteur = this.loginExpediteur;
		}
		catch (ExceptionConfigurationCanal e) {
			this.nomExpediteur = this.loginExpediteur;
		}
		this.initialized = true;
	}
	
	/**
	 * Si ca a ete initialize
	 * @return true si oui, false sinon
	 */
	public boolean isInitialized() {
		return this.initialized;
	}
	
	/**
	 * Recupere le message
	 * @return le message
	 */
	public String getMessage() {
		return this.message;
	}
	
	/**
	 * Recupere le sujet
	 * @return le sujet
	 */
	public String getSujet() {
		return this.sujet;
	}
		
	/**
	 * Retourne le nom de l'expediteur
	 * @return le nom de l'expediteur
	 */
	public String getNomExpediteur() {
		return this.nomExpediteur;
	}
	
	
	/**
	 * Retourne le login de l'expediteur
	 * @return le login de l'expediteur
	 */
	public String getLoginExpediteur() {
		return this.loginExpediteur;
	}
	
	
	
	
	/**
	 * Initialise sujet et message
	 *
	 */
	public void initMessage() {
		this.message = null;
		this.sujet = null;				
	}
	
	
	
	
	/**
	 * Envoie le SMS et passe en mode resultat
	 * @param destinataires les destinataires du message
	 * @throws ExceptionEnvoi
	 * @throws ExceptionEnvoiMail
	 * @throws ExceptionEnvoiSms
	 * @throws ExceptionConfirmationEnvoiSms
	 * @throws ExceptionConfigurationCanal
	 */
	public void sendMessage(Vector destinataires) throws ExceptionEnvoi, ExceptionEnvoiMail, ExceptionEnvoiSms, ExceptionConfirmationEnvoiSms, ExceptionConfigurationCanal {		
	
		boolean mailOk = true;
		boolean smsOk = true;
		
		// on envoie par mail
		try {
			EnvoieMail mail = new EnvoieMail(sujet, message, mailServeur, mailExpediteur, nomExpediteur);
			mail.sendMessage(destinataires);
		}
		catch(ExceptionEnvoiMail e) {			
			mailOk = false;
			LogService.log(LogService.ERROR, "GereMessage::sendMessage: erreur a l'envoi de mail");
		}
		
		// on envoie par sms
		try {
			EnvoieSms sms = new EnvoieSms(sujet, message, smsServeur, smsLogin, smsPassword, loginExpediteur, nomExpediteur);
			int nombreSms = sms.sendMessage(destinataires);
			

			// on ajoute dans le log de sms si ca s'est bien passe au niveau du serveur			
			String id = sms.getID();
			//System.out.println("id du message: "+id);
			if (id!=null) {
				Log.add(id,this.nomExpediteur,sms.getDateEnvoi(),nombreSms);				
			}
		}
		catch(ExceptionServeurSmsIndisponible e) {
			smsOk = false;
			LogService.log(LogService.ERROR, "GereMessage::sendMessage: erreur a l'envoi de SMS");
		}
		catch(ExceptionParametresEnvoiSms e) {
			smsOk = false;
			LogService.log(LogService.ERROR, "GereMessage::sendMessage: erreur a l'envoi de SMS");
		}
		
		
		// si aucun envoye
		if (!mailOk && !smsOk) {
			throw new ExceptionEnvoi();
		}
		
		else {
		
			if (!mailOk) {		
				throw new ExceptionEnvoiMail();
			}
			else if (!smsOk) {
				throw new ExceptionEnvoiSms();
			}
			else {
				// on initialise le message et le sujet
				initMessage();				
			}
		}
		
	
	}
	
	
	
	
	
}
