/*
ESUP-portail is a french academic project developed under the GPL (General Public License) augmented according to the following :
A binary or source file developped by ESUP-portail can be used or compiled with products under Apache license.
The official english text of the GPL can be found here : http://www.gnu.org/licenses/gpl.html .
A non official french translation can be found here : http://www.linux-France.org/article/these/gpl.html .
The different kinds of licenses governing the products developed by the Apache foundation can be found here : http://www.apache.org/licenses .
It follows that you can as well as use download contents as well modify and redistribute them provided you respect the GPL terms.
Downloading and using such contents do not provide any guaranty.
Be sure that you have well understood the terms of the license before using the contents it covers.
The ESUP-portail distribution includes the following distributions :
    * UPortal : 
      software developed by JA-SIG (Java Architecture - Special Interest Group)
      You can find the license page here : http://mis105.udel.edu/ja-sig/uportal/license.html
    * CAS :
      SSO solution developed by Yale University
      You can find the project page here : http://www.yale.edu/tp/auth
    * Cocoon :
      XML framework distributed by the Apache foundation under Apache license;
      Please find the full text here : http://cocoon.apache.org/2.1/license.html
    * Mod_dav:
      A DAV module for Apache web server
      You can find the project page here : http://www.webdav.org/mod_dav
    * IMP :
      webmail from Horde application framework
      You can find the project page here : http://www.horde.org
    * . To be completed
*/
package org.esupportail.portal.channels.CSMS.smsServerResponse;


/**
 * <p>Titre : ServerError</p>
 * <p>Description : Garde les donnees du rapport du serveur dans le cas d'une erreur d'envoi </p>
 * <p>Copyright : Copyright (c) 2004</p>
 * <p>Socit : Universit de Valenciennes et du Hainaut Cambrsis </p>
 * @author Yohan Colmant
 * @version 1.0
 */


public class ErreurServeurSms {
	
	
	/**
	 * Le code d'erreur le cas echeant
	 */
	private String errorCode;
	
	/**
	 * Le module dans lequel s'est passee l'erreur
	 */
	private String errorModule;
	
	/**
	 * Le message de l'erreur
	 */
	private String errorMessage;
	
	
	
	
	
	
	/**
	 * Constructeur	 
	 */
	public ErreurServeurSms () {		
	}
	
	
	
	/**
	 * Retourne le code d'erreur du message le cas echeant
	 * @return le code d'erreur du message le cas echeant
	 */
	public String getErrorCode() {
		return this.errorCode;
	}
	
	/**
	 * Retourne le module dans lequel s'est produite l'erreur
	 * @return le module dans lequel s'est produite l'erreur
	 */
	public String getErrorModule() {
		return this.errorModule;
	}
	
	/**
	 * Retourne le message d'erreur
	 * @return le message d'erreur
	 */
	public String getErrorMessage() {
		return this.errorMessage;
	}
	
	
	
	
	
	/**
	 * Retourne le code d'erreur du message le cas echeant
	 * @return le code d'erreur du message le cas echeant
	 */
	public void setErrorCode(String errorCode) {
		this.errorCode = errorCode;
	}
	
	/**
	 * Retourne le module dans lequel s'est produite l'erreur
	 * @return le module dans lequel s'est produite l'erreur
	 */
	public void setErrorModule(String errorModule) {
		this.errorModule = errorModule;
	}
	
	/**
	 * Retourne le message d'erreur
	 * @return le message d'erreur
	 */
	public void setErrorMessage(String errorMessage) {
		this.errorMessage = errorMessage;
	}
	
	
	
	
	/**
	 * Renvoie une chaine representant les infos
	 * @return une chaine representant les infos
	 */
	public String toString() {
		String s = "";
		
		if (this.errorCode == null) {
			s = "erreur nulle";
		}
		else {
			s += "Erreur dans l'envoi --> ";
			s += "Code="+this.errorCode;
			s += " ... Module="+this.errorModule;
			s += " ... Message="+this.errorMessage;
		}		
					
		return s;
	}
	
	
	
	
}
