/*
ESUP-portail is a french academic project developed under the GPL (General Public License) augmented according to the following :
A binary or source file developped by ESUP-portail can be used or compiled with products under Apache license.
The official english text of the GPL can be found here : http://www.gnu.org/licenses/gpl.html .
A non official french translation can be found here : http://www.linux-France.org/article/these/gpl.html .
The different kinds of licenses governing the products developed by the Apache foundation can be found here : http://www.apache.org/licenses .
It follows that you can as well as use download contents as well modify and redistribute them provided you respect the GPL terms.
Downloading and using such contents do not provide any guaranty.
Be sure that you have well understood the terms of the license before using the contents it covers.
The ESUP-portail distribution includes the following distributions :
    * UPortal : 
      software developed by JA-SIG (Java Architecture - Special Interest Group)
      You can find the license page here : http://mis105.udel.edu/ja-sig/uportal/license.html
    * CAS :
      SSO solution developed by Yale University
      You can find the project page here : http://www.yale.edu/tp/auth
    * Cocoon :
      XML framework distributed by the Apache foundation under Apache license;
      Please find the full text here : http://cocoon.apache.org/2.1/license.html
    * Mod_dav:
      A DAV module for Apache web server
      You can find the project page here : http://www.webdav.org/mod_dav
    * IMP :
      webmail from Horde application framework
      You can find the project page here : http://www.horde.org
    * . To be completed
*/
package org.esupportail.portal.channels.CSMS.log;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

import org.esupportail.portal.channels.CSMS.exception.ExceptionConfigurationCanal;
import org.esupportail.portal.channels.CSMS.properties.ParseProprietesCanal;
import org.jasig.portal.services.LogService;

/**
 * <p>Titre : Log</p>
 * <p>Description : Classe permettant de gerer un fichier de log </p>
 * <p>Copyright : Copyright (c) 2004</p>
 * <p>Socit : Universit de Valenciennes et du Hainaut Cambrsis </p>
 * @author Yohan Colmant
 * @version 1.0
 */
public class Log {
	
	/**
	 * Le nom du fichier de log
	 */
	public static String fichier;
	
	
	
	/**
	 * Initialise le fichier de log: le cree si il n'existe pas
	 * @throws ExceptionConfigurationCanal
	 */
	public static void init() throws ExceptionConfigurationCanal {
		if (fichier==null)
			fichier = ParseProprietesCanal.getInstance().getLogFile();
		
		File f = new File(fichier);
		
		// si le fichier n'existe pas, on le cree
		if (!f.exists()) {
			try {
				f.createNewFile();
				PrintWriter dataOut = new PrintWriter(new FileOutputStream(fichier, true), true);
				dataOut.println("# Id;Expediteur;Date d'envoi;Nombre de SMS envoyes");
				dataOut.close();
			}
			catch(Exception e) {
				//System.err.println("Ne peut creer le fichier de log "+fichier);
				LogService.log(LogService.ERROR, "Log::init: Ne peut creer le fichier de log "+fichier+" : "+e);
			}
		}		
	}
	
	
	/**
	 * Efface le contenu du fichier log. S'il n'existe pas, on le cree
	 * @throws ExceptionConfigurationCanal
	 */
	public static void clean() throws ExceptionConfigurationCanal {
		File f = new File(fichier);
				
		// si le fichier existe, on l'efface
		if (f.exists())
			f.delete();
		
		// on le recree
		init();
	}
	
	
	/**
	 * Ajoute une ligne au log
	 * @param id l'id du message
	 * @param expediteur l'expediteur du message
	 * @param date la date d'envoi du message
	 * @param nombreSms le nombre de SMS envoyes dans ce message
	 */
	public static void add(String id, String expediteur, String date, int nombreSms) {
		String ligne = id+";"+expediteur+";"+date+";"+nombreSms;
		//System.out.println("ajoute "+ligne); //TODO
		try {
			PrintWriter dataOut = new PrintWriter(new FileOutputStream(fichier, true), true);
			dataOut.println(ligne);
			dataOut.close();
		}
		catch(Exception e) {
			//System.err.println("Ne peut ecrire la ligne dans le log");
			LogService.log(LogService.ERROR, "Log::add: ne peut ecrire la ligne dans le log : "+e);
		}
	}
	
	
	/**
	 * Ajoute une ligne au log
	 * @param ligne une ligne de log
	 */
	public static void add(LogLine ligne) {
		String id = ligne.getID();
		String expediteur = ligne.getExpediteur() ;
		String date = ligne.getDate() ;
		int nombreSms = ligne.getNombreSms() ;
		add(id, expediteur, date, nombreSms);
		LogService.log(LogService.ERROR, "Log::add: ajoute "+id+" "+expediteur+" dans le log : ");
	}
	
	/**
	 * Retourne un lecteur sur les lignes de log
	 * @return un lecteur sur les lignes de log
	 * @throws IOException
	 */
	public static LogReader reader() throws IOException {
		return new LogReader(fichier);
	}
	
	
	
	
}
